<?php

namespace app\db\admin;

use app\model\M_category;
use ltcms\db\Db_raw;

class D_category
{
    /**
     * 信息格式化
     */
    protected function detailed($Result, $format="1")
    {
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']);
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']);
        }
        // 状态
        if (isset($Result['disabled'])) {
            $disabledMap = array();
            $disabledMap["1"] = "开启";
            $disabledMap["0"] = "禁用";
            $Result['disabledFormat'] = isset($disabledMap[$Result['disabled']]) ? $disabledMap[$Result['disabled']] : "";
        }
        // 链接地址
        $Result['linkUrl'] = categoryLinkUrl($Result);
        // 返回结果
        return $Result;
    }

    /**
     * 获取模块分类
     * @param string $paramObj
     */
    public function getModuleData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'dataId' => '',
                'field' => '',
            );
            $dataDefault=array();
            $dataDefault["dataId"]=0;
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->dataType
            );
            if(is_numeric($dataObj->request->dataId)){
                $condition[] = array(
                    "dataId", "=", $dataObj->request->dataId
                );
            }
            try{
                $result=Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->select();
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据
     * @param string $paramObj
     */
    public function getData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'dataId' => '',
                'pid' => '',
                'id' => '',
                'field' => '',
            );
            $dataDefault=array();
            $dataDefault["dataId"]=0;
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->dataType
            );
            $condition[] = array(
                "dataId", "=", $dataObj->request->dataId
            );
            if(is_numeric($dataObj->request->pid)){
                $condition[] = array(
                    "pid", "=", $dataObj->request->pid
                );
            }
            if($dataObj->request->id){
                $ids=is_array($dataObj->request->id)?$dataObj->request->id:explode(",",$dataObj->request->id);
                $condition[] = array(
                    "id", "in", $ids
                );
            }
            try{
                $result=Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->select();
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 所有数据
     * @param string $paramObj
     */
    public function allData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => '',
                'dataId' => '',
                'fieldIndex' => '',
                'name' => '',
                'disabled' => '',
                'pid' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition = array();
            if($dataObj->request->dataType){
                $condition[] = array(
                    "dataType", "=", $dataObj->request->dataType
                );
            }
            if(is_numeric($dataObj->request->dataId)){
                $condition[] = array(
                    "dataId", "=", $dataObj->request->dataId
                );
            }
            if ($dataObj->request->fieldIndex) {
                $condition[] = array(
                    "fieldIndex", "=", $dataObj->request->fieldIndex
                );
            }
            if (is_numeric($dataObj->request->disabled)) {
                $condition[] = array(
                    "disabled", "=", $dataObj->request->disabled
                );
            }
            if (is_numeric($dataObj->request->pid)) {
                $condition[] = array(
                    "pid", "=", $dataObj->request->pid
                );
            }
            if ($dataObj->request->name) {
                $condition[] = array(
                    "name", "like", "%{$dataObj->request->name}%"
                );
            }
            try{
                $result=Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->order("sort","asc")->select();
                $return=array();
                if($result) {
                    if($dataObj->request->format=="cache"){
                        $temp=array();
                        foreach($result as $val){
                            $temp[$val["dataType"]."_".$val["dataId"]][$val["id"]]=$val;
                        }
                        $return=$temp;
                    }else{
                        foreach ($result as $key => $val) {
                            $return[] = $this->detailed($val);
                        }
                    }
                }
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => 'require',
                'dataId' => 'require',
                'name' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->dataType
            );
            $condition[] = array(
                "dataId", "=", $dataObj->request->dataId
            );
            if ($dataObj->request->name) {
                $raw=new Db_raw();
                $raw->setContent("LOCATE('{$dataObj->request->name}',`name`)");
                $condition[] = array(
                    $raw, ">", 0
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->order("id", "desc")->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        $result["data"][$key] = $this->detailed($val);
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'field' => '',
                'verify' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    $final_arr["result"] =$this->detailed($result);
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 检测名称
     * @param string $paramObj
     */
    public function checkName($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => '',
                'pid' => 'require',
                'name' => 'require',
                'dataType' => 'require',
                'dataId' => 'require',
                'field' => '',
                'verify' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $dataDefault["pid"] = "0";
            $dataDefault["verify"] = "1";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->dataType
            );
            $condition[] = array(
                "dataId", "=", $dataObj->request->dataId
            );
            $condition[] = array(
                "name", "=", $dataObj->request->name
            );
            $condition[] = array(
                "pid", "=", $dataObj->request->pid
            );
            if($dataObj->request->id){
                $condition[] = array(
                    "id", "!=", $dataObj->request->id
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->find();
                if($dataObj->request->verify){
                    if ($result) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_EXIST, lang("sys.dataExists"));
                    }
                }
                if($result){
                    $final_arr["result"]=$result;
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取子元素数据
     * @param string $paramObj
     */
    public function getChildVal($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'dataId' => 'require',
                'id' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->dataType,
            );
            $condition[] = array(
                "dataId", "=", $dataObj->request->dataId,
            );
            try{
                $result=Db()->name(app("cmsTable")::category())->field("id,name,pid")->where($condition)->select();
                $return=array();
                if($result) {
                    foreach ($result as $key => $val) {
                        $temp = $this->detailed($val);
                        $return[] = $temp;
                    }
                }
                $data=app("ltcmsFormat")->getChildValByRe($return,$dataObj->request->id);
                $final_arr["result"]=$data;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取父级元素数据
     * @param string $paramObj
     */
    public function getParentVal($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'dataId' => 'require',
                'id' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->dataType
            );
            $condition[] = array(
                "dataId", "=", $dataObj->request->dataId
            );
            try{
                $result=Db()->name(app("cmsTable")::category())->field("id,name,pid")->where($condition)->select();
                $return=array();
                if($result) {
                    foreach ($result as $key => $val) {
                        $temp = $this->detailed($val);
                        $return[] = $temp;
                    }
                }
                $data=app("ltcmsFormat")->getParentValByRe($return,$dataObj->request->id);
                $arr=array();
                $arr["id"]=$dataObj->request->id;
                $arr["data"]=$data;
                $final_arr["result"]=$arr;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取父级ids
     */
    public function getParentIds($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $condition=array();
                $condition[]=array(
                    "id","=",$dataObj->request->id,
                );
                $listData=Db()->name(app("cmsTable")::category())->field("id,name,pid")->where($condition)->select();
                $return=array();
                if($listData){
                    foreach($listData as $key=>$val){
                        if($final_arr["error_no"]==0){
                            $return[]=$val["id"];
                            if($val["pid"] >0){
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "id"=>$val["pid"],
                                );
                                $checkResult=$this->getParentIds($paramsObj);
                                if($checkResult["error_no"]==0){
                                    $return=array_merge($return,$checkResult["result"]);
                                }else{
                                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                }
                            }
                        }
                        if($final_arr["error_no"]){
                            break;
                        }
                    }
                }
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取父级数据
     */
    public function getParentData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require',
                'field' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="id,name,pid";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $condition=array();
                $condition[]=array(
                    "id","=",$dataObj->request->id,
                );
                $listData=Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->select();
                $return=array();
                if($listData){
                    foreach($listData as $key=>$val){
                        if($final_arr["error_no"]==0){
                            $return[]=$val;
                            if($val["pid"] >0){
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "id"=>$val["pid"],
                                );
                                $checkResult=$this->getParentData($paramsObj);
                                if($checkResult["error_no"]==0){
                                    $return=array_merge($return,$checkResult["result"]);
                                }else{
                                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                }
                            }
                        }
                        if($final_arr["error_no"]){
                            break;
                        }
                    }
                }
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取子级数据
     */
    public function getChildData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require',
                'field' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="id,name,pid";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            try{
                $condition=array();
                $condition[]=array(
                    "pid","=",$dataObj->request->id,
                );
                $listData=Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->select();
                $return=array();
                if($listData){
                    foreach($listData as $key=>$val){
                        if($final_arr["error_no"]==0){
                            $return[]=$val;
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "id"=>$val["id"],
                            );
                            $checkResult=$this->getChildData($paramsObj);
                            if($checkResult["error_no"]==0){
                                $return=array_merge($return,$checkResult["result"]);
                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]){
                            break;
                        }
                    }
                }
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     */
    public function record($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'name' => 'require',
                'dataType' => 'require',
                'dataId' => 'require',
                'catDir' => '',
                'disabled' => '',
                'fieldIndex' => '',
                'thumb' => '',
                'sort' => '',
                'pid' => '',
                'seo_title' => '',
                'seo_keywords' => '',
                'seo_description' => '',
                'style' => '',
                'level' => '',
                'template_list' => '',
                'template_content' => '',
            );
            $dataDefault = array();
            $dataDefault["pid"]=0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        if($final_arr["error_no"]==0){
            //锁定操作
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'pid' => $dataObj->request->pid,
                'name' => $dataObj->request->name,
                'dataType' => $dataObj->request->dataType,
                'dataId' => $dataObj->request->dataId,
                'field' => "id",
                'verify' => "0",
            );
            $checkResult=$this->checkName($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result=$checkResult["result"];
                if(!$result){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'name' => $dataObj->request->name,
                        'dataType' => $dataObj->request->dataType,
                        'dataId' => $dataObj->request->dataId,
                        'catDir' => $dataObj->request->catDir,
                        'disabled' => $dataObj->request->disabled,
                        'fieldIndex' => $dataObj->request->fieldIndex,
                        'thumb' => $dataObj->request->thumb,
                        'sort' => $dataObj->request->sort,
                        'pid' => $dataObj->request->pid,
                        'seo_title' => $dataObj->request->seo_title,
                        'seo_keywords' => $dataObj->request->seo_keywords,
                        'seo_description' => $dataObj->request->seo_description,
                        'style' => $dataObj->request->style,
                        'level' => $dataObj->request->level,
                        'template_list' => $dataObj->request->template_list,
                        'template_content' => $dataObj->request->template_content,
                    );
                    $checkResult=$this->store($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $return=array();
                        $return["id"]=$checkResult["result"]["id"];
                        $final_arr["result"]=$return;
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    $return=array();
                    $return["id"]=$result["id"];
                    $final_arr["result"]=$return;
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 创建数据
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'name' => 'require',
                'dataType' => 'require',
                'dataId' => 'require',
                'catDir' => '',
                'disabled' => '',
                'fieldIndex' => '',
                'thumb' => '',
                'sort' => '',
                'pid' => '',
                'seo_title' => '',
                'seo_keywords' => '',
                'seo_description' => '',
                'style' => '',
                'level' => '',
                'template_list' => '',
                'template_content' => '',
            );
            $dataDefault = array();
            $dataDefault["pid"]=0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'pid' => is_numeric($dataObj->request->pid)?$dataObj->request->pid:0,
                'name' => $dataObj->request->name,
                'dataType' => $dataObj->request->dataType,
                'dataId' => $dataObj->request->dataId,
            );
            $checkResult=$this->checkName($paramsObj);
            if ($checkResult["error_no"] == 0) {

            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if($final_arr["error_no"]==0){
            //锁定操作
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "dataType"=>$dataObj->request->dataType."_".$dataObj->request->dataId,
            );
            $checkResult=app("S_Admin_categoryOp")->lock($paramsObj);
            if($checkResult["error_no"]==0){

            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->request->pid){
                //获取父级ID
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$dataObj->request->pid,
                );
                $checkResult=$this->getParentData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $parentResult=$checkResult["result"];
                    $parents = array();
                    if($parentResult){
                        $parents=array_column($parentResult,"id");
                    }
                    $dataObj->data->arr_parent_id=$parents;
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else{
                $dataObj->data->arr_parent_id=array();
            }
        }
        if ($final_arr["error_no"] == 0) {
            try {
                $fields=M_category::getFields();
                $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
                $data["parent_count"]=count($dataObj->data->arr_parent_id);
                $data["arr_parent_id"]=implode(',', array_reverse($dataObj->data->arr_parent_id));
                $data["arr_child_id"]="";
                $data["createTime"] = app("ltcmsTime")::getTime();
                $data["updateTime"] = $data["createTime"];
                $result = Db()->name(app("cmsTable")::category())->data($data)->insert();
                if($result["insert_id"] >0){
                    //如果目录为空，则初始化为id
                    $dataObj->data->insertId=$result["insert_id"];
                    $return = array();
                    $return["id"] = $result["insert_id"];
                    $return["affected_rows"] = $result["affected_rows"];
                    $return["dataType"] = $dataObj->request->dataType;
                    $return["dataId"] = $dataObj->request->dataId;
                    $final_arr["result"] =$return;
                    if(!$data["catDir"]){
                        if ($final_arr["error_no"] == 0) {
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "id"=>$result["insert_id"],
                                "catDir"=>$result["insert_id"],
                            );
                            $checkResult=$this->updateData($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                    }
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        if ($final_arr["error_no"] == 0) {
            //更新父级子元素数据
            if($dataObj->data->arr_parent_id){
                foreach($dataObj->data->arr_parent_id as $pid){
                    if ($final_arr["error_no"] == 0) {
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "id"=>$pid
                        );
                        $checkResult=$this->getChildData($paramsObj);
                        if ($checkResult["error_no"] == 0) {
                            $childData=$checkResult["result"];
                            $childs = array();
                            if($childData){
                                $childs=array_column($childData,"id");
                            }
                            if($childs){
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "id"=>$pid,
                                    'arr_child_id' =>implode(',', $childs),
                                    'child' => '1',
                                );
                                $checkResult=$this->updateData($paramsObj);
                                if ($checkResult["error_no"] == 0) {

                                }else{
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                        }else{
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                    if ($final_arr["error_no"]) {
                        break;
                    }
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 更新子集数据
     * @param string $paramObj
     */
    public function updateData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'arr_child_id' => '',
                'arr_parent_id' => '',
                'child' => '',
                'linkurl' => '',
                'catDir' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            $fields=M_category::getFields();
            $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
            if ($data) {
                $data["updateTime"] = app("ltcmsTime")::getTime();
                try {
                    $result = Db()->name(app("cmsTable")::category())->where($condition)->data($data)->update();
                    if($result["affected_rows"] >= "0"){
                        $return = array();
                        $return["id"] = $dataObj->request->id;
                        $return["affected_rows"] = $result["affected_rows"];
                        $final_arr["result"] =$return;
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                    }
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新数据
     * @param string $paramObj
     */
    public function update($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'catDir' => '',
                'name' => '',
                'disabled' => '',
                'fieldIndex' => '',
                'thumb' => '',
                'sort' => '',
                'pid' => '',
                'seo_title' => '',
                'seo_keywords' => '',
                'seo_description' => '',
                'style' => '',
                'level' => '',
                'linkurl' => '',
                'child_count' => '',
                'template_list' => '',
                'template_content' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "verify" => 1,
            );
            $checkResult = $this->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->infoData=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->data->infoData["pid"]!=$dataObj->request->pid){
                $dataObj->data->change=1;
            }else{
                $dataObj->data->change=0;
            }
        }
        if ($final_arr["error_no"] == 0) {
            if( $dataObj->data->change){
                if($dataObj->request->pid){
                    //获取父级ID
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$dataObj->request->pid,
                    );
                    $checkResult=$this->getParentData($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $parentResult=$checkResult["result"];
                        $parents = array();
                        if($parentResult){
                            $parents=array_column($parentResult,"id");
                        }
                        $dataObj->data->arr_parent_id=$parents;
                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    $dataObj->data->arr_parent_id=array();
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            if( $dataObj->data->change){
                if($dataObj->data->infoData["pid"]){
                    //获取旧父级ID
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$dataObj->data->infoData["pid"],
                    );
                    $checkResult=$this->getParentData($paramsObj);
                    if ($checkResult["error_no"] == 0) {
                        $oldParentResult=$checkResult["result"];
                        $oldParents = array();
                        if($oldParentResult){
                            $oldParents=array_column($oldParentResult,"id");
                        }
                        $dataObj->data->old_arr_parent_id=$oldParents;
                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    $dataObj->data->old_arr_parent_id=array();
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            if(isset($dataObj->request->pid) || isset($dataObj->request->name)){
                $pid=isset($dataObj->request->pid)?$dataObj->request->pid:$dataObj->data->infoData["pid"];
                $name=isset($dataObj->request->name)?$dataObj->request->name:$dataObj->data->infoData["name"];
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'pid' => is_numeric($pid)?$pid:0,
                    'name' => $name,
                    "id" => $dataObj->request->id,
                    "dataType" => $dataObj->data->infoData["dataType"],
                    "dataId" => $dataObj->data->infoData["dataId"],
                );
                $checkResult=$this->checkName($paramsObj);
                if ($checkResult["error_no"] == 0) {

                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        if($final_arr["error_no"]==0){
            //锁定操作
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "dataType"=>$dataObj->data->infoData["dataType"]."_".$dataObj->data->infoData["dataId"],
            );
            $checkResult=app("S_Admin_categoryOp")->lock($paramsObj);
            if($checkResult["error_no"]==0){

            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            $fields=M_category::getFields();
            $data=app("ltcmsFormat")->modelData($fields,$dataObj->request);
            if(isset($dataObj->request->pid)){
                $data["parent_count"]=count($dataObj->data->arr_parent_id);
            }
            if($dataObj->data->change){
                $data["arr_parent_id"]=implode(',', array_reverse($dataObj->data->arr_parent_id));
            }
            if ($data) {
                $data["updateTime"] = app("ltcmsTime")::getTime();
                try {
                    $result = Db()->name(app("cmsTable")::category())->where($condition)->data($data)->update();
                    if($result["affected_rows"] >= "0"){
                        $return = array();
                        $return["id"] = $dataObj->request->id;
                        $return["dataType"] = $dataObj->data->infoData["dataType"];
                        $return["dataId"] = $dataObj->data->infoData["dataId"];
                        $return["affected_rows"] = $result["affected_rows"];
                        $final_arr["result"] =$return;
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                    }
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $return = array();
                $return["id"] = $dataObj->request->id;
                $return["dataType"] = $dataObj->data->infoData["dataType"];
                $return["dataId"] = $dataObj->data->infoData["dataId"];
                $return["affected_rows"] = 0;
                $final_arr["result"] = $return;
            }
        }
        if ($final_arr["error_no"] == 0) {
            //更新父级子元素数据
            if($dataObj->data->change && $dataObj->data->arr_parent_id){
                foreach($dataObj->data->arr_parent_id as $pid){
                    if ($final_arr["error_no"] == 0) {
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "id"=>$pid
                        );
                        $checkResult=$this->getChildData($paramsObj);
                        if ($checkResult["error_no"] == 0) {
                            $childData=$checkResult["result"];
                            $childs = array();
                            if($childData){
                                $childs=array_column($childData,"id");
                            }
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "id"=>$pid,
                                'arr_child_id' =>$childs?implode(',', $childs):"",
                                'child' => $childs?1:0,
                            );
                            $checkResult=$this->updateData($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }else{
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                    if ($final_arr["error_no"]) {
                        break;
                    }
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->data->change){
                //更新子集数据
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$dataObj->request->id
                );
                $checkResult=$this->getChildData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $childData=$checkResult["result"];
                    if($childData){
                        foreach($childData as $val){
                            if ($final_arr["error_no"] == 0) {
                                //获取父级ID
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "id"=>$val["pid"],
                                );
                                $checkResult=$this->getParentData($paramsObj);
                                if ($checkResult["error_no"] == 0) {
                                    $parentResult=$checkResult["result"];
                                    $parents = array();
                                    if($parentResult){
                                        $parents=array_column($parentResult,"id");
                                    }
                                    $paramsObj=paramsObj();
                                    $paramsObj->params=array(
                                        "id"=>$val["id"],
                                        'arr_parent_id' =>$parents?implode(',', $parents):"",
                                    );
                                    $checkResult=$this->updateData($paramsObj);
                                    if ($checkResult["error_no"] == 0) {

                                    }else{
                                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                    }
                                } else {
                                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                }
                            }
                            if ($final_arr["error_no"]) {
                                break;
                            }
                        }
                    }
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            //更新旧父级子元素数据
            if($dataObj->data->change && $dataObj->data->old_arr_parent_id){
                foreach($dataObj->data->old_arr_parent_id as $pid){
                    if ($final_arr["error_no"] == 0) {
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "id"=>$pid
                        );
                        $checkResult=$this->getChildData($paramsObj);
                        if ($checkResult["error_no"] == 0) {
                            $childData=$checkResult["result"];
                            $childs = array();
                            if($childData){
                                $childs=array_column($childData,"id");
                            }
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "id"=>$pid,
                                'arr_child_id' =>$childs?implode(',', $childs):"",
                                'child' => $childs?1:0,
                            );
                            $checkResult=$this->updateData($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            }else{
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }else{
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                    if ($final_arr["error_no"]) {
                        break;
                    }
                }
            }
        }
        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }

    /**
     * 初始化分类数据
     * @param string $paramObj
     */
    public function init($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "verify" => 1,
            );
            $checkResult = $this->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->infoData=$checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if($dataObj->data->infoData["pid"]){
                //获取父级数据
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$dataObj->data->infoData["pid"],
                );
                $checkResult=$this->getParentData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $parentResult=$checkResult["result"];
                    $parents = array();
                    if($parentResult){
                        $parents=array_column($parentResult,"id");
                    }
                    $dataObj->data->arr_parent_id=$parents;
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else{
                $dataObj->data->arr_parent_id=array();
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取子集数据
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$dataObj->data->infoData["id"]
            );
            $checkResult=$this->getChildData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $childData=$checkResult["result"];
                $childs = array();
                if($childData){
                    $childs=array_column($childData,"id");
                }
                $dataObj->data->arr_child_id=$childs;
            }else{
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $childs=$dataObj->data->arr_child_id;
            $parents=$dataObj->data->arr_parent_id;
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            $data=array();
            $data["arr_parent_id"]=$parents?implode(',', $parents):"";
            $data["arr_child_id"]=$childs?implode(',', $childs):"";
            $data["child"]=$childs?1:0;
            $data["parent_count"]=count($dataObj->data->arr_parent_id);
            $data["child_count"]=count($dataObj->data->arr_child_id);
            if ($data) {
                $data["updateTime"] = app("ltcmsTime")::getTime();
                try {
                    Db()->name(app("cmsTable")::category())->where($condition)->data($data)->update();
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新 单条-linkurl 数据
     * @param string $paramObj
     */
    public function updateRowLinkurl($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
                "verify" => 1,
            );
            $checkResult = $this->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->data->infoData=$this->detailed($checkResult["result"]);
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $listRule=getModuleListUrlRule($dataObj->data->infoData["dataId"])["rule"];
            $replace=array(
                "catdir"=>$dataObj->data->infoData["catDir"],
                "catid"=>$dataObj->data->infoData["id"],
                "catname"=>$dataObj->data->infoData["name"],
            );
            $linkurl=urlRuleReplace($replace,$listRule);
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>$dataObj->data->infoData["id"],
                "linkurl"=>$linkurl,
            );
            $checkResult=$this->updateData($paramsObj);
            if ($checkResult["error_no"] == 0) {

            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 更新 linkurl 数据
     * @param string $paramObj
     */
    public function updateLinkurl($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => 'require',
                'dataId' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->dataType
            );
            if($dataObj->request->dataId){
                $condition[] = array(
                    "dataId", "=", $dataObj->request->dataId
                );
            }
            try{
                $result=Db()->name(app("cmsTable")::category())->field("id")->where($condition)->select();
                if($result) {
                    foreach ($result as $key => $val) {
                        if ($final_arr["error_no"] == 0) {
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "id"=>$val["id"],
                            );
                            $checkResult=$this->updateRowLinkurl($paramsObj);
                            if ($checkResult["error_no"] == 0) {

                            } else {
                                $final_arr = logCallErrorMsg($final_arr, $checkResult);
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                }
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 删除数据
     * @param string $paramObj
     */
    public function delete($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            foreach($ids as $id){
                if($final_arr["error_no"]==0){
                    //检测是否有修改操作
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "id"=>$id,
                        "field"=>"id,pid,dataType,dataId",
                    );
                    $checkResult=$this->info($paramsObj);
                    if($checkResult["error_no"]==0){
                        $result=$checkResult["result"];
                        if($result){
                            $dataObj->data->infoData=$result;
                            if ($final_arr["error_no"] == 0) {
                                Db()->startTrans();
                                $dataObj->data->use_trans = true;
                            }
                            if($final_arr["error_no"]==0){
                                //锁定操作
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "dataType"=>$dataObj->data->infoData["dataType"]."_".$dataObj->data->infoData["dataId"],
                                );
                                $checkResult=app("S_Admin_categoryOp")->lock($paramsObj);
                                if($checkResult["error_no"]==0){

                                }else{
                                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                }
                            }
                            if ($final_arr["error_no"] == 0) {
                                $condition = array();
                                $condition[] = array(
                                    "id", "=", $id
                                );
                                try {
                                    Db()->name(app("cmsTable")::category())->where($condition)->delete();
                                } catch (\Throwable $e) {
                                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                                }
                            }
                            if ($dataObj->data->use_trans) {
                                if ($final_arr["error_no"] == 0) {
                                    Db()->commitTrans();
                                } else {
                                    Db()->rollbackTrans();
                                }
                            }
                        }
                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
                if($final_arr["error_no"]){
                    break;
                }
            }
        }

        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}