<?php

namespace app\client\api;

class C_file
{
    /**
     * KindEditor 文件上传
     */
    public function kindEditorFileUpload($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->params=array(
            "rootPath"=>str_replace("\\","/",publicPath()),
            "uploadPath"=>"upload/".app("ltcmsTime")::getDateTime("Ym/d"),
        );
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("P_file")->fileUpload($paramsObj);
        if($checkResult["error_no"]==0){
            $result=$checkResult["result"];
            $apiResult=array(
                "error"=>0,
                "url"=>$result["remoteUploadPath"],
            );
            return $apiResult;
        }else{
            recordErrorLog($checkResult); //记录错误信息
            $apiResult=array(
                "error"=>1,
                "message"=>$checkResult["error_msg"],
            );
            return $apiResult;
        }
    }

    /**
     * 文件上传
     */
    public function fileUpload($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->params=array(
            "rootPath"=>str_replace("\\","/",publicPath()),
            "uploadPath"=>"upload/".app("ltcmsTime")::getDateTime("Ym/d"),
        );
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("P_file")->fileUpload($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 获取远程资源内容
     */
    public function getRemoteContent($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("P_file")->getRemoteContent($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 检测分片信息
     */
    public function checkMultipartUpload($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("P_file")->checkMultipartUpload($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 百度上传插件
     */
    public function webUploader($paramObj=""){
        $uploadPath=request()->param("uploadPath","");
        if(!$uploadPath){
            $uploadPath="upload/".app("ltcmsTime")::getDateTime("Ym/d");
        }else{
            $uploadPath="upload/".$uploadPath;
        }
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->params=array(
            "rootPath"=>str_replace("\\","/",publicPath()),
            "uploadPath"=>$uploadPath,
        );
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("P_file")->webUploader($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 分片上传执行
     */
    public function multipartUpload($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->params=array(
            "rootPath"=>str_replace("\\","/",publicPath()),
            "uploadPath"=>"upload/".app("ltcmsTime")::getDateTime("Ym/d"),
        );
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("P_file")->multipartUpload($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 合并文件
     */
    public function mergeMultipartUpload($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj->params=array(
            "rootPath"=>str_replace("\\","/",publicPath()),
            "uploadPath"=>"upload/".app("ltcmsTime")::getDateTime("Ym/d"),
        );
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("P_file")->mergeMultipartUpload($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }

    /**
     * 文件下载
     */
    public function downloadFile(){
        $filePath=request()->param("file","");
        app("ltcmsDownload")->downloadFile($filePath);
    }

    /**
     * 多线程下载
     */
    public function multiDownload(){
        $filePath=request()->param("file","");
        $savePath=request()->param("savePath","");
        app("ltcmsDownload")->multiDownload($filePath,$savePath);
    }

    /**
     * 单线程下载
     */
    public function downloadUrl(){
        $filePath=request()->param("file","");
        $num=request()->param("num",0);
        app("ltcmsDownload")->downloadUrl($filePath,$num);
    }

    /**
     * 获取文件列表
     */
    public function showDir($paramObj=""){
        $paramsObj=paramsObj();
        $paramsObj->mixed=1;
        $paramsObj=blenderObject($paramsObj,$paramObj);
        $checkResult=app("L_Api_files")->showDir($paramsObj);
        if($checkResult["error_no"]==0){
            return apiResult(true,"success",0,$checkResult["result"],$checkResult["extra"]);
        }else{
            recordErrorLog($checkResult); //记录错误信息
            return apiResult(false,$checkResult["error_msg"],$checkResult["error_no"]);
        }
    }
}
