<?php

router()->group("",function () {

    /**
     * 默认方法
     */
    router()->get("test/phpVersion", "Test/phpVersion");
    router()->get("test", "Test/index");
    router()->get("test/download", "Test/download");
    router()->get("test/getSecretKey", "Test/getSecretKey");

    /**
     * 生成站点地图
     */
    router()->post("sitemaps/store", "Sitemaps/store");
    router()->get("sitemaps/store", "Sitemaps/store");

    /**
     * 设置
     */
    router()->post("setting/store", "Setting/store");

    /**
     * 域名授权
     */
    router()->get("domainAuth/handle", "Domain_auth/handle"); //授权过期处理方法

    /**
     * 文章列表
     */
    router()->get("article/listData", "Article/listData");

    /**
     * 代码混淆
     */
    router()->get('codeObscure/encoder', "common/CodeObscure/encoder");

    /**
     * 缓存
     */
    router()->post('cache/op', "Cache/op");

    /**
     * 数据库-迁移
     */
    router()->get('migrate/exportInstallTable', "Migrate/exportInstallTable");

    /**
     * 新闻
     */
    router()->get('news/listData', "News/listData"); //列表数据
    router()->get('news/info', "News/info"); //信息

    /**
     * 流量数据
     */
    router()->post('flow_data/store', "Flow_data/store"); //创建资源

    /**
     * 商品数据
     */
    router()->get('plugin', "index/Goods/pluginList");
    router()->get('plugin/info', "index/Plugin/info");

    router()->get('execScript/install', "Install/install"); //安装脚本
    router()->get('execScript/pluginInstall', "Install/pluginInstall"); //安装插件

    /**
     * 龙腾账号退出
     */
    router()->get('ltcmsUsers/logout', "LtcmsUsers/logout"); //用户退出
},["securityXss"]);

router()->group("",function () {

    /**
     * 文件上传
     */
    router()->get('file/downloadUrl', "File/downloadUrl");//单线程下载
    router()->get('file/multiDownload', "File/multiDownload");//多线程下载
    router()->get('file/downloadFile', "File/downloadFile");//文件下载
    router()->post('file/fileUpload', "File/fileUpload");// 文件上传
    router()->post('file/kindEditorFileUpload', "File/kindEditorFileUpload");//KindEditor 文件上传
    router()->post('file/getRemoteContent', "File/getRemoteContent");//获取远程资源内容
    router()->post('file/checkMultipartUpload', "File/checkMultipartUpload");//检测分片信息
    router()->post('file/multipartUpload', "File/multipartUpload");//分片上传执行
    router()->post('file/mergeMultipartUpload', "File/mergeMultipartUpload");//合并文件
    router()->post('file/webUploader', "File/webUploader");//百度上传插件
    router()->get('file/files', "File/files");

},["isAdminAuth", "isAdminLogin"]);

/**
 * API接口
 */
router()->group("v:_api_version_",function () {
    router()->get('test', "Test/index");//测试版本1
    router()->get('test/db',"Test/db");//测试数据库

    //获取文章信息

    //获取模块信息
    router()->get('module', "Module/getData");

    //获取分类信息
    router()->get('category', "Category/getData");

    //获取广告列表
    router()->get('ad_position', "Ad_position/getList");

    //获取友链列表
    router()->get('friend_link', "Friend_link/getList");

    //文章管理
    router()->get('article/recommend', "Article/recommend");
    router()->get('article/list', "Article/getList");
    router()->get('article/correlation', "Article/getCorrelationList");
    router()->get('article/rand', "Article/randData");
    router()->get('article/pre', "Article/pre");
    router()->get('article/next', "Article/next");
    router()->get('article/doc', "Article/docData");
},["securityXss"]);



