<?php

namespace app\api\controller\v1;
/**
 * @name 文章
 */
class Article
{
    /**
     * @name 推荐文章
     * @path /api/v1/article/recommend
     * @param integer moduleId 模型ID optional
     * @param integer categoryId 分类ID optional
     * @param integer level 文章级别 require
     * @param integer length 文章标题截取长度 optional
     * @param string suffix 截取文字后缀 optional
     * @method get
     */
    public function recommend()
    {
        $response=app("C_Index_article")->getRecommend();
        return jsonResponse($response);
    }

    /**
     * @name 文章列表
     * @path /api/v1/article/list
     * @param integer moduleId 模型ID require
     * @param integer categoryId 分类ID optional
     * @param integer size 条数 optional
     * @param integer page 页数 optional
     * @param integer length 文章标题截取长度 optional
     * @param string suffix 截取文字后缀 optional
     * @method get
     */
    public function getList()
    {
        $response=app("C_Index_article")->getList();
        return jsonResponse($response);
    }

    /**
     * @name 相关推荐文章
     * @path /api/v1/article/correlation
     * @param integer moduleId 模型ID require
     * @param integer articleId 文章ID require
     * @param integer size 条数 optional
     * @method get
     */
    public function getCorrelationList()
    {
        $response=app("C_Index_article")->getCorrelationList();
        return jsonResponse($response);
    }

    /**
     * @name 随机数据
     * @path /api/v1/article/rand
     * @param integer moduleId 模型ID optional
     * @param integer categoryId 分类ID optional
     * @param integer size 条数 optional
     * @param integer length 文章标题截取长度 optional
     * @param string suffix 截取文字后缀 optional
     * @method get
     */
    public function randData()
    {
        $response=app("C_Index_article")->randData();
        return jsonResponse($response);
    }

    /**
     * @name 获取上一篇
     * @path /api/v1/article/pre
     * @param integer moduleId 模型ID require
     * @param integer articleId 文章ID require
     * @method get
     */
    public function pre()
    {
        $response=app("C_Index_article")->pre();
        return jsonResponse($response);
    }

    /**
     * @name 获取下一篇
     * @path /api/v1/article/next
     * @param integer moduleId 模型ID require
     * @param integer articleId 文章ID require
     * @method get
     */
    public function next()
    {
        $response=app("C_Index_article")->next();
        return jsonResponse($response);
    }

    /**
     * @name 文档数据
     * @path /api/v1/article/doc
     * @param integer moduleId 模型ID require
     * @param integer categoryPid 分类ID optional
     * @method get
     */
    public function docData()
    {
        $response=app("C_Index_article")->docData();
        return jsonResponse($response);
    }
}