<?php

namespace app\api\controller;

use app\client\api\C_file;

class File
{
    public $c_file;

    public function __construct()
    {
        $this->c_file = new C_file();
    }

    /**
     * 文件下载
     */
    public function downloadFile()
    {
        noCache();
        continueExec();//默认五分钟
        app("C_Api_file")->downloadFile();
    }

    /**
     * 多线程下载
     */
    public function multiDownload()
    {
        noCache();
        continueExec();//默认五分钟
        app("C_Api_file")->multiDownload();
    }

    /**
     * 单线程下载
     */
    public function downloadUrl()
    {
        noCache();
        continueExec();//默认五分钟
        app("C_Api_file")->downloadUrl();
    }

    /**
     * 文件上传
     */
    public function fileUpload()
    {
        noCache();
        continueExec();
        $response=$this->c_file->fileUpload();
        return jsonResponse($response);
    }

    /**
     * KindEditor 文件上传
     */
    public function kindEditorFileUpload()
    {
        noCache();
        continueExec();
        $response=$this->c_file->kindEditorFileUpload();
        return jsonResponse($response);
    }

    /**
     * 获取远程资源内容
     */
    public function getRemoteContent()
    {
        continueExec();
        $response=$this->c_file->getRemoteContent();
        return jsonResponse($response);
    }

    /**
     * 检测分片信息
     */
    public function checkMultipartUpload()
    {
        continueExec();
        $response=$this->c_file->checkMultipartUpload();
        return jsonResponse($response);
    }

    /**
     * 百度上传插件
     */
    public function webUploader()
    {
        noCache();
        continueExec();
        $response=$this->c_file->webUploader();
        return jsonResponse($response);
    }

    /**
     * 分片上传执行
     */
    public function multipartUpload()
    {
        noCache();
        continueExec();
        $response=$this->c_file->multipartUpload();
        return jsonResponse($response);
    }

    /**
     * 合并文件
     */
    public function mergeMultipartUpload()
    {
        continueExec();
        $response=$this->c_file->mergeMultipartUpload();
        return jsonResponse($response);
    }

    /**
     * 获取文件列表
     */
    public function files()
    {
        $response=$this->c_file->showDir();
        return jsonResponse($response);
    }
}