<?php

//基础
router()->post("base/login","Base/login");
router()->get("login","Login/index")->middleware(["loginPage"]);//登录页面
router()->get("logout","Login/logout");//登出
router()->get("ltcmsLogin","AppStore/ltcmsLogin");  //ltcms账号登录
router()->get("users/callback","AppStore/callback");  //登录回调

//验证码
router()->get("captcha","Captcha/index");//显示验证码

//安装脚本
router()->get("script_install/exec","Script_install/exec");//执行脚本
router()->get("script_install/install","Script_install/install");//执行安装脚本

//仅管理验证
router()->group("", function () {
    router()->get("","Index/index");//默认框架
    router()->get("welcome","Index/welcome");//默认页面

    //管理员获取登录信息
    router()->get("user/getInfo","User/getInfo");
    router()->post("user/setAdminPassword","User/setAdminPassword");
    router()->get("user/getUserMenu","User/getUserMenu"); //管理员获取导航菜单
}, ["isAdminLogin"]);

// 管理验证+权限控制
router()->group("", function () {

    //工具类
    router()->post("tool/replaceSiteUrl","Tool/replaceSiteUrl");  //替换网站地址

    //商店管理
    router()->get("appStore","AppStore/index");  //列表
    router()->get("plugin/downloadFile","AppStore/downloadFile");  //下载[执行]
    router()->get("plugin/download","AppStore/download");  //插件下载
    router()->get("plugin/install","AppStore/install");  //插件安装
    router()->get("run","AppStore/run");  //执行
    router()->get("plugin/info","AppStore/pluginDetail");  //插件详情
    router()->get("install","AppStore/installExec");  //安装
    router()->delete("uninstall","AppStore/uninstallExec");  //卸载插件
    router()->get("setUpView","AppStore/setUpView");  //插件设置

    router()->get("usedByCardName","AppStore/usedByCardName")->middleware("checkLtcmsLogin");  //使用激活码
    router()->put("prop/usedByCardName","AppStore/usedByCardNameDo")->middleware("checkLtcmsLogin");  //使用激活码[执行]

    //设置
    router()->post("setting/installInit","Setting/installInit"); //安装初始化设置
    router()->post("setting/record","Setting/record");
    router()->post("setting/recordBatch","Setting/recordBatch");
    router()->delete("setting/delete","Setting/delete");

    router()->get("setting/index","Setting/index");
    router()->get("setting/seo","Setting/seo");
    router()->get("setting/site","Setting/site");
    router()->get("setting/extend","Setting/extend");
    router()->get("setting/cache","Setting/cache");

    //模块管理
    router()->get("module","Module/index");
    router()->get("module/edit","Module/edit");
    router()->get("module/create","Module/create");
    router()->post("module/supplyRoute","Module/supplyRoute");
    router()->post("module","Module/store");
    router()->put("module","Module/update");
    router()->delete("module","Module/delete");

    //分类管理
    router()->get("category","Category/index");
    router()->get("category/edit","Category/edit");
    router()->get("category/create","Category/create");
    router()->post("category","Category/store");
    router()->put("category","Category/update");
    router()->delete("category","Category/delete");
    router()->get("allData","Category/allData");
    router()->get("category/init_category","Category/init_category");

    //新闻管理
    router()->get("news","News/index");
    router()->get("news/edit","News/edit");
    router()->get("news/create","News/create");
    router()->post("news","News/store");
    router()->put("news","News/update");
    router()->delete("news","News/delete");

    //日志操作
    router()->get("log_operation","Log_operation/index");
    router()->delete("log_operation","Log_operation/delete");

    //自定义字段管理
    router()->get("fields","Fields/index");
    router()->get("fields/edit","Fields/edit");
    router()->get("fields/create","Fields/create");
    router()->get("fields/use_explain","Fields/use_explain");
    router()->post("fields","Fields/store");
    router()->put("fields","Fields/update");
    router()->delete("fields","Fields/delete");

    //流水数据管理
    router()->get("flow_data","Flow_data/index");
    router()->get("flow_data/edit","Flow_data/edit");
    router()->get("flow_data/create","Flow_data/create");
    router()->post("flow_data","Flow_data/store");
    router()->put("flow_data","Flow_data/update");
    router()->delete("flow_data","Flow_data/delete");



    //版本更新检测
    router()->get("systemUpdate/updateVersion","SystemUpdate/updateVersion");     //更新页
    router()->get("systemUpdate/backups","SystemUpdate/backups");     //备份页
    router()->post("systemUpdate/updateNewVersion","SystemUpdate/updateNewVersion"); //一键更新
    router()->post("systemUpdate/UpdateBackup","SystemUpdate/UpdateBackup");//一键备份


    //性能优化
    router()->get("setting/optimize","Setting/optimize");


    //广告位管理
    router()->get("adPosition/index","AdPosition/index");  //分页读取
    router()->get("adPosition/create","AdPosition/create"); //添加 静态页
    router()->post("adPosition","AdPosition/store"); //添加 接口
    router()->get("adPosition/edit","AdPosition/edit"); //修改 静态页
    router()->put("adPosition/update","AdPosition/update"); //修改 接口
    router()->delete("adPosition","AdPosition/delete"); //删除

    //广告管理
    router()->get("adManage/index","AdManage/index"); //分页读取
    router()->get("adManage","AdManage/create"); //添加 静态页
    router()->post("adManage","AdManage/store"); //添加
    router()->get("adManage/edit","AdManage/edit"); //修改 静态页
    router()->put("adManage","AdManage/update"); //修改
    router()->delete("adManage","AdManage/delete"); //删除


    //友情链接
    router()->get("friendLink/index","FriendLink/index");  //分页读取
    router()->get("friendLink","FriendLink/info");
    router()->get("friendLink/create","FriendLink/create"); //添加 静态页
    router()->post("friendLink","FriendLink/store"); //添加
    router()->get("friendLink/edit","FriendLink/edit"); //修改 静态页
    router()->put("friendLink","FriendLink/update"); //修改
    router()->delete("friendLink","FriendLink/delete"); //删除


    //友情链接分组
    router()->get("friendLinkGroup/index","FriendLinkGroup/index");  //分页读取
    router()->get("friendLinkGroup","FriendLinkGroup/info");
    router()->get("friendLinkGroup/create","FriendLinkGroup/create"); //添加 静态页
    router()->post("friendLinkGroup","FriendLinkGroup/store"); //添加
    router()->get("friendLinkGroup/edit","FriendLinkGroup/edit"); //修改 静态页
    router()->put("friendLinkGroup","FriendLinkGroup/update"); //修改
    router()->delete("friendLinkGroup","FriendLinkGroup/delete"); //删除

    //单页管理
    router()->get("singlePage/index","SinglePage/index");  //分页读取
    router()->get("singlePage/create","SinglePage/create");
    router()->get("singlePage/edit","SinglePage/edit");
    router()->post("singlePage","SinglePage/store"); //添加
    router()->put("singlePage","SinglePage/update"); //修改
    router()->delete("singlePage","SinglePage/delete"); //删除
    router()->put("singlePage/Level","SinglePage/updateLevel"); //批量设置级别
    router()->put("singlePage/SortWeights","SinglePage/updateSortWeightsBatch"); //批量设置排序权重
    router()->put("singlePage/generateStaticPages","SinglePage/generateStaticPages"); //生成全部静态页


    //单页分类管理
    router()->get("singlePageGroup/index","SinglePageGroup/index");  //分页读取
    router()->get("singlePageGroup/create","SinglePageGroup/create");
    router()->get("singlePageGroup/edit","SinglePageGroup/edit");
    router()->post("singlePageGroup","SinglePageGroup/store"); //添加
    router()->put("singlePageGroup","SinglePageGroup/update"); //修改
    router()->delete("singlePageGroup","SinglePageGroup/delete"); //删除

    //已登录的管理员操作自己账号的功能
    router()->post("user/setAdminPassword","User/setAdminPassword");


    //=======================rbac权限相关开始====================================================================================
    //逻辑整理,获取有权限的导航菜单信息 管理登录后有管理员uid->通过uid查关系表获取角色id->通过角色id,查询角色功能关系表获得功能id数组->通过功能id数组,获取到拥有的菜单id数组,

    //管理员管理

    router()->get("memberAdmin/index","MemberAdmin/index");
    router()->get("memberAdmin/create","MemberAdmin/create");
    router()->get("memberAdmin/modifyPwd","MemberAdmin/modifyPwd");
    router()->get("memberAdmin/modifyPwdSelf","MemberAdmin/modifyPwdSelf");
    router()->get("memberAdmin/edit","MemberAdmin/edit");

    router()->post("memberAdmin","MemberAdmin/store");
    router()->put("modifyPwdDo","MemberAdmin/modifyPwdDo");
    router()->put("memberAdmin","MemberAdmin/update");
    router()->delete("memberAdmin","MemberAdmin/delete");

    router()->put("memberAdmin/setRole","MemberAdmin/setRole");       // 修改 角色
    router()->put("memberAdmin/setStatus","MemberAdmin/setStatus"); //修改状态 1启用 2禁用

    //管理员 角色管理
    router()->get("adminRole/index","AdminRole/index");
    router()->get("adminRole/create","AdminRole/create"); //静态页
    router()->get("adminRole/edit","AdminRole/edit"); //修改信息静态页

    router()->post("adminRole","AdminRole/store"); //接口
    router()->put("adminRole","AdminRole/update"); //接口
    router()->delete("adminRole","AdminRole/delete");

    router()->get("adminRole/roleFuncBind","AdminRole/roleFuncBind"); //角色绑定功能信息列表页
    //管理员  角色功能绑定
    router()->put("adminRoleFunc/setRoleBindFunc","AdminRoleFunc/setRoleBindFunc");  // 设置角色绑定功能ids    对比差异删无加有


    //导航菜单管理
    router()->get("adminMenu/index","AdminMenu/index");  //分页读取
    router()->get("adminMenu/create","AdminMenu/create"); //添加 静态页
    router()->get("adminMenu/edit","AdminMenu/edit"); //修改 静态页

    router()->post("adminMenu","AdminMenu/store"); //添加 接口
    router()->put("adminMenu","AdminMenu/update"); //修改 接口
    router()->delete("adminMenu","AdminMenu/delete"); //删除

    //菜单功能管理
    router()->get("adminFunc/index","AdminFunc/index");  //分页读取
    router()->get("adminFunc","AdminFunc/create"); //添加 静态页
    router()->get("adminFunc/edit","AdminFunc/edit"); //修改 静态页

    router()->post("adminFunc","AdminFunc/store"); //添加 接口
    router()->put("adminFunc/edit","AdminFunc/update"); //修改 接口
    router()->delete("adminFunc","AdminFunc/delete"); //删除
    router()->put("adminFunc/updateControllerFunctionList","AdminFunc/updateControllerFunctionList"); //反射获取控制器功能列表,添加或更新数据库数据
    router()->delete("adminFunc/deleteAll","AdminFunc/deleteAll"); //删除全部

    //升级日志
    router()->get("softwareUpgradeLog","Software_upgrade_log/index");
    router()->get("softwareUpgradeLog/edit","Software_upgrade_log/edit");
    router()->get("softwareUpgradeLog/create","Software_upgrade_log/create");
    router()->get("softwareUpgradeLog/info","Software_upgrade_log/info");
    router()->post("softwareUpgradeLog","Software_upgrade_log/store");
    router()->put("softwareUpgradeLog","Software_upgrade_log/update");
    router()->delete("softwareUpgradeLog","Software_upgrade_log/delete");

    /**
     * 系统升级
     */
    router()->get("systemUpgrade","SystemUpgrade/index");
    router()->get("systemUpgrade/download","SystemUpgrade/download");
    router()->get("systemUpgrade/downloadFile","SystemUpgrade/downloadFile");
    router()->get("systemUpgrade/install","SystemUpgrade/install");
    router()->get("systemUpgrade/installFile","SystemUpgrade/installFile");
    router()->get("systemUpgrade/execScript","SystemUpgrade/execScript");
    router()->post("systemUpgrade/updateKey","SystemUpgrade/updateKey");
    router()->post("systemUpgrade/updateWhiteList","SystemUpgrade/updateWhiteList");

    /**
     * 缓存数据
     */
    router()->get("cache","Cache/index");
    router()->post("cache/update","Cache/update");
    router()->get("cache/update","Cache/update");

    //=======================权限相关结束====================================================================================
}, ["isAdminAuth", "isAdminLogin"]);


router()->group("", function () {
//文章管理
    router()->get("article","Article/index");
    router()->get("article/indexRecycle","Article/indexRecycle");
    router()->get("article/edit","Article/edit");
    router()->get("article/create","Article/create");
    router()->get("article/setting","Article/setting");  //文章设置页
    router()->put("article/recordBatch","Article/recordBatch");//文章设置保存
    router()->post("article","Article/store");
    router()->put("article/removeBackslashes","Article/removeBackslashes");
    router()->put("article","Article/update");
    router()->delete("article","Article/delete");
    router()->put("article/setStatus","Article/setStatus");
    router()->put("article/setRecycle","Article/setRecycle");
}, ["isAdminAuth", "isAdminLogin"]);