<?php

namespace app\admin\controller;

use ltcms\lib\Request;
use app\client\admin\C_article;
use app\client\admin\C_setting;

class Article
{
    public $c_article;
    public $c_setting;

    /**
     * @menuName {name}管理
     * 上面的是菜单的名字 {name} 为变量 表 module.name 值
     * @moduleName {name}管理
     * 上面的是控制器的名字
     */
    public function __construct()
    {
        $this->c_article = new C_article();
        $this->c_setting = new C_setting();
    }

    /**
     * @actionName {name}管理
     * @show 1
     * 展示设置
     */
    public function index()
    {
        $moduleId=request()->param("moduleId");
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "moduleId" => $moduleId,
            "recycle" => 1,
            "format" => 1,
        );
        if (!$moduleId) {
            return view("admin/error/noData");
        }
        $response = $this->c_article->listData($paramsObj);
        $articleListData = array();
        if ($response["success"]) {
            $articleListData = $response["data"];
        }
        $data = array();
        $data["articleListData"] = $articleListData;
        $data["request"] = request()->param();
        return view("admin/article/index", $data);
    }

    /**
     * @actionName 回收站管理
     * @show 1
     * 展示设置
     */
    public function indexRecycle()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "moduleId" => request()->param("moduleId"),
            "recycle" => "2",
            "format" => 1,
        );

        if (!$paramsObj->params["moduleId"]) {
            return view("admin/error/noData");
        }

        $response = $this->c_article->listData($paramsObj);
        $articleListData = array();
        if ($response["success"]) {
            $articleListData = $response["data"];
        }
        $data = array();
        $data["articleListData"] = $articleListData;
        $data["request"] = request()->param();
        if (!isset($data["request"]["moduleId"])) { //因为文章分类id在路径内补请求参数
            $data["request"]["moduleId"] = request()->param("moduleId");
        }

        return view("admin/article/indexRecycle", $data);
    }

    /**
     * @actionName 添加页
     * @show 2
     * 展示设置
     */
    public function create()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "moduleId" => request()->param("moduleId"),
        );
        if (!$paramsObj->params["moduleId"]) {
            return view("admin/error/noData");
        }

        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "pid" => request()->param("moduleId"),
        );
        $result = app("S_Admin_setting")->getSetting($paramsObj);
        $setting = array();
        if ($result["error_no"] === 0) {
            $setting = $result["result"];
        }
        $levelList=array();
        if (isset($setting["levelAlias"])) {
            $levelList = app("L_Admin_article")->getlevelAlias($setting["levelAlias"]);
        }

        $data = array();
        $data["request"] = array(
            "moduleId" => request()->param("moduleId"),
        );
        $data["levelList"] = $levelList ?? array("1级", "2级", "3级", "4级", "5级", "6级", "7级", "8级", "9级");
        return view("admin/article/create", $data);
    }

    /**
     * @actionName 编辑
     * @show 2
     * 展示设置
     */
    public function edit()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "pid" => request()->param("moduleId"),
        );
        $result = app("S_Admin_setting")->getSetting($paramsObj);
        if ($result["error_no"] === 0) {
            $setting = $result["result"];
            if (isset($setting["levelAlias"])) {
                $levelList = app("L_Admin_article")->getlevelAlias($setting["levelAlias"]);
            }
        }
        $response = $this->c_article->info();
        $rowData = array();
        if ($response["success"]) {
            $rowData = $response["data"];
        }
        if ($rowData) {
            $data = array();
            $data["rowData"] = $rowData;
            $data["levelList"] = $levelList ?? array("1级", "2级", "3级", "4级", "5级", "6级", "7级", "8级", "9级");
            $data["request"] = request()->param();
            if (!isset($data["request"]["moduleId"])) { //因为文章分类id在路径内补请求参数
                $data["request"]["moduleId"] = request()->param("moduleId");
            }
            return view("admin/article/edit", $data);
        } else {
            return view("admin/error/noData");
        }
    }

    /**
     * @actionName 添加接口
     * @show 2
     * 展示设置
     */
    public function store()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "moduleId" => request()->param("moduleId"),
            "isAdmin" => 1,
            "userId" => session()->get(config("session.adminLogin.uid"), "0"),
        );
        $result = $this->c_article->store($paramsObj);
        return jsonResponse($result);
    }

    /**
     * @actionName 更新文章接口
     * @show 2
     * 展示设置
     */
    public function update()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "moduleId" => request()->param("moduleId"),
        );
        $result = $this->c_article->update($paramsObj);
        return jsonResponse($result);
    }

    /**
     * @actionName 删除
     * @show 2
     * 展示设置
     */
    public function delete()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "moduleId" => request()->param("moduleId") ?? (str_getBetween(request()->url() . "/", "/article/", "?") ?? str_getBetween(request()->url() . "/", "/article/", "/")),
        );
        $result = $this->c_article->delete($paramsObj);
        return jsonResponse($result);
    }

    /**
     * @actionName  批量修改状态
     * @show 2
     * 展示设置
     */
    public function setStatus()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "moduleId" => request()->param("moduleId"),
        );
        $result = $this->c_article->setStatus($paramsObj);
        return jsonResponse($result);
    }

    /**
     * @actionName  批量修改回收站
     * @show 2
     * 展示设置
     */
    public function setRecycle()
    {
        $paramsObj = paramsObj();
        $paramsObj->params = array(
            "moduleId" => request()->param("moduleId"),
        );
        $result = $this->c_article->setRecycle($paramsObj);
        return jsonResponse($result);
    }

    /**
     * 删除反斜线
     */
    public function removeBackslashes()
    {
        $result = app("C_Admin_article")->removeBackslashes();
        return jsonResponse($result);
    }

    /**
     * @actionName 模块设置
     * @show 1
     * 展示设置
     */
    public function setting()
    {
        $moduleId = request()->param("moduleId");
        if (!$moduleId) {
            return view("admin/error/noData");
        }
        $paramsObj=paramsObj();
        $paramsObj->mixed=0;
        $paramsObj->params=array(
            "pid"=>$moduleId,
        );
        $response= $this->c_setting->getSetting($paramsObj);
        $setting=array();
        if($response["success"]){
            $setting=$response["data"];
        }
        if (isset($setting["levelAlias"])) {
            $levelList = app("L_Admin_article")->getlevelAlias($setting["levelAlias"]);
        }

        $settingData=config("setting_data");

        $template=config("template");
        $data = array();
        $data["settingData"] = $settingData;
        $data["templateConfig"] = $template;
        $data["setting"] = $setting ?? array();
        $data["levelList"] = $levelList ?? array();
        $data["request"] = request()->param();
        return view("admin/article/setting", $data);
    }

    /**
     * @actionName 文章设置批量保存
     * @show 2
     * 展示设置
     */
    public function recordBatch()
    {
        $pid=request()->param("pid");
        $setting=request()->param("setting");

        $listUrlRule=setting("listUrlRule",$pid);
        $htmlListUrlRule=setting("htmlListUrlRule",$pid);
        $htm_list_prefix=setting("htm_list_prefix",$pid);
        $moduleListHtml=setting("moduleListHtml",$pid);

        $moduleConHtml=setting("moduleConHtml",$pid);
        $conUrlRule=setting("conUrlRule",$pid);
        $htmlConUrlRule=setting("htmlConUrlRule",$pid);
        $htm_item_prefix=setting("htm_item_prefix",$pid);

        $categoryUpdata=0;
        if(!($moduleListHtml==$setting["moduleListHtml"] && $listUrlRule==$setting["listUrlRule"] && $htmlListUrlRule==$setting["htmlListUrlRule"] && $htm_list_prefix==$setting["htm_list_prefix"])){
            $categoryUpdata=1;
        }

        $articleUpdata=0;
        if(!($moduleConHtml==$setting["moduleConHtml"] && $conUrlRule==$setting["conUrlRule"] && $htmlConUrlRule==$setting["htmlConUrlRule"] && $htm_item_prefix==$setting["htm_item_prefix"])){
            $articleUpdata=1;
        }

        $result = $this->c_article->settingRecordBatch();
        if($result["success"]){
            if($categoryUpdata){
                //更新分类地址
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "dataType"=>"module",
                    "dataId"=>$pid,
                );
                app("L_Admin_category")->updateLinkurl($paramsObj);

                //更新分类缓存
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "dataType"=>"module",
                    "dataId"=>$pid,
                );
                $tmp=app("L_Common_caches")->updateCategory($paramsObj);
                if($tmp["error_no"]){
                    recordErrorLog($tmp); //记录错误信息
                }
            }
            if($articleUpdata){
                $result["extra"]["referer"]=LTCMS_ROUTE_PREFIX."/cache/update?moduleId={$pid}&action=show&update=1";
            }
        }
        return jsonResponse($result);
    }
}