<?php

router()->group("api",function () {

    /**
     * 默认方法
     */
    router()->get("test/phpVersion", "api/Test/phpVersion");
    router()->get("test", "api/Test/index");
    router()->get("test/download", "api/Test/download");
    router()->get("test/getSecretKey", "api/Test/getSecretKey");

    /**
     * 默认方法
     */
    router()->get("index", "IndexController/index");

    /**
     * 生成站点地图
     */
    router()->post("sitemaps/store", "api/Sitemaps/store");

    /**
     * 文章列表
     */
    router()->get("article/listData", "api/Article/listData");

    /**
     * 文件上传
     */
    router()->get('file/downloadUrl', "api/File/downloadUrl");//单线程下载
    router()->get('file/multiDownload', "api/File/multiDownload");//多线程下载
    router()->get('file/downloadFile', "api/File/downloadFile");//文件下载
    router()->post('file/fileUpload', "api/File/fileUpload");// 文件上传
    router()->post('file/kindEditorFileUpload', "api/File/kindEditorFileUpload");//KindEditor 文件上传
    router()->post('file/getRemoteContent', "api/File/getRemoteContent");//获取远程资源内容
    router()->post('file/checkMultipartUpload', "api/File/checkMultipartUpload");//检测分片信息
    router()->post('file/multipartUpload', "api/File/multipartUpload");//分片上传执行
    router()->post('file/mergeMultipartUpload', "api/File/mergeMultipartUpload");//合并文件
    router()->post('file/webUploader', "api/File/webUploader");//百度上传插件

    /**
     * 代码混淆
     */
    router()->get('codeObscure/encoder', "api/common/CodeObscure/encoder");

    /**
     * 数据库-迁移
     */
    router()->get('migrate/exportInstallTable', "api/Migrate/exportInstallTable");

    /**
     * 新闻
     */
    router()->get('news/listData', "api/News/listData"); //列表数据
    router()->get('news/info', "api/News/info"); //信息

    /**
     * 流量数据
     */
    router()->post('flow_data/store', "api/Flow_data/store"); //创建资源

    /**
     * 商品数据
     */
    router()->get('plugin', "api/index/Goods/pluginList");
    router()->get('plugin/info', "api/index/Plugin/info");

    router()->get('execScript/install', "Install/install"); //安装脚本
    router()->get('execScript/pluginInstall', "Install/pluginInstall"); //安装插件

    /**
     * 龙腾账号退出
     */
    router()->get('ltcmsUsers/logout', "api/LtcmsUsers/logout"); //用户退出
});






