<?php


//基础
router()->post("admin/base/login", "admin/Base/login");
router()->get("admin/login", "admin/Login/index")->middleware(["loginPage"]);//登录页面
router()->get("admin/logout", "admin/Login/logout");//登出
router()->get("ltcmsLogin", "admin/AppStore/ltcmsLogin");  //ltcms账号登录
router()->get("users/callback", "admin/AppStore/callback");  //登录回调

//仅管理验证
router()->group("admin", function () {
    router()->get("", "admin/Index/index");//默认框架
    router()->get("welcome", "admin/Index/welcome");//默认页面
    //管理员获取登录信息
    router()->get("user/getInfo", "admin/User/getInfo");
    router()->post("user/setAdminPassword", "admin/User/setAdminPassword");
    router()->get("user/getUserMenu", "admin/User/getUserMenu"); //管理员获取导航菜单
}, ["isAdminLogin"]);

// 管理验证+权限控制
router()->group("admin", function () {

    //商店管理
    router()->get("appStore", "admin/AppStore/index");  //列表
    router()->get("downloadFile", "admin/AppStore/downloadFile");  //下载[执行]
    router()->get("run", "admin/AppStore/run");  //执行
    router()->get("install", "admin/AppStore/installExec");  //安装
    router()->delete("uninstall", "admin/AppStore/uninstallExec");  //卸载插件
    router()->get("setUpView", "admin/AppStore/setUpView");  //插件设置
    router()->get("usedByCardName", "admin/AppStore/usedByCardName")->middleware("checkLtcmsLogin");  //使用激活码
    router()->put("prop/usedByCardName", "admin/AppStore/usedByCardNameDo")->middleware("checkLtcmsLogin");  //使用激活码[执行]

    //设置
    router()->post("setting/record", "admin/Setting/record");
    router()->post("setting/recordBatch", "admin/Setting/recordBatch");
    router()->delete("setting/delete", "admin/Setting/delete");

    router()->get("setting/index", "admin/Setting/index");
    router()->get("setting/seo", "admin/Setting/seo");
    router()->get("setting/site", "admin/Setting/site");
    router()->get("setting/extend", "admin/Setting/extend");

    //模块管理
    router()->get("module", "admin/Module/index");
    router()->get("module/edit", "admin/Module/edit");
    router()->get("module/create", "admin/Module/create");
    router()->post("module", "admin/Module/store");
    router()->put("module", "admin/Module/update");
    router()->delete("module", "admin/Module/delete");

    //分类管理
    router()->get("category", "admin/Category/index");
    router()->get("category/edit", "admin/Category/edit");
    router()->get("category/create", "admin/Category/create");
    router()->post("category", "admin/Category/store");
    router()->put("category", "admin/Category/update");
    router()->delete("category", "admin/Category/delete");
    router()->get("allData", "admin/Category/allData");

    //新闻管理
    router()->get("news", "admin/News/index");
    router()->get("news/edit", "admin/News/edit");
    router()->get("news/create", "admin/News/create");
    router()->post("news", "admin/News/store");
    router()->put("news", "admin/News/update");
    router()->delete("news", "admin/News/delete");

    //流水数据管理
    router()->get("flow_data", "admin/Flow_data/index");
    router()->get("flow_data/edit", "admin/Flow_data/edit");
    router()->get("flow_data/create", "admin/Flow_data/create");
    router()->post("flow_data", "admin/Flow_data/store");
    router()->put("flow_data", "admin/Flow_data/update");
    router()->delete("flow_data", "admin/Flow_data/delete");



    //版本更新检测
    router()->get("systemUpdate/updateVersion", "admin/SystemUpdate/updateVersion");     //更新页
    router()->get("systemUpdate/backups", "admin/SystemUpdate/backups");     //备份页
    router()->post("systemUpdate/updateNewVersion", "admin/SystemUpdate/updateNewVersion"); //一键更新
    router()->post("systemUpdate/UpdateBackup", "admin/SystemUpdate/UpdateBackup");//一键备份


    //性能优化
    router()->get("setting/optimize", "admin/Setting/optimize");


    //广告位管理
    router()->get("adPosition/index", "admin/AdPosition/index");  //分页读取
    router()->get("adPosition/create", "admin/AdPosition/create"); //添加 静态页
    router()->post("adPosition", "admin/AdPosition/store"); //添加 接口
    router()->get("adPosition/edit", "admin/AdPosition/edit"); //修改 静态页
    router()->put("adPosition/update", "admin/AdPosition/update"); //修改 接口
    router()->delete("adPosition", "admin/AdPosition/delete"); //删除

    //广告管理
    router()->get("adManage/index", "admin/AdManage/index"); //分页读取
    router()->get("adManage", "admin/AdManage/create"); //添加 静态页
    router()->post("adManage", "admin/AdManage/store"); //添加
    router()->get("adManage/edit", "admin/AdManage/edit"); //修改 静态页
    router()->put("adManage", "admin/AdManage/update"); //修改
    router()->delete("adManage", "admin/AdManage/delete"); //删除


    //友情链接
    router()->get("friendLink/index", "admin/FriendLink/index");  //分页读取
    router()->get("friendLink", "admin/FriendLink/info");
    router()->get("friendLink/create", "admin/FriendLink/create"); //添加 静态页
    router()->post("friendLink", "admin/FriendLink/store"); //添加
    router()->get("friendLink/edit", "admin/FriendLink/edit"); //修改 静态页
    router()->put("friendLink", "admin/FriendLink/update"); //修改
    router()->delete("friendLink", "admin/FriendLink/delete"); //删除


    //友情链接分组
    router()->get("friendLinkGroup/index", "admin/FriendLinkGroup/index");  //分页读取
    router()->get("friendLinkGroup", "admin/FriendLinkGroup/info");
    router()->get("friendLinkGroup/create", "admin/FriendLinkGroup/create"); //添加 静态页
    router()->post("friendLinkGroup", "admin/FriendLinkGroup/store"); //添加
    router()->get("friendLinkGroup/edit", "admin/FriendLinkGroup/edit"); //修改 静态页
    router()->put("friendLinkGroup", "admin/FriendLinkGroup/update"); //修改
    router()->delete("friendLinkGroup", "admin/FriendLinkGroup/delete"); //删除

    //单页管理
    router()->get("singlePage/index", "admin/SinglePage/index");  //分页读取
    router()->get("singlePage/create", "admin/SinglePage/create");
    router()->get("singlePage/edit", "admin/SinglePage/edit");
    router()->post("singlePage", "admin/SinglePage/store"); //添加
    router()->put("singlePage", "admin/SinglePage/update"); //修改
    router()->delete("singlePage", "admin/SinglePage/delete"); //删除
    router()->put("singlePage/Level", "admin/SinglePage/updateLevel"); //批量设置级别
    router()->put("singlePage/SortWeights", "admin/SinglePage/updateSortWeightsBatch"); //批量设置排序权重
    router()->put("singlePage/generateStaticPages", "admin/SinglePage/generateStaticPages"); //生成全部静态页


    //单页分类管理
    router()->get("singlePageGroup/index", "admin/SinglePageGroup/index");  //分页读取
    router()->get("singlePageGroup/create", "admin/SinglePageGroup/create");
    router()->get("singlePageGroup/edit", "admin/SinglePageGroup/edit");
    router()->post("singlePageGroup", "admin/SinglePageGroup/store"); //添加
    router()->put("singlePageGroup", "admin/SinglePageGroup/update"); //修改
    router()->delete("singlePageGroup", "admin/SinglePageGroup/delete"); //删除

    //已登录的管理员操作自己账号的功能
    router()->post("admin/user/setAdminPassword", "admin/User/setAdminPassword");


    //=======================rbac权限相关开始====================================================================================
    //逻辑整理,获取有权限的导航菜单信息 管理登录后有管理员uid->通过uid查关系表获取角色id->通过角色id,查询角色功能关系表获得功能id数组->通过功能id数组,获取到拥有的菜单id数组,

    //管理员管理

    router()->get("memberAdmin/index", "admin/MemberAdmin/index");
    router()->get("memberAdmin/create", "admin/MemberAdmin/create");
    router()->get("memberAdmin/edit", "admin/MemberAdmin/edit");

    router()->post("memberAdmin", "admin/MemberAdmin/store");
    router()->put("memberAdmin", "admin/MemberAdmin/update");
    router()->delete("memberAdmin", "admin/MemberAdmin/delete");

    router()->put("memberAdmin/setRole", "admin/MemberAdmin/setRole");       // 修改 角色
    router()->put("memberAdmin/setStatus", "admin/MemberAdmin/setStatus"); //修改状态 1启用 2禁用

    //管理员 角色管理
    router()->get("adminRole/index", "admin/AdminRole/index");
    router()->get("adminRole/create", "admin/AdminRole/create"); //静态页
    router()->get("adminRole/edit", "admin/AdminRole/edit"); //修改信息静态页

    router()->post("adminRole", "admin/AdminRole/store"); //接口
    router()->put("adminRole", "admin/AdminRole/update"); //接口
    router()->delete("adminRole", "admin/AdminRole/delete");

    router()->get("adminRole/roleFuncBind", "admin/AdminRole/roleFuncBind"); //角色绑定功能信息列表页
    //管理员  角色功能绑定
    router()->put("adminRoleFunc/setRoleBindFunc", "admin/AdminRoleFunc/setRoleBindFunc");  // 设置角色绑定功能ids    对比差异删无加有


    //导航菜单管理
    router()->get("adminMenu/index", "admin/AdminMenu/index");  //分页读取
    router()->get("adminMenu/create", "admin/AdminMenu/create"); //添加 静态页
    router()->get("adminMenu/edit", "admin/AdminMenu/edit"); //修改 静态页

    router()->post("adminMenu", "admin/AdminMenu/store"); //添加 接口
    router()->put("adminMenu", "admin/AdminMenu/update"); //修改 接口
    router()->delete("adminMenu", "admin/AdminMenu/delete"); //删除

    //菜单功能管理
    router()->get("adminFunc/index", "admin/AdminFunc/index");  //分页读取
    router()->get("adminFunc", "admin/AdminFunc/create"); //添加 静态页
    router()->get("adminFunc/edit", "admin/AdminFunc/edit"); //修改 静态页

    router()->post("adminFunc", "admin/AdminFunc/store"); //添加 接口
    router()->put("adminFunc/edit", "admin/AdminFunc/update"); //修改 接口
    router()->delete("adminFunc", "admin/AdminFunc/delete"); //删除
    router()->put("adminFunc/updateControllerFunctionList", "admin/AdminFunc/updateControllerFunctionList"); //反射获取控制器功能列表,添加或更新数据库数据
    router()->delete("adminFunc/deleteAll", "admin/AdminFunc/deleteAll"); //删除全部

    //升级日志
    router()->get("softwareUpgradeLog", "admin/Software_upgrade_log/index");
    router()->get("softwareUpgradeLog/edit", "admin/Software_upgrade_log/edit");
    router()->get("softwareUpgradeLog/create", "admin/Software_upgrade_log/create");
    router()->get("softwareUpgradeLog/info", "admin/Software_upgrade_log/info");
    router()->post("softwareUpgradeLog", "admin/Software_upgrade_log/store");
    router()->put("softwareUpgradeLog", "admin/Software_upgrade_log/update");
    router()->delete("softwareUpgradeLog", "admin/Software_upgrade_log/delete");

    /**
     * 系统升级
     */
    router()->get("systemUpgrade", "admin/SystemUpgrade/index");
    router()->get("systemUpgrade/download", "admin/SystemUpgrade/download");
    router()->get("systemUpgrade/downloadFile", "admin/SystemUpgrade/downloadFile");
    router()->get("systemUpgrade/install", "admin/SystemUpgrade/install");
    router()->get("systemUpgrade/installFile", "admin/SystemUpgrade/installFile");

    //=======================权限相关结束====================================================================================
}, ["isAdminAuth", "isAdminLogin"]);


router()->group("admin", function () {
//文章管理
    router()->get("article", "admin/Article/index");
    router()->get("article/indexRecycle", "admin/Article/indexRecycle");
    router()->get("article/edit", "admin/Article/edit");
    router()->get("article/create", "admin/Article/create");
    router()->get("article/setting", "admin/Article/setting");  //文章设置页
    router()->put("article/recordBatch", "admin/Article/recordBatch");//文章设置保存
    router()->post("article", "admin/Article/store");
    router()->put("article", "admin/Article/update");
    router()->delete("article", "admin/Article/delete");
    router()->put("article/setStatus", "admin/Article/setStatus");
    router()->put("article/setRecycle", "admin/Article/setRecycle");
}, ["isAdminAuth", "isAdminLogin"]);