;(function ($, window, document,undefined)
{
    var validForm = function(forms,settings)
    {
        settings = $.extend({}, validForm.defaults, settings);
        settings.dataType && $.extend(validForm.util.dataType,settings.dataType);

        forms.each(function ()
        {
            //已经绑定事件时跳过，避免事件重复绑定;
            var curform=this;
            if(curform.validFormInited=="inited")
            {
                return true;
            }
            curform.validFormInited="inited";
            curform.settings=$.extend({},settings);
            curform.validFormStatus="normal";

            var $this=$(curform); //转为jquery对象

            //bind the blur event;
            $this.delegate("[dataType]","blur",function(){
                //判断是否是在提交表单操作时触发的验证请求；
                var subpost=arguments[1];
                validForm.util.check.call(this,$this,subpost);
            });

            //bind the keyup event;
            $this.delegate("[dataType]","keyup",function(){
                var subpost=arguments[1];
                validForm.util.check.call(this,$this,subpost);
            });

            $this.delegate(":text,:password","keypress",function(event){
                if(event.which==13)
                {
                    if($this.find(":submit").length==0 && settings.submitBtn)
                    {
                        $this.find(settings.submitBtn+settings.curClass).trigger("click");
                    }
                    else
                    {
                        $this.submit();
                    }
                }
            });
        });
    };
    validForm.defaults=
    {
        curClass:".cur", //验证成功 class
        lableSuccessClass:".success", //验证成功 class
        lableErrorClass:".error", //验证失败 class
        lableClass:".validateLable", //展示验证信息容器
        submitBtn:"", //提交按钮class
        ignoreHidden:false //可选项 true | false 默认为false，当为true时对:hidden的表单元素将不做验证;
    };
    validForm.util=
    {
        dataType:
        {
            "np":/^([a-zA-Z]+|[0-9]+){6,20}$/,
            "mobile":/^1(3|4|5|6|7|8|9)\d{9}$/,
            "pwd":/^(?![\d]+$)(?![a-zA-Z]+$)[\da-zA-Z]{6,20}$/,
            "smsYzm":/^\d{4}$/,
            "req":/^.*?$/,
            "readRule":/^1$/
        },
        dataMsg:
        {
            "np":"用户名 6-20个字符，字母、数字！",
            "mobile":"手机号格式不正确！",
            "pwd":"密码 6-20位字母、数字(两种组合)！",
            "smsYzm":"验证码 4位数字！",
            "req":"不能为空！",
            "readRule":"请勾选用户协议"
        },
        toString:Object.prototype.toString,
        isEmpty:function(val)
        {
            return val==="" || val===$.trim($(this).attr("tip"));
        },
        getValue:function(obj)
        {
            var inputval="",curform=this;
            var $curform=$(curform);

            if(obj.is(":radio"))
            {
                inputval=$curform.find(":radio[name='"+obj.attr("name")+"']:checked").val();
                inputval= $.getDefineValue(inputval,"");
            }
            else if(obj.is(":checkbox"))
            {
                $curform.find(":checkbox[name='"+obj.attr("name")+"']:checked").each(function(){
                    inputval +=$(this).val()+',';
                });
                inputval= $.getDefineValue(inputval,"");
            }
            else
            {
                inputval=obj.val();
            }
            inputval=$.trim(inputval);
            return validForm.util.isEmpty.call(obj,inputval) ? "" : inputval;
        },
        regcheck:function(datatype,inputval,obj)
        {
            var curform=this;
            var passed=false;

            obj.data("cked","cked");

            var errorMsg=validForm.util.dataMsg[datatype];
            if(!inputval)
            {
                var nullMsg= $.getDefineValue($(obj).attr("nullMsg"),errorMsg);
                validForm.util.showMsg.call(obj,curform,nullMsg);
            }
            else
            {
                var rexp=eval(validForm.util.dataType[datatype]);
                passed=rexp.test(inputval);
                if(passed)
                {
                    validForm.util.hideMsg.call(obj,curform);
                }
                else
                {
                    var ruleMsg= $.getDefineValue($(obj).attr("ruleMsg"),errorMsg);
                    validForm.util.showMsg.call(obj,curform,ruleMsg);
                }
            }

            validForm.util.chechComplete.call(obj,curform); //检查是否完成
            return passed;
        },
        check:function(curform,subpost,bool)
        {
            var settings=curform[0].settings;
            subpost=subpost || "";

            var inputval=validForm.util.getValue.call(curform,$(this));

            //隐藏或绑定dataIgnore的表单对象不做验证;
            if(settings.ignoreHidden && $(this).is(":hidden") || $(this).data("dataIgnore")==="dataIgnore"){
                return true;
            }
            var flag=validForm.util.regcheck.call(curform,$(this).attr("datatype"),inputval,$(this));
            return flag;
        },
        showMsg:function (curform,ruleMsg)
        {
            var obj=$(this);
            var settings=curform[0].settings;
            obj.siblings(settings.lableClass).addClass(settings.lableErrorClass.substr(1)).removeClass(settings.lableSuccessClass.substr(1)).html(ruleMsg);

            var showBtn=$.getDefineValue($(obj).attr("showBtn"),"");
            if(showBtn)
            {
                $(curform).find(showBtn).removeClass(settings.curClass.substr(1));
            }
        },
        hideMsg:function (curform)
        {
            var obj=$(this);
            var settings=curform[0].settings;
            obj.siblings(settings.lableClass).addClass(settings.lableSuccessClass.substr(1)).removeClass(settings.lableErrorClass.substr(1)).html("");

            var showBtn=$.getDefineValue($(obj).attr("showBtn"),"");
            if(showBtn)
            {
                var status=$.getDefineValue($(curform).find(showBtn).attr("status"),"");
                if(status)
                {
                    if(status=="end")
                    {
                        $(curform).find(showBtn).addClass(settings.curClass.substr(1));
                    }
                }
                else
                {
                    $(curform).find(showBtn).addClass(settings.curClass.substr(1));
                }
            }
        },
        chechComplete:function (curform)
        {
            var obj=$(this);
            var settings=curform[0].settings;
            if(settings.submitBtn)
            {
                var successLength=$(curform).find(settings.lableClass+settings.lableSuccessClass).length;
                var lableLength=$(curform).find(settings.lableClass).length;
                if(successLength==lableLength)
                {
                    $(curform).find(settings.submitBtn).addClass(settings.curClass.substr(1));
                }
                else
                {
                    $(curform).find(settings.submitBtn).removeClass(settings.curClass.substr(1));
                }
            }
        }
    };
    $.fn.validFrom = function(options)
    {
        var validFormObj = new validForm(this, options);
        return validFormObj;
    };
})(jQuery, window, document);
