;(function ($, window, document,undefined)
{
    var adapter = function(ele, opt)
    {
        this.element = ele;
        this.defaults = {};
        this.options = $.extend({}, this.defaults, opt);
        this.windowWidth=$(window).width();
        this.windowHeight=$(window).height();
    };
    adapter.prototype =
    {
        adjustFileSize: function() //调整字体大小
        {
            if(this.windowWidth)
            {
                var tempWidth=this.windowWidth / 375 * 16;
                this.element.css({"font-size":tempWidth+"px"});
            }
            return this;
        },
        verticalCenter:function()  //垂直居中
        {
            var hg=this.element.height();
            var wd=this.element.width();

            var tempMarginLeft=wd/2;
            var tempMarginTop=hg/2;
            this.element.css({"margin-left":"-"+tempMarginLeft+"px"});
            this.element.css({"margin-top":"-"+tempMarginTop+"px"});
        },
        selTab:function()  //选项卡
        {
            var curParent=$.getDefineValue(this.options.curParent,"tabParent");
            var selClass=$.getDefineValue(this.options.selClass,"cur");
            var selCon=$.getDefineValue(this.options.selCon,"tabCon");
            var selEle=$.getDefineValue(this.options.selEle,"ele");

            this.element.addClass(selClass).siblings().removeClass(selClass);
            this.element.parents("."+curParent).find("."+selCon+" ."+selEle).hide().eq(this.element.index()).show();
        },
        selCheckBox:function()  //多选框
        {
            var inputName=$.getDefineValue(this.options.inputName);
            var selClass=$.getDefineValue(this.options.selClass,"cur");
            var rel=$(this.element).attr("rel");
                rel=$.getDefineValue(rel,"1");

            if(rel==1)
            {
                $(this.element).removeClass(selClass);
                $(this.element).attr("rel","2");
                if(inputName)
                {
                    $("."+inputName).val(0);
                }
            }
            else
            {
                $(this.element).addClass(selClass);
                $(this.element).attr("rel","1");
                if(inputName)
                {
                    $("."+inputName).val(1);
                }
            }
        },
        autoHeight: function() //自动调整高度
        {
            var container=$.getDefineValue(this.options.container);
            var otherEle=$.getDefineValue(this.options.otherEle);
            var reduceHgVal=0;
            var containerHg=0;
            if(otherEle)
            {
                var reduceHgArr=otherEle.split(",");
                containerHg=$(container).outerHeight(true);
                if(reduceHgArr.length >0)
                {
                   $.each(reduceHgArr, function(index, value){
                       reduceHgVal+=$(value).outerHeight(true);
                   });
                }
            }
            if(containerHg && reduceHgVal)
            {
                var hgVal=containerHg-reduceHgVal;
                this.element.css({"height":hgVal+"px"});
            }
            return this;
        }
    };

    $.fn.adjustFileSize = function(options)
    {
        var beautifier = new adapter(this, options);
        return beautifier.adjustFileSize();
    };

    $.fn.verticalCenter = function(options)
    {
        var beautifier = new adapter(this, options);
        return beautifier.verticalCenter();
    };

    $.fn.selTab = function(options)
    {
        var beautifier = new adapter(this, options);
        return beautifier.selTab();
    };

    $.fn.selCheckBox = function(options)
    {
        var beautifier = new adapter(this, options);
        return beautifier.selCheckBox();
    };

    $.fn.autoHeight = function(options)
    {
        var beautifier = new adapter(this, options);
        return beautifier.autoHeight();
    };
})(jQuery, window, document);
