;(function ($, window, document,undefined)
{
	var curlHandler = function(ele, opt)
	{
		this.element = ele;
		this.options = $.extend({}, curlHandler.defaults, opt);
	};
	curlHandler.defaults=
	{
		"callback":"",
		"signType":"",
		"url":"",
		"timeout":60000,
		"data":{},
		"headers":{"Lang":lang,"Authorization":"jwt"},
		"curlData":"",
		"mdData":"",
		"dataType":"jsonp",
		"async":true,
		"type":"GET"
	};
	curlHandler.prototype=
	{
		jsonpSuccessCallback:function (data)
		{
			console.log("success");
		},
		jsonpErrorCallback:function (data)
		{
			console.log("error");
		},
		jsonpCompleteCallback:function (data)
		{
			console.log("complete");
		},
		commonSubmit:function ()
		{
			var curForm=this;
			if(curForm.options.url)
			{
				var curlMethod=$(curForm.element).attr("method");
				    curlMethod=$.getDefineValue(curlMethod,curForm.options.type);
                if(curlMethod.toLowerCase()=="get"){
                    var formData=$(curForm.element).serialize();
                    var curlData=$.jsonToStr(curForm.options.data)+"&"+formData;
                }else{
                    var curlData = new FormData($(curForm.element)[0]);
                    $.each(curForm.options.data,function(index,field){
                         curlData.append(index,field);
                    });
                }

                curForm.options.curlData=curlData;
                curForm.options.headers.lang=lang;
				$.ajax({
                    processData:false,
                    contentType :false,
                    headers:curForm.options.headers,
					type: curlMethod,
					url: curForm.options.url,
					async: curForm.options.async,
					dataType: curForm.options.dataType,
					timeout: curForm.options.timeout,
					beforeSend: function(request) {
						request.setRequestHeader("X-CSRF-TOKEN", $('meta[name="csrf-token"]').attr('content'));
					},
					data:curlData,
					jsonpCallback:curForm.options.callback?curForm.options.callback:"jsonpCallback",
					success:function(data)
					{
						var conError=1;
						if(typeof data == "undefined")
						{
							conError=2;
						}
						else
						{
							if(!(typeof data == "object"))
							{
								data=eval("("+data+")");
							}
						}
						if(curForm.options.callback)
						{
							var $callbackFun=curForm.options.callback;
							eval($callbackFun+"(conError,curForm,data)");
						}
						else
						{
							curlHandler.prototype.jsonpSuccessCallback.call(curForm);
						}
					},
					error:function(xhr)
					{
						if(curForm.options.callback)
						{
							var $callbackFun=curForm.options.callback;
							eval($callbackFun+"(3,curForm,xhr)");
						}
						else
						{
							curlHandler.prototype.jsonpErrorCallback.call(curForm);
						}
					},
					complete:function(xhr)
					{
						if(curForm.options.callback)
						{
							var $callbackFun=curForm.options.callback;
							eval($callbackFun+"(4,curForm,xhr)");
						}
						else
						{
							curlHandler.prototype.jsonpCompleteCallback.call(curForm);
						}
					}
				});
			}
			else
			{
				console.log("请配置URL地址！");
			}
		}
	};

	$.fn.commonSubmit = function(options)
	{
		var curlObj = new curlHandler(this,options);
		return curlObj.commonSubmit();
	};

})(jQuery, window, document);

function jsonpCallback(data){ }
