var arrLang = {
  "cn": {
      "loginTitle": "管理员登录",
      "loginIdentityPlaceholder": "用户名",
      "loginIdentityKeyPlaceholder": "密码",
      "loginBtn": "登录",
      "loginWelcomeText": "欢迎登陆后台管理系统",
      "crumbsCurrentLocation": "当前位置：",
      "publicOpRefresh": "刷新",
      "publicSelectLang": "Language：",
      "publicSelectTimeZone": "时区：",
      "publicInformation": "信息",
      "message": "信息",
      "confirm": "确认",
      "cancel": "取消",
      "myDesktop": "我的桌面",
      "publicCorrectData": "矫正数据",
      "publicSyncData": "Sync Data",
      "publicId": "ID",
      "publicSelect": "请选择",
      "publicEditSelectFile": "上传文件：",
      "publicInsert": "添加",
      "publicModifyPrice": "修改价格",
      "publicUpdate": "修改",
      "publicSearch": "搜索",
      "publicVersion": "版本信息",
      "publicReport": "导出",
      "publicReportExcel": "导出 Excel",
      "publicReportPhp": "导出 Php",
      "publicReportJs": "导出 Js",
      "publicImport": "导入",
      "publicExport": "导出",
      "publicDelete": "删除",
      "publicDetails": "详情",
      "publicRefundRequest": "退款请求",
      "publicSubmitBtn": "提交",
      "publicSearchBtn": "搜索",
      "publicSearchInputPlaceholder": "关键字搜索",
      "publicSelectSearchType": "请选择搜索类型",
      "publicSelectSearchOp": "请选择搜索操作",
      "publicDeleteMore": "批量删除",
      "publicAskSureExec": "确认要执行吗?",
      "publicAlreadyExecOp": "已执行操作!",
      "publicSystemException": "系统异常，请联系管理员！",
      "publicPleaseSelectDataFirst": "请先选择数据",
      "publicAskDeleteMore": "确认要批量删除吗？",
      "publicAskGenerateMore": "确认要批量生成吗？",
      "publicAskDelete": "确认要删除吗",
      "publicSearchNoData": "没有查询到数据",
      "publicSelectIsEnable": "请选择开启状态",
      "publicSelectStatus": "请选择状态",
      "publicSelectIsLock": "请选择是否锁定",
      "publicEditIsEnable": "开启状态：",
      "publicEditStatus": "状态：",
      "publicListFieldIsEnable": "开启状态",
      "publicListFieldStatus": "状态",
      "publicIsEnable": {
          "1": "启用",
          "0": "禁用"
      },
      "publicOp": {
          "=": "=",
          ">=": ">=",
          "<=": "<=",
          "!=": "<>",
          ">": ">",
          "<": "<",
      },
      "publicSelectIsShow": "请选择是否显示",
      "publicEditIsShow": "显示：",
      "publicListFieldIsShow": "显示",
      "publicIsShow": {
          "1": "显示",
          "0": "隐藏"
      },
      "publicListFieldOp": "操作",
      "publicListFieldCreateTime": "创建时间",
      "publicListFieldUpdateTime": "更新时间",
      "publicListFieldSendTime": "发送时间",
      "publicListFieldExpireTime": "过期时间",
      "publicListFieldQueryTime": "查询时间",
      "publicListFieldVersion": "version",
      "adminSearchType": {
          "1": "数据ID",
          "2": "用户名-精准匹配",
          "3": "用户名-模糊匹配",
          "4": "昵称-精准匹配",
          "5": "昵称-模糊匹配"
      },
      "adminLoginOut": "退出",
      "adminListFieldIdentity": "用户名",
      "adminListFieldRoleId": "角色",
      "adminListFieldLoginCount": "登录次数",
      "adminListFieldLastLoginTime": "最后登录时间",
      "adminListFieldLastLoginIp": "最后登录IP",
      "adminListOpModifyPwd": "修改密码",
      "adminListOpRecordNode": "录入节点",
      "adminEditRoleId": "选择角色：",
      "adminEditIdentity": "账号名称：",
      "adminEditIdentityPlaceholder": "请输入账号名称",
      "adminEditIdentityKey": "账号密码：",
      "adminEditIdentityKeyPlaceholder": "请输入账号密码",
      "adminEditNickname": "账号昵称：",
      "adminEditNicknamePlaceholder": "请输入账号昵称",
      "adminEditTimeZone": "时区：",
      "adminEditLang": "语言：",
      "adminEditBeizhu": "备注：",
      "roleSearchType": {
          "1": "数据ID",
          "2": "角色名称",
      },
      "roleListName": "角色名称",
      "roleEditName": "角色名称：",
      "roleEditNamePlaceholder": "请输入角色名称",
      "roleEditGrantAuthorization": "请输入角色名称",
      "roleNavSearchType": {
          "1": "数据ID",
          "2": "名称",
      },
      "roleNavListName": "名称",
      "roleNavListSort": "排序",
      "roleNavListNavIcon": "图标",
      "roleNavListPid": "上级",
      "roleNavEditPid": "选择上级：",
      "roleNavEditName": "名称：",
      "roleNavEditNamePlaceholder": "请输入名称",
      "roleNavEditNavIcon": "图标：",
      "roleNavEditNavIconPlaceholder": "请输入图标",
      "roleNavEditSort": "排序：",
      "roleNavEditSortPlaceholder": "请输入排序值，从小到大排序。",
      "roleNodeSearchType": {
          "1": "数据ID",
          "2": "方法名称",
          "4": "路由",
          "5": "控制器名称",
          "6": "方法"
      },
      "roleNodeBtnRecordAuth": "录入权限",
      "roleNodeSelectNavId": "请选择菜单",
      "roleNodeListNavId": "菜单",
      "roleNodeListModuleName": "路由",
      "roleNodeListModule": "控制器名称",
      "roleNodeListActionName": "方法名称",
      "roleNodeListAction": "方法",
      "roleNodeListSort": "排序",
      "roleNodeEditNavId": "选择菜单：",
      "roleNodeEditModuleName": "路由：",
      "roleNodeEditModuleNamePlaceholder": "请输入名称",
      "roleNodeEditModule": "控制器名称：",
      "roleNodeEditModulePlaceholder": "请输入控制器名称",
      "roleNodeEditActionName": "方法名称：",
      "roleNodeEditActionNamePlaceholder": "请输入方法名称",
      "roleNodeEditAction": "方法：",
      "roleNodeEditActionPlaceholder": "请输入方法",
      "roleNodeEditSort": "排序：",
      "roleNodeEditSortPlaceholder": "请输入排序值，从小到大排序。",
      "roleNodeEditClassName": "类名称",
      "roleNodeEditClassNamePlaceholder": "请输入类名称",

      "pulicSearchSelect": "请选择",
      "pulicSearchSelectIsLock": "请选择是否锁定",
      "publicEditIsLock": "是否锁定：",
      "publicListFieldIsLock": "是否锁定",

      "statUserBehaviorSearchType": {
          "1": "数据ID",
      },
      "statUserBehaviorDay": "日期",
      "statUserBehaviorLoginNums": "登录数",
      "statUserBehaviorRegNums": "注册数",

      "jobSearchType": {
          "1": "数据ID",
          "2": "任务索引",
          "3": "任务号",
          "4": "数据号",
      },
      "jobName": "名称",
      "jobNo": "任务号",
      "jobTaskQueueMsgNo": "数据号",
      "jobIndex": "任务索引",
      "jobConsumeStatus": "消费状态",
      "jobConsumeTime": "消费时间",
      "jobContent": "任务内容",
      "jobHandStatus": "执行状态",
      "jobHandTime": "执行时间",
      "jobExpireTime": "过期时间",
      "jobLog": "任务日志",
      "jobExecTime": "执行时间",
      "jobExecResult": "执行结果",

      "statFenOrderSearchType": {
          "1": "数据ID",
      },
      "statFenOrderDay": "日期",
      "statFenOrderOrderNums": "订单数",
      "statFenOrderFenOrderNums": "分销订单数",
      "statFenOrderReduceOrderAmount": "退款订单金额",
      "statFenOrderFenOrderAmount": "分销订单金额",
      "statFenOrderReduceOrderNums": "退款订单数",

      "statOpCheckSearchOp": {
          "1": "增加",
          "2": "减少",
      },
      "statOpCheckSearchType": {
          "1": "数据ID",
          "2": "任务标识",
      },
      "statOpCheckSearchOpTxt": "请选择操作类型",
      "statOpCheckSearchTaskTypeTxt": "请输入任务类型",
      "statOpCheckSearchDataTypeTxt": "请选择数据类型",

      "statOpCheckDataType": "数据类型",
      "statOpCheckTaskType": "任务类型",
      "statOpCheckOp": "操作类型",
      "statOpCheckTaskId": "任务标识",

      "statOrderSearchType": {
          "1": "数据ID",
          "2": "实付金额",
          "3": "支付订单金额",
          "4": "退款订单金额",
      },
      "statOrderDay": "日期",
      "statOrderOrderNums": "订单数",
      "statOrderPayOrderNums": "支付订单数",
      "statOrderOrderAmount": "订单金额",
      "statOrderRealAmount": "实付金额",
      "statOrderPayOrderAmount": "支付订单金额",
      "statOrderPayUserNums": "支付用户数",
      "statOrderUserNums": "用户数",
      "statOrderReduceOrderNums": "退款订单数",
      "statOrderReduceOrderAmount": "退款订单金额",

      "statOrderRepeatDataCheckSearchType": {
          "1": "数据ID",
          "2": "用户guid",
          "3": "索引",
      },
      "statOrderRepeatDataCheckIndex": "索引",
      "statOrderRepeatDataCheckDay": "日期",
      "statOrderRepeatDataCheckGuid": "用户guid",

      "statRepeatDataOpLockSearchType": {
          "1": "数据ID",
          "2": "索引",
      },
      "statRepeatDataOpLockListIndex": "索引",
      "statRepeatDataOpLockEditIndex": "索引",
      "statRepeatDataOpLockEditIndexPlaceholder": "请输入索引",

      "gptOrderVipSearchStatusTxt": "请选择订单状态",
      "gptOrderVipSearchPayStatusTxt": "请选择支付状态",
      "gptOrderVipSearchStatus": {
          "1": "待支付",
          "2": "已支付",
          "3": "已取消",
          "4": "已作废",
          "5": "已完成",
          "6": "已关闭",
          "7": "已退款",
          "8": "部分退款",
      },
      "gptOrderVipSearchPayStatus": {
          "1": "已支付",
          "0": "未支付",
      },
      "gptOrderVipSearchType": {
          "1": "数据ID",
          "2": "订单金额",
          "3": "实付金额",
          "4": "用户guid",
          "5": "用户昵称",
      },
      "gptOrderVipOrderNo": "订单号",
      "gptOrderVipGuid": "用户",
      "gptOrderVipOrderAmount": "订单金额",
      "gptOrderVipRealAmount": "实付金额",
      "gptOrderVipStatus": "订单状态",
      "gptOrderVipPayStatus": "支付状态",
      "gptOrderVipPayActionType": "支付方式",
      "gptOrderVipDistributionStatus": "配送状态",
      "gptOrderVipIsCheckout": "是否结算",

      "gptOrderVipDeailOpConfirmPayment": "确认支付",
      "gptOrderVipDeailOpConfirmRefund": "确认退款",
      "gptOrderVipDeailOpConfirmRefresh": "刷新",
      "gptOrderVipDeailNavBaseInfo": "基本信息",
      "gptOrderVipDeailNavBehavior": "行为",
      "gptOrderVipDeailNavNote": "备注",

      "gptOrderVipGoodsDeailListGoodsNo": "货号",
      "gptOrderVipGoodsDeailListName": "名称",
      "gptOrderVipGoodsDeailListPrice": "市场价",
      "gptOrderVipGoodsDeailListRealPrice": "销售价",
      "gptOrderVipGoodsDeailListNums": "数量",
      "gptOrderVipGoodsDeailListGoodsId": "商品id",
      "gptOrderVipGoodsDeailListIsSend": "配送状态",
      "gptOrderVipGoodsDeailListIsCheckout": "结算状态",
      "gptOrderVipGoodsDeailListIsRefund": "退款状态",
      "gptOrderVipGoodsDeailListGoodsType": "商品类型",
      "gptOrderVipGoodsDeailListReward": "奖励",

      "gptBehaviorOrderDeailListOrderId": "订单id",
      "gptBehaviorOrderDeailListType": "类型",
      "gptBehaviorOrderDeailListIsSend": "是否发送",
      "gptBehaviorOrderDeailListIsConsume": "是否消费",
      "gptBehaviorOrderDeailListIsSendTime": "发送时间",
      "gptBehaviorOrderDeailListIsConsumeTime": "消费时间",

      "gptOrderVipInfo": "订单信息",
      "gptOrderVipUserInfo": "用户信息",
      "gptOrderVipPayInfo": "支付信息",
      "gptOrderVipDeliveryInfo": "配送信息",
      "gptOrderVipCheckoutInfo": "分销信息",
      "gptOrderVipRefundInfo": "退款信息",

      "gptOrderVipDeailShowOrderNo": "订单号",
      "gptOrderVipDeailShowOrderAmount": "订单金额",
      "gptOrderVipDeailShowRealAmount": "实付金额",
      "gptOrderVipDeailShowStatus": "订单状态",
      "gptOrderVipDeailShowPayStatus": "支付状态",
      "gptOrderVipDeailShowDistributionStatus": "配送状态",
      "gptOrderVipDeailShowType": "订单类型",
      "gptOrderVipDeailShowNote": "订单备注",
      "gptOrderVipDeailShowNotePlaceholder": "请输入订单备注",
      "gptOrderVipDeailShowPayTime": "支付时间",
      "gptOrderVipDeailShowCompletionTime": "完成时间",
      "gptOrderVipDeailShowOutTime": "过期时间",
      "gptOrderVipDeailShowCreateTime": "创建时间",
      "gptOrderVipDeailShowUpdateTime": "更新时间",
      "gptOrderVipDeailShowTradeNo": "交易单号",
      "gptOrderVipDeailShowSendTime": "发货时间",
      "gptOrderVipDeailShowIsDel": "是否删除",
      "gptOrderVipDeailShowPayFee": "支付手续费",
      "gptOrderVipDeailShowTaxes": "税金",
      "gptOrderVipDeailShowTradeRealAmount": "回调金额",
      "gptOrderVipDeailShowRefundTime": "退款时间",
      "gptOrderVipDeailShowDecimals": "小数位数",
      "gptOrderVipDeailShowActiveId": "活动Id",
      "gptOrderVipDeailShowPayType": "支付类型",
      "gptOrderVipDeailShowPayActionType": "支付方式",
      "gptOrderVipDeailShowDescription": "订单描述",
      "gptOrderVipDeailShowCurrency": "币种",
      "gptOrderVipDeailShowCheckoutConfig": "分销比例",
      "gptOrderVipDeailShowIsCheckout": "是否结算",
      "gptOrderVipDeailShowCheckoutTime": "结算时间",
      "gptOrderVipDeailShowRefundStatus": "退款状态",
      "gptOrderVipDeailUserGuid": "用户guid",
      "gptOrderVipDeailUserNickname": "用户昵称",
      "gptOrderVipDeailPayId": "支付名称",

      "gptOrderFenxiaoSearchTypeTxt": "请选择订单类型",
      "gptOrderFenxiaoSearchType": {
          "1": "分成",
          "2": "退款",
      },
      "gptOrderFenxiaoSearchInputType": {
          "1": "数据id",
          "2": "订单金额",
          "3": "实付金额",
          "4": "用户guid",
          "5": "用户昵称",
          "6": "受益人guid",
          "7": "受益人昵称",
      },

      "gptOrderFenxiaoId": "订单id",
      "gptOrderFenxiaoOrderNo": "订单号",
      "gptOrderFenxiaoOrderAmount": "订单金额",
      "gptOrderFenxiaoRealAmount": "实付金额",
      "gptOrderFenxiaoGuid": "用户",
      "gptOrderFenxiaoVipOrderNo": "源单号",
      "gptOrderFenxiaoDecimals": "小数位数",
      "gptOrderFenxiaoCurrency": "币种",
      "gptOrderFenxiaoFenRealAmount": "分销金额",
      "gptOrderFenxiaoFenGuid": "受益人",
      "gptOrderFenxiaoType": "订单类型",

      "gptOrderFenxiaoGoodsId": "id",
      "gptOrderFenxiaoGoodsOrderNo": "订单号",
      "gptOrderFenxiaoGoodsName": "商品名称",
      "gptOrderFenxiaoGoodsPrice": "市场价",
      "gptOrderFenxiaoGoodsRealPrice": "销售价",
      "gptOrderFenxiaoGoodsFenPrice": "分销价格",
      "gptOrderFenxiaoGoodsGoodsId": "商品id",
      "gptOrderFenxiaoGoodsDecimals": "小数位数",
      "gptOrderFenxiaoGoodsGoodsType": "商品类型",
      "gptOrderFenxiaoGoodsGoodsNo": "货号",
      "gptOrderFenxiaoGoodsFenRate": "分销比例",
      "gptOrderFenxiaoGoodsFenVipId": "分销组",
      "gptOrderFenxiaoGoodsVipOrderNo": "源单号",

      "gptOrderFenxiaoInfo": "订单信息",
      "gptOrderFenxiaoUserInfo": "用户信息",
      "gptOrderFenxiaoFenUserInfo": "收益人信息",

      "gptOrderFenxiaoDeailUserGuid": "用户guid",
      "gptOrderFenxiaoDeailUserNickname": "用户昵称",

      "gptOrderFenxiaoDeailFenUserGuid": "受益人guid",
      "gptOrderFenxiaoDeailFenUserNickname": "受益人昵称",

      "jobTaskConsumeSearchType": {
          "1": "数据ID",
          "2": "索引",
          "3": "名称",
      },
      "jobTaskConsumeListIndex": "索引",
      "jobTaskConsumeListName": "名称",
      "jobTaskConsumeEditIndex": "索引",
      "jobTaskConsumeEditIndexPlaceholder": "请输入索引",
      "jobTaskConsumeEditName": "名称",
      "jobTaskConsumeEditNamePlaceholder": "请输入名称",

      "jobTaskQueueSearchType": {
          "1": "数据ID",
          "2": "频道",
          "3": "队列",
          "4": "名称",
      },

      "jobTaskQueueListChannel": "频道",
      "jobTaskQueueListQueue": "队列",
      "jobTaskQueueListName": "名称",

      "jobTaskQueueEditChannel": "频道",
      "jobTaskQueueEditChannelPlaceholder": "请输入频道",
      "jobTaskQueueEditQueue": "队列",
      "jobTaskQueueEditQueuePlaceholder": "请输入队列",
      "jobTaskQueueEditName": "名称",
      "jobTaskQueueEditNamePlaceholder": "请输入名称",

      "jobTaskSubscribeSearchType": {
          "1": "数据ID",
          "2": "消费者id",
          "3": "队列id",
      },

      "jobTaskSubscribeListJobTaskQueueId": "队列id",
      "jobTaskSubscribeListJobTaskConsumeId": "消费者id",

      "jobTaskSubscribeEditJobTaskQueueId": "队列id",
      "jobTaskSubscribeEditJobTaskQueueIdPlaceholder": "请输入队列id",
      "jobTaskSubscribeEditJobTaskConsumeId": "消费者id",
      "jobTaskSubscribeEditJobTaskConsumeIdPlaceholder": "请输入消费者id",

      "jobTaskQueueMsgSearchType": {
          "1": "数据ID",
          "2": "频道名称",
          "3": "队列名称",
          "4": "名称",
          "5": "任务号",
      },
      "jobTaskQueueMsgSearchConsumeStatus": {
          "0": "未消费",
          "1": "已消费",
          "2": "部分消费",
      },
      "jobTaskQueueMsgSearchSendStatus": {
          "0": "待确认",
          "1": "确认发送",
          "2": "已发送",
      },
      "jobTaskQueueMsgSearchCallbackStatus": {
          "0": "未回调",
          "1": "已回调",
          "2": "无需回调",
      },
      "jobTaskQueueMsgSearchConsumeStatusTxt": "请选择消费状态",
      "jobTaskQueueMsgSearchSendStatusTxt": "请选择发送状态",
      "jobTaskQueueMsgSearchCallbackStatusTxt": "请选择回调状态",

      "jobTaskQueueMsgListJobNo": "任务号",
      "jobTaskQueueMsgListName": "名称",
      "jobTaskQueueMsgListChannel": "频道",
      "jobTaskQueueMsgListQueue": "队列",
      "jobTaskQueueMsgListSendStatus": "发送状态",
      "jobTaskQueueMsgListConsumeStatus": "消费状态",
      "jobTaskQueueMsgListCallbackStatus": "回调状态",

      "jobTaskQueueMsgEditName": "名称",
      "jobTaskQueueMsgEditNamePlaceholder": "请输入名称",
      "jobTaskQueueMsgEditChannel": "频道",
      "jobTaskQueueMsgEditChannelPlaceholder": "请输入频道",
      "jobTaskQueueMsgEditQueue": "队列",
      "jobTaskQueueMsgEditQueuePlaceholder": "请输入队列",
      "jobTaskQueueMsgEditContent": "任务数据",
      "jobTaskQueueMsgEditContentPlaceholder": "请输入任务数据",
      "jobTaskQueueMsgEditCallback": "回调地址",
      "jobTaskQueueMsgEditCallbackPlaceholder": "请输入回调地址",
  },
  "en": {
      "loginTitle": "管理员登录",
      "loginIdentityPlaceholder": "用户名",
      "loginIdentityKeyPlaceholder": "密码",
      "loginBtn": "登录",
      "loginWelcomeText": "欢迎登陆后台管理系统",
      "crumbsCurrentLocation": "当前位置：",
      "publicOpRefresh": "刷新",
      "publicSelectLang": "Language：",
      "publicSelectTimeZone": "时区：",
      "publicInformation": "信息",
      "message": "信息",
      "confirm": "确认",
      "cancel": "取消",
      "myDesktop": "我的桌面",
      "publicCorrectData": "矫正数据",
      "publicSyncData": "Sync Data",
      "publicId": "ID",
      "publicSelect": "请选择",
      "publicEditSelectFile": "上传文件：",
      "publicInsert": "添加",
      "publicModifyPrice": "修改价格",
      "publicUpdate": "修改",
      "publicSearch": "搜索",
      "publicVersion": "版本信息",
      "publicReport": "导出",
      "publicReportExcel": "导出 Excel",
      "publicReportPhp": "导出 Php",
      "publicReportJs": "导出 Js",
      "publicImport": "导入",
      "publicExport": "导出",
      "publicDelete": "删除",
      "publicDetails": "详情",
      "publicRefundRequest": "退款请求",
      "publicSubmitBtn": "提交",
      "publicSearchBtn": "搜索",
      "publicSearchInputPlaceholder": "关键字搜索",
      "publicSelectSearchType": "请选择搜索类型",
      "publicSelectSearchOp": "请选择搜索操作",
      "publicDeleteMore": "批量删除",
      "publicAskSureExec": "确认要执行吗?",
      "publicAlreadyExecOp": "已执行操作!",
      "publicSystemException": "系统异常，请联系管理员！",
      "publicPleaseSelectDataFirst": "请先选择数据",
      "publicAskDeleteMore": "确认要批量删除吗？",
      "publicAskGenerateMore": "确认要批量生成吗？",
      "publicAskDelete": "确认要删除吗",
      "publicSearchNoData": "没有查询到数据",
      "publicSelectIsEnable": "请选择开启状态",
      "publicSelectStatus": "请选择状态",
      "publicSelectIsLock": "请选择是否锁定",
      "publicEditIsEnable": "开启状态：",
      "publicEditStatus": "状态：",
      "publicListFieldIsEnable": "开启状态",
      "publicListFieldStatus": "状态",
      "publicIsEnable": {
          "1": "启用",
          "0": "禁用"
      },
      "publicOp": {
          "=": "=",
          ">=": ">=",
          "<=": "<=",
          "!=": "<>",
          ">": ">",
          "<": "<",
      },
      "publicSelectIsShow": "请选择是否显示",
      "publicEditIsShow": "显示：",
      "publicListFieldIsShow": "显示",
      "publicIsShow": {
          "1": "显示",
          "0": "隐藏"
      },
      "publicListFieldOp": "操作",
      "publicListFieldCreateTime": "创建时间",
      "publicListFieldUpdateTime": "更新时间",
      "publicListFieldSendTime": "发送时间",
      "publicListFieldExpireTime": "过期时间",
      "publicListFieldQueryTime": "查询时间",
      "publicListFieldVersion": "version",
      "adminSearchType": {
          "1": "数据ID",
          "2": "用户名-精准匹配",
          "3": "用户名-模糊匹配",
          "4": "昵称-精准匹配",
          "5": "昵称-模糊匹配"
      },
      "adminLoginOut": "退出",
      "adminListFieldIdentity": "用户名",
      "adminListFieldRoleId": "角色",
      "adminListFieldLoginCount": "登录次数",
      "adminListFieldLastLoginTime": "最后登录时间",
      "adminListFieldLastLoginIp": "最后登录IP",
      "adminListOpModifyPwd": "修改密码",
      "adminListOpRecordNode": "录入节点",
      "adminEditRoleId": "选择角色：",
      "adminEditIdentity": "账号名称：",
      "adminEditIdentityPlaceholder": "请输入账号名称",
      "adminEditIdentityKey": "账号密码：",
      "adminEditIdentityKeyPlaceholder": "请输入账号密码",
      "adminEditNickname": "账号昵称：",
      "adminEditNicknamePlaceholder": "请输入账号昵称",
      "adminEditTimeZone": "时区：",
      "adminEditLang": "语言：",
      "adminEditBeizhu": "备注：",
      "roleSearchType": {
          "1": "数据ID",
          "2": "角色名称",
      },
      "roleListName": "角色名称",
      "roleEditName": "角色名称：",
      "roleEditNamePlaceholder": "请输入角色名称",
      "roleEditGrantAuthorization": "请输入角色名称",
      "roleNavSearchType": {
          "1": "数据ID",
          "2": "名称",
      },
      "roleNavListName": "名称",
      "roleNavListSort": "排序",
      "roleNavListNavIcon": "图标",
      "roleNavListPid": "上级",
      "roleNavEditPid": "选择上级：",
      "roleNavEditName": "名称：",
      "roleNavEditNamePlaceholder": "请输入名称",
      "roleNavEditNavIcon": "图标：",
      "roleNavEditNavIconPlaceholder": "请输入图标",
      "roleNavEditSort": "排序：",
      "roleNavEditSortPlaceholder": "请输入排序值，从小到大排序。",
      "roleNodeSearchType": {
          "1": "数据ID",
          "2": "方法名称",
          "4": "路由",
          "5": "控制器名称",
          "6": "方法"
      },
      "roleNodeBtnRecordAuth": "录入权限",
      "roleNodeSelectNavId": "请选择菜单",
      "roleNodeListNavId": "菜单",
      "roleNodeListModuleName": "路由",
      "roleNodeListModule": "控制器名称",
      "roleNodeListActionName": "方法名称",
      "roleNodeListAction": "方法",
      "roleNodeListSort": "排序",
      "roleNodeEditNavId": "选择菜单：",
      "roleNodeEditModuleName": "路由：",
      "roleNodeEditModuleNamePlaceholder": "请输入名称",
      "roleNodeEditModule": "控制器名称：",
      "roleNodeEditModulePlaceholder": "请输入控制器名称",
      "roleNodeEditActionName": "方法名称：",
      "roleNodeEditActionNamePlaceholder": "请输入方法名称",
      "roleNodeEditAction": "方法：",
      "roleNodeEditActionPlaceholder": "请输入方法",
      "roleNodeEditSort": "排序：",
      "roleNodeEditSortPlaceholder": "请输入排序值，从小到大排序。",
      "roleNodeEditClassName": "类名称",
      "roleNodeEditClassNamePlaceholder": "请输入类名称",

      "pulicSearchSelect": "请选择",
      "pulicSearchSelectIsLock": "请选择是否锁定",
      "publicEditIsLock": "是否锁定：",
      "publicListFieldIsLock": "是否锁定",

      "statUserBehaviorSearchType": {
          "1": "数据ID",
      },
      "statUserBehaviorDay": "日期",
      "statUserBehaviorLoginNums": "登录数",
      "statUserBehaviorRegNums": "注册数",

      "jobSearchConsumeStatusTxt": "请选择消费状态",
      "jobSearchHandStatusTxt": "请选择执行状态",
      "jobSearchConsumeStatus": {
          "0": "未消费",
          "1": "已消费",
      },
      "jobSearchHandStatus": {
          "0": "未执行",
          "1": "正在执行",
          "2": "执行完毕",
          "3": "执行失败",
      },
      "jobSearchType": {
          "1": "数据ID",
          "2": "任务索引",
          "3": "任务号",
          "4": "数据号",
      },
      "jobName": "名称",
      "jobNo": "任务号",
      "jobTaskQueueMsgNo": "数据号",
      "jobIndex": "任务索引",
      "jobConsumeStatus": "消费状态",
      "jobConsumeTime": "消费时间",
      "jobContent": "任务内容",
      "jobHandStatus": "执行状态",
      "jobHandTime": "执行时间",
      "jobExpireTime": "过期时间",
      "jobLog": "任务日志",
      "jobExecTime": "执行时间",
      "jobExecResult": "执行结果",

      "statFenOrderSearchType": {
          "1": "数据ID",
          "2": "分成金额",
          "3": "退款金额",
      },
      "statFenOrderDay": "日期",
      "statFenOrderOrderNums": "订单数",
      "statFenOrderFenOrderNums": "分销订单数",
      "statFenOrderReduceOrderAmount": "退款订单金额",
      "statFenOrderFenOrderAmount": "分销订单金额",
      "statFenOrderReduceOrderNums": "退款订单数",

      "statOpCheckSearchOp": {
          "1": "增加",
          "2": "减少",
      },
      "statOpCheckSearchType": {
          "1": "数据ID",
          "2": "任务标识",
      },
      "statOpCheckSearchOpTxt": "请选择操作类型",
      "statOpCheckSearchTaskTypeTxt": "请输入任务类型",
      "statOpCheckSearchDataTypeTxt": "请选择数据类型",

      "statOpCheckDataType": "数据类型",
      "statOpCheckTaskType": "任务类型",
      "statOpCheckOp": "操作类型",
      "statOpCheckTaskId": "任务标识",

      "statOrderSearchType": {
          "1": "数据ID",
          "2": "实付金额",
          "3": "支付订单金额",
          "4": "退款订单金额",
      },
      "statOrderDay": "日期",
      "statOrderOrderNums": "订单数",
      "statOrderPayOrderNums": "支付订单数",
      "statOrderOrderAmount": "订单金额",
      "statOrderRealAmount": "实付金额",
      "statOrderPayOrderAmount": "支付订单金额",
      "statOrderPayUserNums": "支付用户数",
      "statOrderUserNums": "用户数",
      "statOrderReduceOrderNums": "退款订单数",
      "statOrderReduceOrderAmount": "退款订单金额",

      "statOrderRepeatDataCheckSearchType": {
          "1": "数据ID",
          "2": "用户guid",
          "3": "索引",
      },
      "statOrderRepeatDataCheckIndex": "索引",
      "statOrderRepeatDataCheckDay": "日期",
      "statOrderRepeatDataCheckGuid": "用户guid",

      "statRepeatDataOpLockSearchType": {
          "1": "数据ID",
          "2": "索引",
      },
      "statRepeatDataOpLockListIndex": "索引",
      "statRepeatDataOpLockEditIndex": "索引",
      "statRepeatDataOpLockEditIndexPlaceholder": "请输入索引",

      "gptOrderVipSearchStatusTxt": "请选择订单状态",
      "gptOrderVipSearchPayStatusTxt": "请选择支付状态",
      "gptOrderVipSearchStatus": {
          "1": "待支付",
          "2": "已支付",
          "3": "已取消",
          "4": "已作废",
          "5": "已完成",
          "6": "已关闭",
          "7": "已退款",
          "8": "部分退款",
      },
      "gptOrderVipSearchPayStatus": {
          "1": "已支付",
          "0": "未支付",
      },
      "gptOrderVipSearchType": {
          "1": "数据ID",
          "2": "订单金额",
          "3": "实付金额",
          "4": "用户guid",
          "5": "用户昵称",
      },
      "gptOrderVipOrderNo": "订单号",
      "gptOrderVipGuid": "用户",
      "gptOrderVipOrderAmount": "订单金额",
      "gptOrderVipRealAmount": "实付金额",
      "gptOrderVipStatus": "订单状态",
      "gptOrderVipPayStatus": "支付状态",
      "gptOrderVipPayActionType": "支付方式",
      "gptOrderVipDistributionStatus": "配送状态",
      "gptOrderVipIsCheckout": "是否结算",

      "gptOrderVipDeailOpConfirmPayment": "确认支付",
      "gptOrderVipDeailOpConfirmRefund": "确认退款",
      "gptOrderVipDeailOpConfirmRefresh": "刷新",
      "gptOrderVipDeailNavBaseInfo": "基本信息",
      "gptOrderVipDeailNavBehavior": "行为",
      "gptOrderVipDeailNavNote": "备注",

      "gptOrderVipGoodsDeailListGoodsNo": "货号",
      "gptOrderVipGoodsDeailListName": "名称",
      "gptOrderVipGoodsDeailListPrice": "市场价",
      "gptOrderVipGoodsDeailListRealPrice": "销售价",
      "gptOrderVipGoodsDeailListNums": "数量",
      "gptOrderVipGoodsDeailListGoodsId": "商品id",
      "gptOrderVipGoodsDeailListIsSend": "配送状态",
      "gptOrderVipGoodsDeailListIsCheckout": "结算状态",
      "gptOrderVipGoodsDeailListIsRefund": "退款状态",
      "gptOrderVipGoodsDeailListGoodsType": "商品类型",
      "gptOrderVipGoodsDeailListReward": "奖励",

      "gptBehaviorOrderDeailListOrderId": "订单id",
      "gptBehaviorOrderDeailListType": "类型",
      "gptBehaviorOrderDeailListIsSend": "是否发送",
      "gptBehaviorOrderDeailListIsConsume": "是否消费",
      "gptBehaviorOrderDeailListIsSendTime": "发送时间",
      "gptBehaviorOrderDeailListIsConsumeTime": "消费时间",

      "gptOrderVipInfo": "订单信息",
      "gptOrderVipUserInfo": "用户信息",
      "gptOrderVipPayInfo": "支付信息",
      "gptOrderVipDeliveryInfo": "配送信息",
      "gptOrderVipCheckoutInfo": "分销信息",
      "gptOrderVipRefundInfo": "退款信息",

      "gptOrderVipDeailShowOrderNo": "订单号",
      "gptOrderVipDeailShowOrderAmount": "订单金额",
      "gptOrderVipDeailShowRealAmount": "实付金额",
      "gptOrderVipDeailShowStatus": "订单状态",
      "gptOrderVipDeailShowPayStatus": "支付状态",
      "gptOrderVipDeailShowDistributionStatus": "配送状态",
      "gptOrderVipDeailShowType": "订单类型",
      "gptOrderVipDeailShowNote": "订单备注",
      "gptOrderVipDeailShowNotePlaceholder": "请输入订单备注",
      "gptOrderVipDeailShowPayTime": "支付时间",
      "gptOrderVipDeailShowCompletionTime": "完成时间",
      "gptOrderVipDeailShowOutTime": "过期时间",
      "gptOrderVipDeailShowCreateTime": "创建时间",
      "gptOrderVipDeailShowUpdateTime": "更新时间",
      "gptOrderVipDeailShowTradeNo": "交易单号",
      "gptOrderVipDeailShowSendTime": "发货时间",
      "gptOrderVipDeailShowIsDel": "是否删除",
      "gptOrderVipDeailShowPayFee": "支付手续费",
      "gptOrderVipDeailShowTaxes": "税金",
      "gptOrderVipDeailShowTradeRealAmount": "回调金额",
      "gptOrderVipDeailShowRefundTime": "退款时间",
      "gptOrderVipDeailShowDecimals": "小数位数",
      "gptOrderVipDeailShowActiveId": "活动Id",
      "gptOrderVipDeailShowPayType": "支付类型",
      "gptOrderVipDeailShowPayActionType": "支付方式",
      "gptOrderVipDeailShowDescription": "订单描述",
      "gptOrderVipDeailShowCurrency": "币种",
      "gptOrderVipDeailShowCheckoutConfig": "分销比例",
      "gptOrderVipDeailShowIsCheckout": "是否结算",
      "gptOrderVipDeailShowCheckoutTime": "结算时间",
      "gptOrderVipDeailShowRefundStatus": "退款状态",
      "gptOrderVipDeailUserGuid": "用户guid",
      "gptOrderVipDeailUserNickname": "用户昵称",
      "gptOrderVipDeailPayId": "支付名称",

      "gptOrderFenxiaoSearchTypeTxt": "请选择订单类型",
      "gptOrderFenxiaoSearchType": {
          "1": "分成",
          "2": "退款",
      },
      "gptOrderFenxiaoSearchInputType": {
          "1": "数据id",
          "2": "订单金额",
          "3": "实付金额",
          "4": "用户guid",
          "5": "用户昵称",
          "6": "受益人guid",
          "7": "受益人昵称",
      },

      "gptOrderFenxiaoId": "订单id",
      "gptOrderFenxiaoOrderNo": "订单号",
      "gptOrderFenxiaoOrderAmount": "订单金额",
      "gptOrderFenxiaoRealAmount": "实付金额",
      "gptOrderFenxiaoGuid": "用户",
      "gptOrderFenxiaoVipOrderNo": "源单号",
      "gptOrderFenxiaoDecimals": "小数位数",
      "gptOrderFenxiaoCurrency": "币种",
      "gptOrderFenxiaoFenRealAmount": "分销金额",
      "gptOrderFenxiaoFenGuid": "受益人",
      "gptOrderFenxiaoType": "订单类型",

      "gptOrderFenxiaoGoodsId": "id",
      "gptOrderFenxiaoGoodsOrderNo": "订单号",
      "gptOrderFenxiaoGoodsName": "商品名称",
      "gptOrderFenxiaoGoodsPrice": "市场价",
      "gptOrderFenxiaoGoodsRealPrice": "销售价",
      "gptOrderFenxiaoGoodsFenPrice": "分销价格",
      "gptOrderFenxiaoGoodsGoodsId": "商品id",
      "gptOrderFenxiaoGoodsDecimals": "小数位数",
      "gptOrderFenxiaoGoodsGoodsType": "商品类型",
      "gptOrderFenxiaoGoodsGoodsNo": "货号",
      "gptOrderFenxiaoGoodsFenRate": "分销比例",
      "gptOrderFenxiaoGoodsFenVipId": "分销组",
      "gptOrderFenxiaoGoodsVipOrderNo": "源单号",

      "gptOrderFenxiaoInfo": "订单信息",
      "gptOrderFenxiaoUserInfo": "用户信息",
      "gptOrderFenxiaoFenUserInfo": "收益人信息",

      "gptOrderFenxiaoDeailUserGuid": "用户guid",
      "gptOrderFenxiaoDeailUserNickname": "用户昵称",

      "gptOrderFenxiaoDeailFenUserGuid": "受益人guid",
      "gptOrderFenxiaoDeailFenUserNickname": "受益人昵称",

      "jobTaskConsumeSearchType": {
          "1": "数据ID",
          "2": "索引",
          "3": "名称",
      },
      "jobTaskConsumeListIndex": "索引",
      "jobTaskConsumeListName": "名称",
      "jobTaskConsumeEditIndex": "索引",
      "jobTaskConsumeEditIndexPlaceholder": "请输入索引",
      "jobTaskConsumeEditName": "名称",
      "jobTaskConsumeEditNamePlaceholder": "请输入名称",

      "jobTaskQueueSearchType": {
          "1": "数据ID",
          "2": "频道",
          "3": "队列",
          "4": "名称",
      },

      "jobTaskQueueListChannel": "频道",
      "jobTaskQueueListQueue": "队列",
      "jobTaskQueueListName": "名称",

      "jobTaskQueueEditChannel": "频道",
      "jobTaskQueueEditChannelPlaceholder": "请输入频道",
      "jobTaskQueueEditQueue": "队列",
      "jobTaskQueueEditQueuePlaceholder": "请输入队列",
      "jobTaskQueueEditName": "名称",
      "jobTaskQueueEditNamePlaceholder": "请输入名称",

      "jobTaskSubscribeSearchType": {
          "1": "数据ID",
          "2": "消费者id",
          "3": "队列id",
      },

      "jobTaskSubscribeListJobTaskQueueId": "队列id",
      "jobTaskSubscribeListJobTaskConsumeId": "消费者id",

      "jobTaskSubscribeEditJobTaskQueueId": "队列id",
      "jobTaskSubscribeEditJobTaskQueueIdPlaceholder": "请输入队列id",
      "jobTaskSubscribeEditJobTaskConsumeId": "消费者id",
      "jobTaskSubscribeEditJobTaskConsumeIdPlaceholder": "请输入消费者id",

      "jobTaskQueueMsgSearchType": {
          "1": "数据ID",
          "2": "频道名称",
          "3": "队列名称",
          "4": "名称",
          "5": "任务号",
      },
      "jobTaskQueueMsgSearchConsumeStatus": {
          "0": "未消费",
          "1": "已消费",
          "2": "部分消费",
      },
      "jobTaskQueueMsgSearchSendStatus": {
          "0": "待确认",
          "1": "确认发送",
          "2": "已发送",
      },
      "jobTaskQueueMsgSearchCallbackStatus": {
          "0": "未回调",
          "1": "已回调",
          "2": "无需回调",
      },
      "jobTaskQueueMsgSearchConsumeStatusTxt": "请选择消费状态",
      "jobTaskQueueMsgSearchSendStatusTxt": "请选择发送状态",
      "jobTaskQueueMsgSearchCallbackStatusTxt": "请选择回调状态",

      "jobTaskQueueMsgListJobNo": "任务号",
      "jobTaskQueueMsgListName": "名称",
      "jobTaskQueueMsgListChannel": "频道",
      "jobTaskQueueMsgListQueue": "队列",
      "jobTaskQueueMsgListSendStatus": "发送状态",
      "jobTaskQueueMsgListConsumeStatus": "消费状态",
      "jobTaskQueueMsgListCallbackStatus": "回调状态",

      "jobTaskQueueMsgEditName": "名称",
      "jobTaskQueueMsgEditNamePlaceholder": "请输入名称",
      "jobTaskQueueMsgEditChannel": "频道",
      "jobTaskQueueMsgEditChannelPlaceholder": "请输入频道",
      "jobTaskQueueMsgEditQueue": "队列",
      "jobTaskQueueMsgEditQueuePlaceholder": "请输入队列",
      "jobTaskQueueMsgEditContent": "任务数据",
      "jobTaskQueueMsgEditContentPlaceholder": "请输入任务数据",
      "jobTaskQueueMsgEditCallback": "回调地址",
      "jobTaskQueueMsgEditCallbackPlaceholder": "请输入回调地址",
  }
};

lang = "en";

$(function (){
    if(typeof($(".langText").val())!=="undefined"){
        lang=$(".langText").val();
    }
    initLang();
});

function initLang(){
    var other_arr=["placeholder","title","alert"];
    $(".lang").each(function(index, element) {
        var that=$(this);
        var data=$(that).data();
        $.each(data,function (k,v){
            if(k!="key" || k!="val"){
                if($.inArray(k,other_arr)!="-1"){
                    if(typeof (arrLang[lang][$(that).attr("data-"+k)]) !="undefined"){
                        if(k=="placeholder" || k=="title"){
                            $(that).attr(k,arrLang[lang][$(that).attr("data-"+k)]);
                        }else{
                            $(that).attr("data-"+k,arrLang[lang][$(that).attr("data-"+k)]);
                        }
                    }
                }
            }
        });

        if(typeof ($(that).attr("data-key"))!="undefined"){
           var text=arrLang[lang][$(that).attr("data-key")];

           if(typeof ($(that).attr("data-val"))!="undefined"){
                text=text[$(that).attr("data-val")];
           }

           if(typeof ($(that).attr("data-rp1"))!="undefined"){
               var reg = new RegExp("@1","g");
               text=text.replace(reg,$(that).attr("data-rp1"));
           }

           if(typeof ($(that).attr("data-rp2"))!="undefined"){
              var reg = new RegExp("@2","g");
              text=text.replace(reg,$(that).attr("data-rp2"));
           }

           if($(that).is("input")){
               $(that).val(text);
           }else{
               $(that).text(text);
           }
        }

    });
}
