<?php

namespace plugins\ltcms_install\controller;

use plugins\ltcms_install\db\D_install;

class Install
{
    public $db;

    public function __construct()
    {
        $this->db = new D_install();
    }

    /**
     * 步骤
     */
    public function step(){
        $step=request()->param("step","1");
        if($step=="2"){
            return $this->step2();
        }else if($step=="3"){
            return $this->step3();
        }else if($step=="4"){
            return $this->step4();
        }else if($step=="5"){
            return $this->step5();
        }else if($step=="6"){
            return $this->step6();
        }else{
           return  $this->step1();
        }
    }

    /**
     * 第一步
     */
    public function step1(){
        $agreement=$this->db->getUserAgreement();
        $data=array();
        $data["agreement"]=$agreement;
        $data["request"]=request()->param();
        return view("install/step1",$data)->templatePath("/plugins/ltcms_install/view");
    }

    /**
     * 第二步
     */
    public function step2(){
        $envData=$this->db->getEnv();
        $data=array();
        $data["envData"]=$envData;
        $data["request"]=request()->param();
        return view("install/step2",$data)->templatePath("/plugins/ltcms_install/view");
    }

    /**
     * 第三步
     */
    public function step3(){
        $fileData=$this->db->getFileStatus();
        $data=array();
        $data["fileData"]=$fileData;
        $data["request"]=request()->param();
        return view("install/step3",$data)->templatePath("/plugins/ltcms_install/view");
    }

    /**
     * 第四步
     */
    public function step4(){
        $dbInput=$this->db->getDbInput();
        $data=array();
        $data["dbInput"]=$dbInput;
        $data["request"]=request()->param();
        return view("install/step4",$data)->templatePath("/plugins/ltcms_install/view");
    }

    /**
     * 第五步
     */
    public function step5(){
        //获取管理员输入信息
        $info=$this->db->getHost();
        $adminInput=$this->db->getAdminInput();
        $data=array();
        $data["host"]=$info["host"];
        $data["adminInput"]=$adminInput;
        $data["request"]=request()->param();
        return view("install/step5",$data)->templatePath("/plugins/ltcms_install/view");
    }

    /**
     * 第六步
     */
    public function step6(){
        $info=$this->db->getInfo();
        //生成安装文件
        $this->db->installSuccessFile();
        $this->db->reportData();

        $data=array();
        $data["info"]=$info;
        $data["request"]=request()->param();
        return view("install/step6",$data)->templatePath("/plugins/ltcms_install/view");
    }

    /**
     * 执行数据
     */
    public function exec(){
        $step=request()->param("step");
        if($step=="checkdb"){
            $result=$this->db->dbCheck();
            return jsonResponse($result);
        }else if($step=="install"){
            $result=$this->db->install();
            return jsonResponse($result);
        }else{
            $result=$this->db->error();
            return jsonResponse($result);
        }
    }
}