<?php

namespace ltcms\session;

/**
 * session 文件缓存
 * Class Cache_file
 */
class Sessions_file
{
    public function __construct()
    {
        if(LTCMS_SESSION_DOMAIN){
            @ini_set('session.cookie_domain', LTCMS_SESSION_DOMAIN); //cookie有效作用域名
        }
        @ini_set('session.name', LTCMS_SESSION_NAME?LTCMS_SESSION_NAME:"cms_session"); //设置session名称
        @ini_set('session.auto_start', LTCMS_SESSION_AUTO_START?LTCMS_SESSION_AUTO_START:0); //默认关闭session
        @ini_set('session.gc_maxlifetime', LTCMS_SESSION_LIFETIME?LTCMS_SESSION_LIFETIME:1800); //设置过期时间
        @ini_set('session.cookie_lifetime', LTCMS_SESSION_LIFETIME?LTCMS_SESSION_LIFETIME:1800); //设置cookie有效期
        @ini_set('session.cookie_secure', LTCMS_SESSION_COOKIE_SECURE?LTCMS_SESSION_COOKIE_SECURE:0);
        @ini_set('session.cookie_httponly', LTCMS_SESSION_COOKIE_HTTPONLY?LTCMS_SESSION_COOKIE_HTTPONLY:0);
        @ini_set('session.save_handler', 'files');  //处理session存取的模式
        $dir = LTCMS_SESSION_DIR."/".strtolower(substr(md5(LTCMS_KEY), 2, 6)).'/';
        if(!is_dir($dir)) {
            makeDir($dir);
        }
        session_save_path($dir); //设置保存路径
        session_cache_limiter('private, must-revalidate');
        @session_start();
        header("cache-control: private, must-revalidate");
    }
}