<?php

namespace ltcms\service;

use app\utils\verify\Verify_param;
use app\utils\error\api\Error_level;
use app\utils\error\api\Error_code;

class Service
{
    private static $_instance;

    private function __construct(){}
    private function __clone(){ }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 注册服务
     */
    public function register(){
        $services=config("provider");
        if($services){
            foreach($services as $service){
                $obj=new $service();
                if(method_exists($obj,"register")){
                    $obj->register();
                }
            }
        }
    }

    /**
     * 服务启动
     */
    public function boot(){
        $services=config("provider");
        if($services){
            foreach($services as $service){
                $obj=new $service();
                if(method_exists($obj,"boot")){
                    $obj->boot();
                }
            }
        }
    }
}