<?php

namespace ltcms\route;

/**
 * 路由类
 * Class Router
 */
class Router
{
    public $method;
    public $uri;
    public $path;
    public $url;
    public $routeMap;
    public $routeRegMap;
    public $routeIndex=0;
    public $routeMethod="";
    private $cutMethod="";
    private $cutRoutePath="";
    private $groupMiddleware="";
    private $groupPrefix="";

    /**
     * 当前ROUTE参数
     * @var array
     */
    protected $route = [];

    private static $_instance;

    /**
     * REST定义
     * @var array
     */
    protected $rest = [
        'index'  => ['get', '', 'index'],
        'create' => ['get', '/create', 'create'],
        'edit'   => ['get', '/<id>/edit', 'edit'],
        'read'   => ['get', '/<id>', 'read'],
        'save'   => ['post', '', 'save'],
        'update' => ['put', '/<id>', 'update'],
        'delete' => ['delete', '/<id>', 'delete'],
    ];

    private function __construct(){
        $this->method = strtolower(request()->method());
        $this->uri = request()->query();
        $this->path = request()->pathinfo();
        $this->url = request()->url();
    }
    private function __clone(){ }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 初始化配置
     */
    public function loader(){
        //遍历配置目录
        $routerDirs=array(
            LTCMS_ROOT."/route",
        );
        foreach($routerDirs as $dir){
            $funcs=glob($dir."/*.php");
            if($funcs && is_array($funcs)){
                foreach($funcs as $file){
                    @include $file;
                }
            }
        }
        //加载插件路由
        $checkResult=app("L_Common_plugins")->getEnabledPlugins();
        if($checkResult["error_no"]=="0"){
            $plugin=$checkResult["result"];
            foreach($plugin as $pval){
                $classNamespace=$pval["pluginDir"]."/config";
                $classNamespace=str_replace("/","\\",$classNamespace);
                if(class_exists($classNamespace)){
                    $controllerObj=new $classNamespace;
                    if(method_exists($controllerObj,"init")){
                        @$controllerObj->init();
                    }
                }
            }
        }else{
            //记录错误信息
        }
    }

    /**
     * 设置路由变量
     * @access public
     * @param  array $route 路由变量
     * @return $this
     */
    public function setRoute(array $route)
    {
        $this->route      = $route;
        return $this;
    }

    /**
     * 派遣任务
     */
    public function dispatch()
    {
        $classNamespace="";
        $action = "";
        $paths = $this->path?explode('/',trim($this->path)):"";
        $middleware=array();
        $args = array();
        $argsVal = array();
        $argsKey = array();
        $route = array();

        //查找路由中是否有匹配的路由
        if($paths){
            $routePath=rtrim($this->path,"/");
            if(isset($this->routeMap[$this->method][$routePath])){
                $classNamespace=$this->routeMap[$this->method][$routePath]["controller"];
                if(isset($this->routeMap[$this->method][$routePath]["middleware"])){
                    $middleware=$this->routeMap[$this->method][$routePath]["middleware"];
                }
                if(isset($this->routeMap[$this->method][$routePath]["route"])){
                    $route=$this->routeMap[$this->method][$routePath]["route"];
                }
                $cnp=explode("/",$classNamespace);
                $action=array_pop($cnp);
                $classNamespace=implode("/",$cnp);
            }
            if(!$classNamespace){
                $routePath=rtrim($this->path,"/");
                $routeRegMap=isset($this->routeRegMap[$this->method])?$this->routeRegMap[$this->method]:array();
                if($routeRegMap){
                    foreach($routeRegMap as $rgval){
                        $ok=preg_match("/^{$rgval["reg"]}$/",$routePath,$matchs);
                        if($ok > 0){
                            $classNamespace=$rgval["controller"];
                            if(isset($rgval["middleware"])){
                                $middleware=$rgval["middleware"];
                            }
                            if(isset($rgval["route"])){
                                $route=$rgval["route"];
                            }
                            $cnp=explode("/",$classNamespace);
                            $action=array_pop($cnp);
                            $classNamespace=implode("/",$cnp);
                            $argsKey=$rgval["routeParams"];
                            foreach($matchs as $mkey=>$mval){
                                if($mkey==0){
                                    continue;
                                }
                                $argsVal[]=$mval;
                            }
                        }
                    }
                }
            }
        }else{
            if(isset($this->routeMap[$this->method][""])){
                $classNamespace=$this->routeMap[$this->method][""]["controller"];
                if(isset($this->routeMap[$this->method][""]["middleware"])){
                    $middleware=$this->routeMap[$this->method][""]["middleware"];
                }
                if(isset($this->routeMap[$this->method][""]["route"])){
                    $route=$this->routeMap[$this->method][""]["route"];
                }
                $cnp=explode("/",$classNamespace);
                $action=array_pop($cnp);
                $classNamespace=implode("/",$cnp);
            }
        }
        $is404=0;
        $response=null;
        if($classNamespace){
            if($argsKey){
                $keyCount=count($argsKey);
                $argsVal=array_pad($argsVal,$keyCount,null);
                $args=array_combine($argsKey,$argsVal);
            }
            $args=array_merge($args,$route);
            $index=stripos($classNamespace,'app\controller');
            $pluginsIndex=stripos($classNamespace,'plugins');
            if($index === false || $index !=0){
                if($pluginsIndex===false){
                    $classNamespace='app\controller\\'.$classNamespace;
                }else{
                    if($pluginsIndex !=0 ){
                        $classNamespace='app\controller\\'.$classNamespace;
                    }
                }
            }
            $classNamespace=str_replace("/","\\",$classNamespace);
            //在检测是否有存在的类
            if(class_exists($classNamespace)){
                $controllerObj=$this->make($classNamespace);
                if(method_exists($controllerObj,$action)){
                    request()->setController($classNamespace)->setAction($action)->setRoute($args);
                    $next = function($request) use($classNamespace,$action,$args){
                        return  $this->makeMethod($classNamespace, $action,$args);
                    };
                    $response=middleware()->dispatch($next,$middleware);
                }else{
                    $is404=1;
                }
            }else{
                $is404=1;
            }
        }else{
            $errorArg=array(
                "message"=>$classNamespace.":".$action,
            );
            $classNamespace='app\controller\Miss';
            if(class_exists($classNamespace)){
                $controllerObj=$this->make($classNamespace);
                $action="index";
                if(method_exists($controllerObj,$action)){
                    request()->setController($classNamespace)->setAction($action);
                    return  $this->makeMethod($classNamespace, $action,$errorArg);
                }else{
                    $is404=1;
                }
            }else{
                $is404=1;
            }
        }
        if($is404=="1"){
            $errorArg=array(
                "message"=>$classNamespace.":".$action,
            );
            $classNamespace='app\controller\Error404';
            if(class_exists($classNamespace)){
                $controllerObj=$this->make($classNamespace);
                $action="index";
                if(method_exists($controllerObj,$action)){
                    request()->setController($classNamespace)->setAction($action);
                    return  $this->makeMethod($classNamespace, $action,$errorArg);
                }else{
                    throw new \RuntimeException('error:系统错误 ');
                }
            }else{
                throw new \RuntimeException('error:系统错误 ');
            }
        }
        return $response;
    }

    /**
     * 反射创建类实例
     * @param $className
     * @return mixed
     */
    public function make($className)
    {
        $reflectionClass = new \ReflectionClass($className);
        $constructor = $reflectionClass->getConstructor();
        $dependencies=array();
        if($constructor){
            $parameters  = $constructor->getParameters();
            if($parameters){
                $dependencies = $this->getDependencies($parameters);
            }
        }
        return $reflectionClass->newInstanceArgs($dependencies);
    }

    /**
     * 反射创建方法
     * @param $className
     * @return mixed
     */
    public function makeMethod($classNamespace,$action,$args=array())
    {
        $controllerObj=$this->make($classNamespace);
        $reflectionMethod = new \ReflectionMethod($classNamespace, $action);

        $dependencies=array();
        $parameters  = $reflectionMethod->getParameters();
        if($parameters){
            $dependencies = $this->getDependencies($parameters);
        }
        if($dependencies){
            foreach($dependencies as $dkey=>$dval){
                if(isset($args[$dkey])){
                    $dependencies[$dkey]=$args[$dkey];
                }
            }
        }
        return $reflectionMethod->invokeArgs($controllerObj, $dependencies);
    }

    /**
     * 依赖解析
     * @param $parameters
     * @return array
     */
    public function getDependencies($parameters)
    {
        $dependencies = [];
        foreach($parameters as $parameter) {
            $type = $parameter->getType();
            if(is_null($type)){
                if($parameter->isDefaultValueAvailable()) {
                    $dependencies[$parameter->name] = $parameter->getDefaultValue();
                } else {
                    $dependencies[$parameter->name] = null;
                }
            }else{
                $className = $type->getName();
                $dependencies[$parameter->name] = $this->make($className);
            }
        }
        return $dependencies;
    }

    /**
     * get 请求
     */
    public function get($routePath,$controller){
        $routePath=$this->groupPrefix?($routePath?$this->groupPrefix."/".$routePath:$this->groupPrefix):$routePath;
        if(strpos($routePath,"<") ===false){
            //非正则匹配
            $this->routeMap["get"][$routePath]=array(
                "controller"=>$controller,
            );
            if($this->groupMiddleware){
                if(isset($this->routeMap["get"][$routePath]["middleware"]) && $this->routeMap["get"][$routePath]["middleware"]){
                    $this->routeMap["get"][$routePath]["middleware"]=array_merge($this->routeMap["get"][$routePath]["middleware"],$this->groupMiddleware);
                }else{
                    $this->routeMap["get"][$routePath]["middleware"]=$this->groupMiddleware;
                }
            }
            if($this->route){
                $this->routeMap["get"][$routePath]["route"]=$this->route;
                $this->route=array();
            }
        }else{
            //正则匹配路由
            $routePathIndex=md5($routePath);
            $ok=preg_match_all("/(<[^>]+>)/",$routePath,$matchs);
            if($ok >0){
                $routeParams=array();
                $strZwf="@str@";
                $strOptionalZwf="@strOptional@";
                $intZwf="@int@";
                $intOptionalZwf="@intOptional@";

                $zwSearch=array(
                    $strZwf,$strOptionalZwf,$intZwf,$intOptionalZwf
                );
                $zwReplace=array(
                    "(.+)","(.*?)","(\d+)","(\d+)?"
                );
                $search=array();
                $replace=array();
                foreach($matchs as $mkey=>$mval){
                    if($mkey=="0"){
                        $search=$mval;
                    }else{
                        foreach($mval as $zval){
                            $zSearch=array(
                                "<","?",">",
                            );
                            $zReplace=array(
                                ""
                            );
                            $value=str_replace($zSearch,$zReplace,$zval);
                            if(strpos($zval,"?")===false){
                                list($field,$type)=array_pad(explode("|",$value),2,"str");
                                $routeParams[]=$field;
                                if($type=="int"){
                                    $replace[]=$intOptionalZwf;
                                }else{
                                    $replace[]=$strOptionalZwf;
                                }
                            }else{
                                list($field,$type)=array_pad(explode("|",$value),2,"str");
                                $routeParams[]=$field;
                                if($type=="int"){
                                    $replace[]=$intOptionalZwf;
                                }else{
                                    $replace[]=$strOptionalZwf;
                                }
                            }
                        }
                    }
                }
                $regExp=str_replace($search,$replace,$routePath);
                $regExp=preg_quote($regExp,"/");
                $regExp=str_replace($zwSearch,$zwReplace,$regExp);

                $this->routeRegMap["get"][$routePathIndex]=array(
                    "controller"=>$controller,
                    "reg"=>$regExp,
                    "routeParams"=>$routeParams,
                );
                if($this->route){
                    $this->routeRegMap["get"][$routePathIndex]["route"]=$this->route;
                    $this->route=array();
                }
            }
            if($this->groupMiddleware){
                if(isset($this->routeRegMap["get"][$routePathIndex]["middleware"]) && $this->routeRegMap["get"][$routePathIndex]["middleware"]){
                    $this->routeRegMap["get"][$routePathIndex]["middleware"]=array_merge($this->routeRegMap["get"][$routePathIndex]["middleware"],$this->groupMiddleware);
                }else{
                    $this->routeRegMap["get"][$routePathIndex]["middleware"]=$this->groupMiddleware;
                }
            }
        }

        $this->cutMethod="get";
        $this->cutRoutePath=$routePath;
        return $this;
    }

    /**
     * post 请求
     */
    public function post($routePath,$controller){
        $routePath=$this->groupPrefix?($routePath?$this->groupPrefix."/".$routePath:$this->groupPrefix):$routePath;
        $this->routeMap["post"][$routePath]=array(
            "controller"=>$controller,
        );
        if($this->groupMiddleware){
            if(isset($this->routeMap["post"][$routePath]["middleware"]) && $this->routeMap["post"][$routePath]["middleware"]){
                $this->routeMap["post"][$routePath]["middleware"]=array_merge($this->routeMap["post"][$routePath]["middleware"],$this->groupMiddleware);
            }else{
                $this->routeMap["post"][$routePath]["middleware"]=$this->groupMiddleware;
            }
        }
        if($this->route){
            $this->routeMap["post"][$routePath]["route"]=$this->route;
            $this->route=array();
        }
        $this->cutMethod="post";
        $this->cutRoutePath=$routePath;
        return $this;
    }

    /**
     * put 请求
     */
    public function put($routePath,$controller){
        $routePath=$this->groupPrefix?($routePath?$this->groupPrefix."/".$routePath:$this->groupPrefix):$routePath;
        $this->routeMap["put"][$routePath]=array(
            "controller"=>$controller,
        );
        if($this->groupMiddleware){
            if(isset($this->routeMap["put"][$routePath]["middleware"]) && $this->routeMap["put"][$routePath]["middleware"]){
                $this->routeMap["put"][$routePath]["middleware"]=array_merge($this->routeMap["put"][$routePath]["middleware"],$this->groupMiddleware);
            }else{
                $this->routeMap["put"][$routePath]["middleware"]=$this->groupMiddleware;
            }
        }
        if($this->route){
            $this->routeMap["put"][$routePath]["route"]=$this->route;
            $this->route=array();
        }
        $this->cutMethod="put";
        $this->cutRoutePath=$routePath;
        return $this;
    }

    /**
     * delete 请求
     */
    public function delete($routePath,$controller){
        $routePath=$this->groupPrefix?($routePath?$this->groupPrefix."/".$routePath:$this->groupPrefix):$routePath;
        $this->routeMap["delete"][$routePath]=array(
            "controller"=>$controller,
        );
        if($this->groupMiddleware){
            if(isset($this->routeMap["delete"][$routePath]["middleware"]) && $this->routeMap["delete"][$routePath]["middleware"]){
                $this->routeMap["delete"][$routePath]["middleware"]=array_merge($this->routeMap["delete"][$routePath]["middleware"],$this->groupMiddleware);
            }else{
                $this->routeMap["delete"][$routePath]["middleware"]=$this->groupMiddleware;
            }
        }
        if($this->route){
            $this->routeMap["delete"][$routePath]["route"]=$this->route;
            $this->route=array();
        }
        $this->cutMethod="delete";
        $this->cutRoutePath=$routePath;
        return $this;
    }

    /**
     * patch 请求
     */
    public function patch($routePath,$controller){
        $routePath=$this->groupPrefix?($routePath?$this->groupPrefix."/".$routePath:$this->groupPrefix):$routePath;
        $this->routeMap["patch"][$routePath]=array(
            "controller"=>$controller,
        );
        if($this->groupMiddleware){
            if(isset($this->routeMap["patch"][$routePath]["middleware"]) && $this->routeMap["patch"][$routePath]["middleware"]){
                $this->routeMap["patch"][$routePath]["middleware"]=array_merge($this->routeMap["patch"][$routePath]["middleware"],$this->groupMiddleware);
            }else{
                $this->routeMap["patch"][$routePath]["middleware"]=$this->groupMiddleware;
            }
        }
        if($this->route){
            $this->routeMap["patch"][$routePath]["route"]=$this->route;
            $this->route=array();
        }
        $this->cutMethod="patch";
        $this->cutRoutePath=$routePath;
        return $this;
    }

    /**
     * head 请求
     */
    public function head($routePath,$controller){
        $routePath=$this->groupPrefix?($routePath?$this->groupPrefix."/".$routePath:$this->groupPrefix):$routePath;
        $this->routeMap["head"][$routePath]=array(
            "controller"=>$controller,
        );
        if($this->groupMiddleware){
            if(isset($this->routeMap["head"][$routePath]["middleware"]) && $this->routeMap["head"][$routePath]["middleware"]){
                $this->routeMap["head"][$routePath]["middleware"]=array_merge($this->routeMap["head"][$routePath]["middleware"],$this->groupMiddleware);
            }else{
                $this->routeMap["head"][$routePath]["middleware"]=$this->groupMiddleware;
            }
        }
        if($this->route){
            $this->routeMap["head"][$routePath]["route"]=$this->route;
            $this->route=array();
        }
        $this->cutMethod="head";
        $this->cutRoutePath=$routePath;
        return $this;
    }

    /**
     * options 请求
     */
    public function options($routePath,$controller){
        $routePath=$this->groupPrefix?($routePath?$this->groupPrefix."/".$routePath:$this->groupPrefix):$routePath;
        $this->routeMap["options"][$routePath]=array(
            "controller"=>$controller,
        );
        if($this->groupMiddleware){
            if(isset($this->routeMap["options"][$routePath]["middleware"]) && $this->routeMap["options"][$routePath]["middleware"]){
                $this->routeMap["options"][$routePath]["middleware"]=array_merge($this->routeMap["options"][$routePath]["middleware"],$this->groupMiddleware);
            }else{
                $this->routeMap["options"][$routePath]["middleware"]=$this->groupMiddleware;
            }
        }
        if($this->route){
            $this->routeMap["options"][$routePath]["route"]=$this->route;
            $this->route=array();
        }
        $this->cutMethod="options";
        $this->cutRoutePath=$routePath;
        return $this;
    }

    /**
     * 获取路由映射
     * @return mixed
     */
    public function getRouteMap(){
        return $this->routeMap;
    }

    /**
     * 设置中间件
     */
    public function middleware($middleware){
        $middleware=is_array($middleware)?$middleware:array($middleware);
        if(strpos($this->cutRoutePath,"<")===false){
            if(isset($this->routeMap[$this->cutMethod][$this->cutRoutePath]["middleware"])){
                $this->routeMap[$this->cutMethod][$this->cutRoutePath]["middleware"]=array_merge($this->routeMap[$this->cutMethod][$this->cutRoutePath]["middleware"],$middleware);
            }else{
                $this->routeMap[$this->cutMethod][$this->cutRoutePath]["middleware"]=$middleware;
            }
        }else{
            $routePathIndex=md5($this->cutRoutePath);
            if(isset($this->routeRegMap[$this->cutMethod][$routePathIndex]["middleware"])){
                $this->routeRegMap[$this->cutMethod][$routePathIndex]["middleware"]=array_merge($this->routeRegMap[$this->cutMethod][$routePathIndex]["middleware"],$middleware);
            }else{
                $this->routeRegMap[$this->cutMethod][$routePathIndex]["middleware"]=$middleware;
            }
        }
    }

    /**
     * 设置group中间件
     */
    public function group($prefix,$func="",$middleware=null){
        if($prefix instanceof \Closure){
            if($func){
                $this->groupMiddleware=is_array($func)?$func:array($func);
            }
            $prefix();
            $this->groupMiddleware="";
            $this->groupPrefix="";
        }else{
            if($func){
                $this->groupPrefix=$prefix;
                if($middleware){
                    $this->groupMiddleware=is_array($middleware)?$middleware:array($middleware);
                }
                $func();
                $this->groupMiddleware="";
                $this->groupPrefix="";
            }
        }
    }
}

