<?php

namespace ltcms\observer;

/**
 * 目标类
 * Class Subject
 */
abstract class Subject_contract
{
    private $observers=array();

    /**
     * 添加观察者
     */
    public  function attachObserver(Observer_contract $obs){
        $key=array_search($obs,$this->observers);
        if($key===false){
            $this->observers[]=$obs;
        }
    }

    /**
     * 删除观察者
     */
    public  function detachObserver(Observer_contract $obs){
        $key=array_search($obs,$this->observers);
        if($key!==false){
            unset($this->observers[$key]);
        }
    }

    /**
     * 通知观察者
     */
    public  function notifyObserver(){
        foreach($this->observers as $obs){
            $obs->update($this);
        }
    }
}
