<?php

namespace ltcms\lib;

/**
 * 语言类
 */
class Lang
{
    private static $_instance;
    protected $lang=array();

    private function __construct(){}
    private function __clone(){ }

    /**
     * 初始化配置
     */
    public function loader(){
        //遍历配置目录
        $default=config("app.language")?:"zh-cn";
        $langDirs=array(
            LTCMS_PATH."/lang",
            LTCMS_APP."/lang",
            LTCMS_CUSTOM."/lang",
        );
        foreach($langDirs as $dir){
            if(is_dir($dir)){
                $funcs=glob($dir."/*.php");
                if($funcs && is_array($funcs)){
                    foreach($funcs as $file){
                        $fileName=strtolower(basename($file,".php"));
                        if($fileName==$default){
                            $tmp=@include $file;
                            if(is_array($tmp)){
                                if($this->lang){
                                    $this->lang=arrFusion($this->lang,$tmp);
                                }else{
                                    $this->lang=$tmp;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 插件加载语言包
     */
    public function pluginLoader($dir){
        //遍历配置目录
        $default=config("app.language")?:"zh-cn";
        if($dir && is_dir($dir)){
            $funcs=glob($dir."/*.php");
            if($funcs && is_array($funcs)){
                foreach($funcs as $file){
                    $fileName=strtolower(basename($file,".php"));
                    if($fileName==$default){
                        $tmp=@include $file;
                        if(is_array($tmp)){
                            if($this->lang){
                                $this->lang=arrFusion($this->lang,$tmp);
                            }else{
                                $this->lang=$tmp;
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 设置
     * @param $name
     * @param $value
     */
    public function __set($name, $value)
    {

    }

    /**
     * 获取数据
     * @param $name
     * @param null $params
     * @return mixed
     */
    public function get($name,$params=null){
        $data=getData($this->lang,$name);
        if($params && is_array($params)){
            $find=array();
            $replace=array();
            foreach($params as $key=>$val){
                $find[]="{:".$key."}";
                $replace[]=$val;
            }
            $data= str_replace($find,$replace,$data);
        }
        return $data;
    }
}