<?php

namespace ltcms\lib;

/**
 * 错误处理类
 */
class ErrorClass
{
    private static $_instance;
    protected $types=array(
        E_ERROR=>"error",
        E_USER_ERROR=>"error",
        E_WARNING=>"warning",
        E_USER_WARNING=>"warning",
        E_NOTICE=>"notice",
        E_USER_NOTICE=>"notice",
    );
    protected $registered=false;

    private function __construct(){}
    private function __clone(){ }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 错误处理类
     * @param $name
     */
    function errorhandler($errno,$errstr,$errfile,$errline)
    {
        $error=array();
        $error["time"]=date("Y-m-d H:i:s");
        $error["code"]=$errno;
        $error["type"]=isset($this->types[$errno])?$this->types[$errno]:"unknown";
        $error["message"]=$errstr;
        $error["file"]=$errfile;
        $error["line"]=$errline;

        $errorFile=LTCMS_ROOT."/runtime/log/".date("Y-m-d").".log.error";
        makeDir(dirname($errorFile));
        @file_put_contents($errorFile,toJsonEncode($error).PHP_EOL,FILE_APPEND);

        $logLevel=config("log.level",array());
        if($logLevel && in_array($error["type"],$logLevel)){
            $isAjax=request()->isAjax();
            if($isAjax){
                $result=apiResult(false,$error["message"],$error["code"]);
                $response=jsonResponse($result);
                $response->send();
                exit;
            }else{
                request()->errorNotice=1;
                $response=view("error/index",$error,500);
                $response->send();
                exit;
            }
        }
    }

    /**
     * 错误处理类
     * @param $name
     */
    function exceptionHandler(\Throwable $exception)
    {
        $error=array();
        $error["time"]=date("Y-m-d H:i:s");
        $error["code"]=$exception->getCode();
        $error["type"]=isset($this->types[$error["code"]])?$this->types[$error["code"]]:"unknown";
        $error["message"]=$exception->getMessage();
        $error["file"]=$exception->getFile();
        $error["line"]=$exception->getLine();

        $errorFile=LTCMS_ROOT."/runtime/log/".date("Y-m-d").".log.exception";
        makeDir(dirname($errorFile));
        @file_put_contents($errorFile,toJsonEncode($error).PHP_EOL,FILE_APPEND);

        $logLevel=config("log.level",array());
        if($logLevel && in_array($error["type"],$logLevel)){
            $isAjax=request()->isAjax();
            if($isAjax){
                $result=apiResult(false,$error["message"],$error["code"]);
                $response=jsonResponse($result);
                $response->send();
                exit;
            }else{
                request()->errorNotice=1;
                $response=view("error/index",$error,500);
                $response->send();
                exit;
            }
        }
    }

    function register(){
        if(!$this->registered){
            $this->registered=true;
            set_error_handler(array(&$this,"errorhandler"));
            set_exception_handler(array(&$this,"exceptionHandler"));
        }
    }
}