<?php

//自定义常量
define('IN_LTCMS', true);
define('IN_ADMIN', defined('LTCMS_ADMIN') ? true : false);
define('LTCMS_CHARSET', config('app.charset'));
define('LTCMS_URL', config('app.url'));
define('LTCMS_KEY', config('app.authkey'));

define('LTCMS_WIN', strpos(strtoupper(PHP_OS), 'WIN') !== false ? true: false);
define('LTCMS_BOT', is_robot());
define('LTCMS_TOUCH', is_touch());

define('LTCMS_CACHE', config('cache.dir')? config('cache.dir'): LTCMS_ROOT.'/runtime/cache');
define('LTCMS_CACHE_DRIVER', config("cache.driver")? config("cache.driver"): 'file');
define('LTCMS_FILE_CHMOD', (config('cache.file_mod') && !LTCMS_WIN)? config('cache.file_mod'): 0);

define('LTCMS_DATABASE_DRIVER', config("database.driver")? config("database.driver"): 'mysqli');
define('LTCMS_DATABASE_CONNECT', config("database.connect")? config("database.connect"): 'default');

define('LTCMS_TIME', time() + config('app.timediff'));

define('LTCMS_SESSION_DOMAIN', config('session.domain'));
define('LTCMS_SESSION_NAME', config('session.name'));
define('LTCMS_SESSION_LIFETIME', config('session.lifetime'));
define('LTCMS_SESSION_AUTO_START', config('session.auto_start'));
define('LTCMS_SESSION_COOKIE_SECURE', config('session.cookie_secure'));
define('LTCMS_SESSION_COOKIE_HTTPONLY', config('session.cookie_httponly'));
define('LTCMS_SESSION_DRIVER', config('session.driver')? config('session.driver'): 'file');
define('LTCMS_SESSION_DIR', config('session.savePath')? config('session.savePath'): LTCMS_ROOT.'/runtime/session');

define('LTCMS_TEMPLATE', LTCMS_ROOT."/app/view");
define('LTCMS_CORE_TEMPLATE', LTCMS_ROOT."/ltcms/view");
define('LTCMS_PUBLIC', LTCMS_ROOT."/public");


