<?php

namespace ltcms\lib;

/**
 * 配置类
 */
class Config
{
    private static $_instance;
    protected $config=array();

    private function __construct(){}
    private function __clone(){ }

    /**
     * 初始化配置
     */
    public function loader(){
        //遍历配置目录
        $configDirs=array(
            LTCMS_PATH."/config",
            LTCMS_APP."/config",
            LTCMS_CUSTOM."/config",
        );
        foreach($configDirs as $dir){
            if(is_dir($dir)){
                $funcs=glob($dir."/*.php");
                if($funcs && is_array($funcs)){
                    foreach($funcs as $file){
                        $fileName=strtolower(basename($file,".php"));
                        $tmp=@include $file;
                        if(is_array($tmp)){
                            if(isset($this->config[$fileName])){
                                $this->config[$fileName]=arrFusion($this->config[$fileName],$tmp);
                            }else{
                                $this->config[$fileName]=$tmp;
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 插件加载配置
     */
    public function pluginLoader($dir){
        //遍历配置目录
        if(is_dir($dir)){
            $funcs=glob($dir."/*.php");
            if($funcs && is_array($funcs)){
                foreach($funcs as $file){
                    $fileName=strtolower(basename($file,".php"));
                    $tmp=@include $file;
                    if(is_array($tmp)){
                        if(isset($this->config[$fileName])){
                            $this->config[$fileName]=arrFusion($this->config[$fileName],$tmp);
                        }else{
                            $this->config[$fileName]=$tmp;
                        }
                    }
                }
            }
        }
    }

    /**
     * 插件加载文件
     */
    public function pluginLoaderFile($fileList=array()){
        //遍历配置目录
        if($fileList){
            foreach($fileList as $file){
                if(is_file($file)){
                    $fileName=strtolower(basename($file,".php"));
                    $tmp=@include $file;
                    if(is_array($tmp)){
                        if(isset($this->config[$fileName])){
                            $this->config[$fileName]=arrFusion($this->config[$fileName],$tmp);
                        }else{
                            $this->config[$fileName]=$tmp;
                        }
                    }
                }
            }
        }
    }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 设置配置
     * @param $name
     * @param $value
     */
    public function set($name, $value)
    {
        $this->config=setData($name,$value,$this->config);
    }

    /**
     * 获取配置
     * @param $name
     * @return mixed
     */
    public function get($name)
    {
        return getData($this->config,$name);
    }
}