<?php

/**
 * 获取文件内容
 * @param $filename
 * @return string
 */
function getFileContent($filename) {
    $rec = @file_get_contents($filename);
    if($rec) return $rec;
    if(substr($filename, 0, 8) == 'https://') return getFileContent('http://'.substr($filename, 8));
    return '';
}

/**
 * 获取文件扩展
 * @param $filename
 * @return string
 */
function getFileExt($filename) {
    if(strpos($filename, '.') === false) return '';
    $ext = strtolower(trim(substr(strrchr($filename, '.'), 1)));
    return preg_match("/^[a-z0-9]{1,10}$/", $ext) ? $ext : '';
}

/**
 * 存入内容
 */
if(!function_exists('file_put_contents')) {
    function file_put_contents($file, $str, $append = '') {
        $mode = $append == '' ? 'wb' : 'ab';
        $fp = @fopen($file, $mode);
        flock($fp, LOCK_EX);
        $strLen = @fwrite($fp, $str);
        flock($fp, LOCK_UN);
        @fclose($fp);
        return $strLen;
    }
}

/**
 * 获取文件列表
 * @param $dir
 * @param array $fs
 * @return array
 */
function getFileList($dir, $fs = array()) {
    $files = glob($dir.'/*');
    if(!is_array($files)) return $fs;
    foreach($files as $file) {
        if(is_dir($file)) {
            $fs = getFileList($file, $fs);
        } else {
            $fs[] = $file;
        }
    }
    return $fs;
}

/**
 * 文件拷贝
 * @param $from
 * @param $to
 * @return bool
 */
function fileCopy($from, $to) {
    makeDir(dirname($to));
    if(is_file($to) && LTCMS_FILE_CHMOD) @chmod($to, LTCMS_FILE_CHMOD);
    if(strpos($from, LTCMS_URL) !== false) $from = str_replace(LTCMS_URL, LTCMS_ROOT.'/', $from);
    if(@copy($from, $to)) {
        if(LTCMS_FILE_CHMOD) @chmod($to, LTCMS_FILE_CHMOD);
        return true;
    } else {
        if(substr($from, 0, 8) == 'https://') return fileCopy('http://'.substr($from, 8), $to);
        return false;
    }
}

/**
 * 规范路径
 * @param $dirpath
 * @return mixed|string
 */
function dirFormat($dirpath) {
    $dirpath = str_replace('\\', '/', $dirpath);
    if(substr($dirpath, -1) != '/') $dirpath = $dirpath.'/';
    return $dirpath;
}

/**
 * 创建目录
 * @param $path
 * @return bool
 */
function makeDir($path) {
    if(is_dir($path)) return true;
    @umask(000);
    if(LTCMS_CACHE != LTCMS_ROOT.'/runtime/cache' && strpos($path, LTCMS_CACHE) !== false) {
        $dir = str_replace(LTCMS_CACHE.'/', '', $path);
        $dir = dirFormat($dir);
        $temp = explode('/', $dir);
        $curDir = LTCMS_CACHE.'/';
        $max = count($temp) - 1;
        for($i = 0; $i < $max; $i++) {
            $curDir .= $temp[$i].'/';
            if(is_dir($curDir)) continue;
            mkdir($curDir,0775,true);
//            if(LTCMS_FILE_CHMOD) @chmod($curDir, LTCMS_FILE_CHMOD);
        }
    } else {
        $dir = str_replace(LTCMS_ROOT.'/', '', $path);
        $dir = dirFormat($dir);
        $temp = explode('/', $dir);
        $curDir = LTCMS_ROOT.'/';
        $max = count($temp) - 1;
        for($i = 0; $i < $max; $i++) {
            $curDir .= $temp[$i].'/';
            if(is_dir($curDir)) continue;

            mkdir($curDir,0775,true);
//            if(LTCMS_FILE_CHMOD) @chmod($curDir, LTCMS_FILE_CHMOD);
        }
    }
    return is_dir($path);
}

/**
 * 修改目录权限
 * @param $dir
 * @param string $mode
 * @param int $require
 */
function dirChmod($dir, $mode = '', $require = 0) {
    if(!$require) $require = substr($dir, -1) == '*' ? 2 : 0;
    if($require) {
        if($require == 2) $dir = substr($dir, 0, -1);
        $dir = dirFormat($dir);
        $list = glob($dir.'*');
        foreach($list as $v) {
            if(is_dir($v)) {
                dirChmod($v, $mode, 1);
            } else {
                @chmod(basename($v), $mode);
            }
        }
    }
    if(is_dir($dir)) {
        @chmod($dir, $mode);
    } else {
        @chmod(basename($dir), $mode);
    }
}

/**
 * 目录拷贝
 * @param $fromdir
 * @param $todir
 * @return bool
 */
function dirCopy($fromdir, $todir) {
    $fromdir = dirFormat($fromdir);
    $todir = dirFormat($todir);
    if(!is_dir($fromdir)) return false;
    if(!is_dir($todir)) makeDir($todir);
    $list = glob($fromdir.'*');
    foreach($list as $v) {
        $path = $todir.basename($v);
        if(is_file($path) && !is_writable($path)) {
            if(LTCMS_FILE_CHMOD) @chmod($path, LTCMS_FILE_CHMOD);
        }
        if(is_dir($v)) {
            dirCopy($v, $path);
        } else {
            @copy($v, $path);
            if(LTCMS_FILE_CHMOD) @chmod($path, LTCMS_FILE_CHMOD);
        }
    }
    return true;
}

/**
 * 目录删除
 * @param $dir
 * @return bool
 */
function dirDelete($dir) {
    $dir = dirFormat($dir);
    if(!is_dir($dir)) return false;
    $dirs = array(LTCMS_ROOT.'/ltcms/');
    if(substr($dir, 0, 1) == '.' || in_array($dir, $dirs)) die("Cannot Remove System DIR $dir ");
    $list = glob($dir.'*');
    if($list) {
        foreach($list as $v) {
            is_dir($v) ? dirDelete($v) : @unlink($v);
        }
    }
    return @rmdir($dir);
}

/**
 * 写入文件
 * @param $filename
 * @param $data
 * @return bool|int
 */
function fileWrite($filename, $data) {
    makeDir(dirname($filename));
    if(@$fp = fopen($filename, 'wb')) {
        flock($fp, LOCK_EX);
        $len = fwrite($fp, $data);
        flock($fp, LOCK_UN);
        fclose($fp);
//        if(LTCMS_FILE_CHMOD) @chmod($filename, LTCMS_FILE_CHMOD);
        return $len;
    } else {
        return false;
    }
}

/**
 * 文件删除
 * @param $filename
 * @return bool
 */
function fileDel($filename) {
//    if(LTCMS_FILE_CHMOD) @chmod($filename, LTCMS_FILE_CHMOD);
    return is_file($filename) ? @unlink($filename) : false;
}

