<?php

namespace ltcms\db;

class Db implements Db_contract
{
    protected $resource;
    protected $driver = LTCMS_DATABASE_DRIVER?LTCMS_DATABASE_DRIVER:"mysqli";
    private static $_instance;
    private $trans_nums=0;

    private function __construct(){
        $this->_init();
    }
    private function __clone(){ }

    /**
     * 获取类对象
     */
    public static  function getInstance(){
        if(!(self::$_instance instanceof self)){
            self::$_instance=new self();
        }
        return self::$_instance;
    }

    /**
     * 初始化对象
     */
    public function _init(){
        if(!isset($this->resource[$this->driver])){
            if($this->driver=="mysqli"){
                include_once __DIR__."/Db_mysqli.php";
                $mysqli=new Db_mysqli();
                $mysqli->setConfig();
                $this->resource[$this->driver]=$mysqli;
            }else{
                throw new \Exception("database:{$this->driver} 驱动不存在");
            }
        }
    }

    /**
     * 切换驱动
     */
    public function changeDriver($driver){
        $this->driver=$driver;
        return $this;
    }

    /**
     *  获取配置信息
     */
    public function getConfig(){
        return $this->resource[$this->driver]->getConfig();
    }

    /**
     *  提交事务
     */
    public function commitTrans(){
        $this->trans_nums-=1;
        if($this->trans_nums == "0"){
            $this->resource[$this->driver]->commitTrans();
        }
        return $this;
    }

    /**
     *  元数据
     */
    public function raw($data){
        return $this->resource[$this->driver]->raw($data);
    }

    /**
     *  回滚事务
     */
    public function rollbackTrans(){
        $this->trans_nums-=1;
        if($this->trans_nums == "0"){
            $this->resource[$this->driver]->rollbackTrans();
        }
        return $this;
    }

    /**
     *  开启事务
     */
    public function startTrans(){
        if($this->trans_nums=="0"){
            $this->resource[$this->driver]->startTrans();
        }
        $this->trans_nums+=1;
        return $this;
    }

    /**
     *  切换数据库
     */
    public function changeConnect($connect){
        $this->resource[$this->driver]->changeConnect($connect);
        return $this;
    }

    /**
     *  执行sql语句
     */
    public function execute($connect){
        return $this->resource[$this->driver]->execute($connect);
    }

    /**
     *  是否加排它锁
     */
    public function lock($table){
        $this->resource[$this->driver]->lock($table);
        return $this;
    }

    /**
     *  是否返回sql
     */
    public function fetchSql($table){
        $this->resource[$this->driver]->fetchSql($table);
        return $this;
    }

    /**
     *  获取数据
     */
    public function fetch($query){
        return $this->resource[$this->driver]->fetch($query);
    }

    /**
     *  设置表名
     */
    public function name($table){
        $this->resource[$this->driver]->name($table);
        return $this;
    }
    /**
     *  设置左连接
     * LEFT JOIN orders ON users.id = orders.user_id
     * @param  $table "orders"
     * @param $on "users.id = orders.user_id"
     */
    public function joinLeft($table,$on){
        $this->resource[$this->driver]->joinLeft($table,$on);
        return $this;
    }
    /**
     *  设置字段名称
     */
    public function field($table){
        $this->resource[$this->driver]->field($table);
        return $this;
    }

    /**
     *  条件
     */
    public function where($condition){
        $this->resource[$this->driver]->where($condition);
        return $this;
    }

    /**
     *  条数
     */
    public function limit($offset=null,$limit=null){
        $this->resource[$this->driver]->limit($offset,$limit);
        return $this;
    }

    /**
     *  设置sql
     */
    public function sql($sql){
        $this->resource[$this->driver]->sql($sql);
        return $this;
    }

    /**
     *  执行sql请求
     */
    public function query($sql){
        return $this->resource[$this->driver]->query($sql);
    }

    /**
     *  设置分页
     */
    public function page($page,$pageSize=10){
        $this->resource[$this->driver]->page($page,$pageSize);
        return $this;
    }

    /**
     *  绑定参数查询
     */
    public function stmtQuery($sql,$parsePrepareData,$type=Null){
        return $this->resource[$this->driver]->stmtQuery($sql,$parsePrepareData,$type);
    }

    /**
     *  排序
     */
    public function order($key,$val=null){
        $this->resource[$this->driver]->order($key,$val);
        return $this;
    }

    /**
     *  设置数据
     */
    public function data($data){
        $this->resource[$this->driver]->data($data);
        return $this;
    }

    /**
     *  是否开启预处理
     */
    public function prepare($prepare){
        $this->resource[$this->driver]->prepare($prepare);
        return $this;
    }

    /**
     *  绑定预处理数据
     */
    public function bindValue($prepareDataField,$prepareDataValue=null){
        $this->resource[$this->driver]->bindValue($prepareDataField,$prepareDataValue);
        return $this;
    }

    /**
     *  设置注解
     */
    public function comments($data){
        $this->resource[$this->driver]->comments($data);
        return $this;
    }

    /**
     *  查询数据表
     */
    public function select($sql=null,$type=Null,$ttl=Null){
        return $this->resource[$this->driver]->select($sql,$type,$ttl);
    }

    /**
     *  查询数据表-分页
     */
    public function paginate($listRows=null,$type=Null,$ttl=Null){
        return $this->resource[$this->driver]->paginate($listRows,$type,$ttl);
    }

    /**
     *  链接数据库
     */
    public function connect($config=array()){
        return $this->resource[$this->driver]->connect($config);
    }

    /**
     *  查找数据[单条]
     */
    public function find($sql=Null,$type=Null,$ttl=Null)
    {
        return $this->resource[$this->driver]->find($sql,$type,$ttl);
    }

    /**
     *  添加数据
     */
    public function insert($data = null)
    {
        return $this->resource[$this->driver]->insert($data);
    }

    /**
     *  添加数据[多条]
     */
    public function insertBatch($data = null)
    {
        return $this->resource[$this->driver]->insertBatch($data);
    }

    /**
     *  更新数据
     */
    public function update($data=null)
    {
        return $this->resource[$this->driver]->update($data);
    }

    /**
     *  删除数据
     */
    public function delete()
    {
        return $this->resource[$this->driver]->delete();
    }
}

