<?php

namespace app\utils\verify;

class Verify_param
{
    /**
     * 验证请求
     * @param array $parameter
     * @return array
     */
    public static  function validatorRequest($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr['error_no']==0){
            if(!$paramObj){
                $final_arr=recordLogMsgLevelThree(app("errorLevel")::E_WARNING,app("errorCode")::VERIFY_DATA_EMPTY,lang("verifyDataCannotBeEmpty"));
            }
        }
        if($final_arr['error_no']==0)
        {
            $noFilter=parseToArr($paramObj,"noFilter",array());
            $requestData=request()->param();
            if($noFilter){
                foreach($noFilter as $fval){
                    $requestData[$fval]=request()->param($fval,null,null);
                }
            }
            $mixed=parseToArr($paramObj,"mixed",0);
            $batch=parseToArr($paramObj,"batch",false);
            $params=parseToArr($paramObj,"params",array());
            $dataObj->data->rules=parseToArr($paramObj,"rules",array());
            $dataObj->data->messages=parseToArr($paramObj,"messages",array());
            $dataObj->data->dataDefault=parseToArr($paramObj,"dataDefault",array());
            if($mixed){
                $dataObj->data->data=array_merge($requestData,$params);
            }else{
                $dataObj->data->data=$params;
            }
            if($final_arr['error_no']==0)
            {
                if(!$dataObj->data->rules){
                    $final_arr=recordLogMsgLevelThree(app("errorLevel")::E_WARNING,app("errorCode")::VERIFY_RULES_EMPTY,lang("verifyRuleIsEmpty"));
                }
            }
            if($final_arr['error_no']==0)
            {
                if($dataObj->data->rules){
                    $rules=array_filter($dataObj->data->rules);
                    if($rules){
                        if (!validate()->init()->batch($batch)->message($dataObj->data->messages)->check($dataObj->data->data,$rules)) {
                            $final_arr=recordLogMsgLevelThree(app("errorLevel")::E_WARNING,app("errorCode")::VERIFY_DATA_FAIL,validate()->getError());
                        }
                    }
                }
            }
        }
        if($final_arr['error_no']==0)
        {
            $obj=paramsObj();
            if($dataObj->data->rules){
                foreach ($dataObj->data->rules as $key=>$val){
                    $parts = explode("|", $key);
                    $key2 = $parts[0];   //只要第一个 左边是键名
                    $obj->$key2=self::getVal($key2,$dataObj->data->data,$dataObj->data->dataDefault);
                }
            }
            $final_arr["result"]=$obj;
        }
        return $final_arr;
    }

    /**
     * 返回数据
     * @param $key
     * @param $data
     * @param $dataDefault
     * @return null
     */
    private static function getVal($key,$data,$dataDefault){
        if(isset($data[$key])){
            $val=$data[$key];
        }else{
            $val=null;
            if(isset($dataDefault[$key])){
                $val=$dataDefault[$key];
            }
        }
        if($val===null){
            return $val;
        }else{
            return $val;
        }
    }
}