<?php

namespace app\utils\encrypt;

class Hash_pbkdf2
{
    /**
     * 密码加密
     * @param $password
     * @return string
     */
    public static function encrypt($password){
        $iterations=1000;
        $length=32;
        $salt = openssl_random_pseudo_bytes(32);
        $salt_encode=base64_encode($salt);
        $hash = hash_pbkdf2("sha256", $password, $salt, $iterations, $length);
        return $hash.$salt_encode;
    }

    /**
     * 密码校验
     * @param $password
     * @param $hash
     * @return bool
     */
    public static function decrypt($password,$hash){
        $iterations=1000;
        $length=32;
        $passhash=substr($hash,0,$length);
        $salt=base64_decode(substr($hash,$length));
        $passhash2=hash_pbkdf2("sha256", $password, $salt, $iterations, $length);
        if($passhash==$passhash2){
            return true;
        }
        return false;
    }
}


