<?php

namespace app\utils\base\plugin\tags;

class Tag_plugin_agent implements Tag_plugin_contract
{
    /**
     *  调用标签
     */
    public function run($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'tagName' => 'require',
                'extraData' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr['error_no'] == 0) {
            if ($dataObj->request->tagName == "linkList") {
                $plugin_obj = new Tag_friend_link_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->run($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "setting") {// 定义标签名字判断
                $plugin_obj = new Tag_setting_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,    //{} 符号内的参数 这里是pid
                );
                $checkResult = $plugin_obj->run($paramObj);//运行插件调用方法获取数据
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "advList") {
                $plugin_obj = new Tag_adv_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->run($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "models") {
                $plugin_obj = new Tag_module_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->run($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "artRecommend") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->getRecommend($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "artList") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->getList($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "artRow") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->getRowData($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "singlePageList") {
                $plugin_obj = new Tag_singlePage_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->getList($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "singlePageRow") {
                $plugin_obj = new Tag_singlePage_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->getRowData($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "relevarticle") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->correlationRecommend($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "artRandData") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->randData($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "artPre") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->pre($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "artNext") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->next($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if ($dataObj->request->tagName == "artData") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->articleData($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if ($dataObj->request->tagName == "artTagData") {
                $plugin_obj = new Tag_article_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->tagArticleData($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "page") {
                $plugin_obj = new Tag_page_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->style($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else if ($dataObj->request->tagName == "categoryHtml") {
                $plugin_obj = new Tag_category_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->getHtml($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if ($dataObj->request->tagName == "categoryMultiHtml") {
                $plugin_obj = new Tag_category_plugin();
                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->getMultiHtml($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->tagName=="categoryShow"){
                $plugin_obj=new Tag_category_plugin();
                $paramObj = paramsObj();
                $paramObj->params=array(
                    "extraData"=>$dataObj->request->extraData,
                );
                $checkResult=$plugin_obj->show($paramObj);
                if ($checkResult["error_no"] == 0)
                {
                    $final_arr["result"]=$checkResult["result"];
                }
                else
                {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->tagName=="news"){
                $plugin_obj=new Tag_news_plugin();

                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->getList($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->tagName=="pluginInstall"){
                $plugin_obj=new Tag_plugin_install_plugin();

                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->install($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->tagName=="showDir"){
                $plugin_obj=new Tag_show_file_plugin();

                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->show($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }else if($dataObj->request->tagName=="systemUInstall"){
                $plugin_obj=new Tag_systemUpgrade_install_plugin();

                $paramObj = paramsObj();
                $paramObj->params = array(
                    "extraData" => $dataObj->request->extraData,
                );
                $checkResult = $plugin_obj->install($paramObj);
                if ($checkResult["error_no"] == 0) {
                    $final_arr["result"] = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            } else {
                //  类名_类名类名xxx_方法     //_符号最后一个是方法
                $className = $dataObj->request->tagName;
                $action = "run";
                $lastUnderscorePos = strrpos($className, "_");

                if ($lastUnderscorePos !== false) {
                    $className = substr($dataObj->request->tagName, 0, $lastUnderscorePos);
                    if (substr($dataObj->request->tagName, $lastUnderscorePos + 1)) {
                        $action = substr($dataObj->request->tagName, $lastUnderscorePos + 1);
                    }
                }
                $pluginClassName = 'Tag_' . $className . '_plugin'; //;临时处理,后续在改
                if (class_exists($pluginClassName)) {
                    $plugin_obj = new $pluginClassName();
                    $paramObj = paramsObj();
                    $paramObj->params = array(
                        "extraData" => $dataObj->request->extraData,
                    );
                    $checkResult = $plugin_obj->$action($paramObj);//运行插件调用方法获取数据
                    if ($checkResult["error_no"] == 0) {
                        $final_arr["result"] = $checkResult["result"];
                    } else {
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::NOT_IMPLEMENTED, lang("sys.noMethodDefined"));
                }
            }
        }
        return $final_arr;
    }

    /**
     *  过滤标签参数
     */
    public function filterParams($params,$extra=array())
    {
        $sysParam = array();
        $conditionMap = array();
        if ($params) {
            $extraData = trim($params);
            $extraData = array_filter(explode(" ", $extraData));
            if ($extraData) {
                foreach ($extraData as $zval) {
                    if ($zval) {
                        list($filed, $val) = explode("=", $zval);
                        $val = trim($val, " '\"");
                        $filed = trim($filed);

                        if (in_array($filed, array("key", "val"))) {
                            $sysParam[$filed] = $val;
                        } else {
                            $conditionMap[$filed] = $val;
                        }
                    }
                }
            }
        }
        $return = array();
        $return["conditionMap"] = array_merge($conditionMap,$extra);
        $return["sysParam"] = $sysParam;
        return $return;
    }

    /**
     *  解析condition条件
     */
    public function parseCondition($condition)
    {
        $result = array();
        $condition = is_array($condition) ? $condition : toJsonDecode($condition);
        if ($condition) {
            foreach ($condition as $key => $val) {
                if ($key == "limit") {
                    if (strpos($val, ",") === false) {
                        $result["offset"] = $val;
                    } else {
                        list($offset, $limit) = explode(",", $val);
                        $result["offset"] = $offset;
                        $result["limit"] = $limit;
                    }
                } else {
                    $result[$key] = $val;
                }
            }
        }
        return $result;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}

?>