<?php

namespace app\utils\base\plugin\tags;

class Tag_page_plugin
{
    /**
     * 样式
     */
    public function style($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $condition=app("P_tag_plugin")->parseCondition($dataObj->request->extraData);
            $style=isset($condition["style"])?$condition["style"]:"simple";
            if($style=="simple"){
                $paramsObj=paramsObj();
                $paramsObj->params=$condition;
                $checkResult=$this->simple($paramsObj);
                if($checkResult["error_no"]==0){
                    $final_arr["result"]=$checkResult["result"];
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }else if($style=="article"){
                $paramsObj=paramsObj();
                $paramsObj->params=$condition;
                $checkResult=$this->article($paramsObj);
                if($checkResult["error_no"]==0){
                    $final_arr["result"]=$checkResult["result"];
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }else{
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"));
            }
        }
        return $final_arr;
    }

    /**
     * 文章分页样式
     */
    public function article($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'data' => 'require',
                'moduleId' => 'require',
                'categoryId' => '',
                'listitem' => '',
                'listsize' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $listitem=$dataObj->request->listitem?explode(",",$dataObj->request->listitem):array();
            $listsize=$dataObj->request->listsize?$dataObj->request->listsize:10;
            $data=is_array($dataObj->request->data)?$dataObj->request->data:toJsonDecode($dataObj->request->data);

            $replace=array();
            if($dataObj->request->categoryId){
                $catData=category("module",$dataObj->request->moduleId);
                if(isset($catData[$dataObj->request->categoryId])){
                    $catRow=$catData[$dataObj->request->categoryId];
                    $replace["catdir"]=$catRow["catDir"];
                    $replace["catid"]=$catRow["id"];
                    $replace["catname"]=$catRow["name"];
                }
            }
            $moduleListUrlRule=getModuleListUrlRule($dataObj->request->moduleId);
            $listUrlRule=getListUrlRule();
            $listRulePage=$moduleListUrlRule["rulePage"]; //列表分页路由
            if(!isset($listRulePage)){
                if(isset($listUrlRule["rulePage"])){
                    $listRulePage=$listUrlRule["rulePage"];
                }
            }
            $moduleData=module($dataObj->request->moduleId);
            $moduleLinkUrl=moduleLinkUrl($moduleData);
            $baseUrl=$moduleLinkUrl.$listRulePage;
            $params = request()->get();
            if($params){
                if(strpos($baseUrl,"?")===false){
                    $urlQuery=array();
                    foreach($params as $pkey=>$pval){
                        $urlQuery[]=$pkey."=".$pval;
                    }
                    $urlQueryStr=implode("&",$urlQuery);
                    $baseUrl .= '?'.$urlQueryStr;
                }else{
                    $parts=parse_url($baseUrl);
                    $query=array();
                    if($parts["query"]){
                        parse_str($parts["query"],$query);
                    }
                    $urlQuery=array();
                    foreach($params as $pkey=>$pval){
                        if($query){
                            if(isset($query[$pkey])){
                                continue;
                            }
                        }
                        $urlQuery[]=$pkey."=".$pval;
                    }
                    if($urlQuery){
                        $urlQueryStr=implode("&",$urlQuery);
                        $baseUrl .= '&'.$urlQueryStr;
                    }
                }
            }

            $replace["page"]=1;
            $href =  urlRuleReplace($replace,$baseUrl);
            $pageData=$this->calculatePageNo($data,$listsize);

            if($pageData){
                $tem='<div class="ltcms-pages">';
                if($listitem){
                    if(in_array("index",$listitem)){
                        $tem.=' <a href="'.$href.'"><span>'.lang("page.home").'</span></a>';
                    }
                }else{
                    $tem.=' <a href="'.$href.'"><span>'.lang("page.home").'</span></a>';
                }
                $replace["page"]=$data["page"]-1;
                $href =  urlRuleReplace($replace,$baseUrl);
                if($data["page"]>1){
                    if($listitem){
                        if(in_array("pre",$listitem)){
                            $tem.='<a href="'.$href.'"><span class="prev">'.lang("page.pre").'</span></a>';
                        }
                    }else{
                        $tem.='<a href="'.$href.'"><span class="prev">'.lang("page.pre").'</span></a>';
                    }
                }
                $tem.='<ul>';

                $replace["page"]=1;
                $href =  urlRuleReplace($replace,$baseUrl);
                if($pageData["first"]==$data["page"]){
                    $tem.='<li><a class="active" href="'.$href.'"><span>'.$pageData["first"].'</span></a></li>';
                }else{
                    $tem.='<li><a href="'.$href.'"><span>'.$pageData["first"].'</span></a></li>';
                }

                foreach($pageData["slider"] as $val){
                    if($val=="..."){
                        if($listitem){
                            if(in_array("dots",$listitem)){
                                $tem.='<li><a href="javascript:void(0)"><span>'.$val.'</span></a></li>';
                            }
                        }else{
                            $tem.='<li><a href="javascript:void(0)"><span>'.$val.'</span></a></li>';
                        }
                    }else{
                        $replace["page"]=$val;
                        $href =  urlRuleReplace($replace,$baseUrl);
                        if($val==$data["page"]){
                            $tem.='<li><a class="active" href="'.$href.'"><span>'.$val.'</span></a></li>';
                        }else{
                            $tem.='<li><a href="'.$href.'"><span>'.$val.'</span></a></li>';
                        }
                    }
                }

                $replace["page"]=$pageData["end"];
                $href =  urlRuleReplace($replace,$baseUrl);
                if($pageData["end"]==$data["page"]){
                    $tem.='<li><a class="active" href="'.$href.'"><span>'.$pageData["end"].'</span></a></li>';
                }else{
                    $tem.='<li><a href="'.$href.'"><span>'.$pageData["end"].'</span></a></li>';
                }

                $tem.='</ul>';

                $replace["page"]=$data["page"]+1;
                $href =  urlRuleReplace($replace,$baseUrl);
                if($data["page"] < $pageData["end"]){
                    if($listitem){
                        if(in_array("next",$listitem)){
                            $tem.='<a href="'.$href.'"><span class="next">'.lang("page.next").'</span></a>';
                        }
                    }else{
                        $tem.='<a href="'.$href.'"><span class="next">'.lang("page.next").'</span></a>';
                    }
                }
                $replace["page"]=$pageData["end"];
                $href =  urlRuleReplace($replace,$baseUrl);
                if($listitem){
                    if(in_array("end",$listitem)){
                        $tem.='<a href="'.$href.'"><span>'.lang("page.end").'</span></a>';
                    }
                }else{
                    $tem.='<a href="'.$href.'"><span>'.lang("page.end").'</span></a>';
                }

                if($listitem){
                    if(in_array("info",$listitem)){
                        $tem.='<p class="allPage">'.lang("page.trips",["totalPage"=>$pageData["end"],"total"=>$data["total"]]).'</p>';
                    }
                }else{
                    $tem.='<p class="allPage">'.lang("page.trips",["totalPage"=>$pageData["end"],"total"=>$data["total"]]).'</p>';
                }

                $tem.='</div>';
            }else{
                $tem='<div class="ltcms-pages"></div>';
            }

            $return=array();
            $return["type"]="echo";
            $return["data"]=$tem;
            $final_arr["result"]= $return;
        }
        return $final_arr;
    }

    /**
     * 计算页码
     * @return array
     */
    public function calculatePageNo($data,$size){
        $total=$data["total"];
        $totalPage=$data["totalPage"];
        $page=$data["page"];

        $return=array();
        $return["first"]=1;
        $return["end"]=$totalPage;
        $return["slider"]=array();
        if($total > 0){
            $return["slider"][]=$page;
            for($i=1;$i <=$size;$i++){
                $pre=$page-$i;
                $next=$page+$i;
                if($pre >1){
                    $return["slider"][]=$pre;
                }
                if($next < $totalPage){
                    $return["slider"][]=$next;
                }
            }
            $slider = array_diff($return["slider"], [1,$totalPage]);
            sort($slider);
            $first=$slider[0];
            if($first > 2){
                array_unshift($slider,"...");
            }
            $end=end($slider);
            if($end < ($totalPage - 1)){
                array_push($slider,"...");
            }
            $return["slider"]=$slider;
        }
        return $return;
    }

    /**
     * 计算页码
     * @return array
     */
    public function calculatePageNoBak($data,$size){
        $total=$data["total"];
        $totalPage=$data["totalPage"];
        $page=$data["page"];

        $return=array();
        if($total > 0){
            $index=$page;
            if($index>$totalPage)
            {
                $index=$totalPage;
            }
            $firstPage=$index-floor($size/2);
            if($firstPage<=0)
            {
                $firstPage=1;
            }
            $lastPage=$firstPage + $size-1;
            if($lastPage > $totalPage)
            {
                $lastPage=$totalPage;
                $firstPage=($totalPage-$size) >0?$totalPage-$size+1:1;
            }
            $return["totalPage"]=$totalPage;
            $return["lastPage"]=$lastPage;
            $return["firstPage"]=$firstPage;
        }
        return $return;
    }

    /**
     * 简单样式
     */
    public function simple($paramObj="")
    {
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'data' => 'require',
                'moduleId' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0)
        {
            $data=$dataObj->request->data;

            $url = request()->url();
            $url = preg_replace('/page=\d?&/','',$url);
            $url = preg_replace('/(\?|&|\/)page(\/|=).*/i','',$url);
            $mark = '=';
            if(strpos($url,'?') !== false){
                $index = '&page';
            }else{
                $index = '?page';
            }
            $baseUrl = "{$url}{$index}{$mark}";

            $href = $baseUrl."1";
            $tem='<div class="ltcms-pages">';
            $tem.=' <a href="'.$href.'"><span>'.lang("page.home").'</span></a>';

            $href = $baseUrl.($data["page"]-1);
            if($data["firstPage"]>1){
                $tem.='<a href="'.$href.'"><span class="prev">&lt;</span></a>';
            }
            $tem.='<ul>';
            for($i=$data["firstPage"];$i<=$data["lastPage"];$i++){
                $href = $baseUrl.$i;
                if($i==$data["page"]){
                    $tem.='<li><a class="active" href="'.$href.'"><span>'.$i.'</span></a></li>';
                }else{
                    $tem.='<li><a href="'.$href.'"><span>'.$i.'</span></a></li>';
                }
            }
            $tem.='</ul>';

            $href = $baseUrl.($data["page"]+1);
            if($data["lastPage"] < $data["totalPage"]){
                $tem.='<a href="'.$href.'"><span class="next">&gt;</span></a>';
            }

            $href = $baseUrl.$data["totalPage"];
            $tem.='<a href="'.$href.'"><span>'.lang("page.end").'</span></a>';
            $tem.='</div>';

            $return=array();
            $return["type"]="echo";
            $return["data"]=$tem;
            $final_arr["result"]= $return;
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}

?>