<?php

namespace app\utils\base\plugin\oauth;

class Oauth_ltcms_base_plugin
{
	//第三方登录名称
	public $name = 'Ltcms-base';

//	public $baseUrl = 'https://www.ltcms.com';
//	public $appId = '8EC05097D46D1E12873A4C87175E9D87';
//	public $appSecret = '835B25191ECB161C9DBCB546960B93AC';

    public $appId = '25C4074A42CA780302622052C5051348';
	public $appSecret = 'A3E1106CC36637263115B343A6DCD965';

    public function __construct()
    {
        $this->baseUrl=config("app.cmsSiteUrl");
    }

    /**
	 * 获取accessToken
	 * @return string
	 */
	public function getAccessToken($paramObj="")
	{
		$dataObj=paramsObj();
		$dataObj->request=paramsObj();
		$dataObj->data=paramsObj();

		$final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
		if($final_arr["error_no"]==0)
		{
			$extraData=is_array($dataObj->request->extraData)?$dataObj->request->extraData:toJsonDecode($dataObj->request->extraData);
            if(isset($extraData["code"]) && $extraData["code"]){
                $params=array();
                $params["grant_type"]="authorization_code";
                $params["code"]=$extraData["code"];
                $params["secret"]=$this->appSecret;
                $params["appId"]=$this->appId;
                $params["forever"]=1;
                $submitUrl=$this->baseUrl."/api/oauth/access_token?".http_build_query($params);

                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "submitUrl"=>$submitUrl,
                    "method"=>"POST",
                    "time"=>"3",
                );
                $checkResult=app("P_http")->send($paramsObj);
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    $body=toJsonDecode($result["body"]);
                    if($body){
                        if($body["success"]){
                            $final_arr["result"]=$body["data"];
                        }else{
                            $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,$body["codeMsg"]);
                        }
                    }else{
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"));
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }else{
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"));
            }
		}
		return $final_arr;
	}

	/**
	 * 获取用户信息
	 * @return string
	 */
	public function getUserInfo($paramObj="")
	{
		$dataObj=paramsObj();
		$dataObj->request=paramsObj();
		$dataObj->data=paramsObj();

		$final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'extraData' => 'require',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
		if($final_arr["error_no"]==0)
		{
			$extraData=is_array($dataObj->request->extraData)?$dataObj->request->extraData:toJsonDecode($dataObj->request->extraData);
            $params=array();
            $params["access_token"]=$extraData["token"];
            $params["openId"]=$extraData["openId"];
            $submitUrl=$this->baseUrl."/api/oauth/userinfo?".http_build_query($params);
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "submitUrl"=>$submitUrl,
                "method"=>"get",
                "time"=>"3",
            );
            $checkResult=app("P_http")->send($paramsObj);
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $body=toJsonDecode($result["body"]);
                if($body){
                    if($body["success"]){
                        $data=$body["data"];
                        $userInfo=array();
                        $userInfo["openId"]=$data["openId"];
                        $userInfo["uniqueId"]=isset($data["unionId"])?$data["unionId"]:"";
                        $userInfo["nickname"]=isset($data["nickname"])?$data["nickname"]:"";
                        $userInfo["userAvatar"]=isset($data["userAvatar"])?$data["userAvatar"]:"";
                        $userInfo["sex"]=isset($data["sex"])?$data["sex"]:"";
                        $final_arr["result"]=$userInfo;
                    }else{
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,$body["codeMsg"]);
                    }
                }else{
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OP_FAIL,lang("sys.opFail"));
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
		}
		return $final_arr;
	}

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}

?>