<?php

namespace app\utils\base\plugin;

use app\utils\seo\Sitemap;

class P_sitemaps
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            //参数验证
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'data' => 'require|array',
                'open' => '',
            );
            $dataDefault=array();
            $dataDefault["open"]=1;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $sitemapFile=LTCMS_ROOT."/sitemaps.xml";
            if($dataObj->request->open){
                $xmlData=Sitemap::getData($dataObj->request->data);
                $result=fileWrite($sitemapFile,$xmlData);
                if(!$result){
                    $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::VERIFY_DATA_FAIL,"生成失败");
                }
            }else{
                //删除站点地图
                fileDel($sitemapFile);
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_NOTICE,app("errorCode")::VERIFY_DATA_FAIL,"sitemap.xml已删除");
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}