<?php

namespace app\utils\base\plugin;

use app\logic\common\L_secretIdKey;

class P_http
{
    /**
     * 发送curl请求
     */
    public function send($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //参数验证
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'submitUrl' => 'require',
                'method' => '',
                'time' => '',
                'data' => '',
                'headers' => '',
                'cookies' => '',
                'isReturnHeader' => '',
            );
            $dataDefault = array();
            $dataDefault["method"] = "get";
            $dataDefault["time"] = 6;
            $dataDefault["data"] = array();
            $dataDefault["headers"] = array();
            $dataDefault["cookies"] = "";
            $dataDefault["isReturnHeader"] = 0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $curl = curl_init($dataObj->request->submitUrl);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, strtoupper($dataObj->request->method));
            if ("https://" == substr($dataObj->request->submitUrl, 0, 8)) {
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            }
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);// 显示输出结果
            curl_setopt($curl, CURLOPT_FAILONERROR, false);
            curl_setopt($curl, CURLOPT_TIMEOUT, $dataObj->request->time);// 单位 秒，超时限制。
            if ($dataObj->request->isReturnHeader) {
                curl_setopt($curl, CURLOPT_HEADER, true); // 返回HTTP头
            } else {
                curl_setopt($curl, CURLOPT_HEADER, false); // 过滤HTTP头
            }
            if ($dataObj->request->cookies) {
                curl_setopt($curl, CURLOPT_COOKIE, $dataObj->request->cookies); // 带上COOKIE请求
            }
            if (strtolower($dataObj->request->method) == "post") {
                curl_setopt($curl, CURLOPT_POST, true); // post传输数据
            }
            if ($dataObj->request->data) {
                if (is_array($dataObj->request->data)) {
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($dataObj->request->data));
                } else {
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $dataObj->request->data);
                }
            }
            if ($dataObj->request->headers) {
                curl_setopt($curl, CURLOPT_HTTPHEADER, $dataObj->request->headers);
            }
            $sContent = curl_exec($curl);
            $errno = curl_errno($curl);
            $error_msg = curl_error($curl);
            $requestHeader = curl_getinfo($curl);
            $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE); //获取响应状态码

            if ($dataObj->request->isReturnHeader) {
                $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE); //获取头信息大小
                $header = substr($sContent, 0, $headerSize);
                $body = substr($sContent, $headerSize);
            } else {
                $header = "";
                $body = $sContent;
            }
            curl_close($curl);
            if ($errno == 0) {
                $return = array();
//                $return['params']=$dataObj->request->data;
//                $return['requestHeader']=$requestHeader;
//                $return['responseHeader']=$header;
                $return['errno'] = $errno;
                $return['error_msg'] = $error_msg;
                $return['httpCode'] = $httpCode;
                $return['body'] = $body;
//                $return['sContent']=$sContent;
                $final_arr["result"] = $return;
            } else {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $error_msg);
            }
        }
        return $final_arr;
    }

    /**
     * 发送curl 请求
     */
    public function sendStream($paramObj = "", $callback = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //参数验证
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'submitUrl' => 'require',
                'method' => '',
                'time' => '',
                'data' => '',
                'headers' => '',
                'cookies' => '',
                'isReturnHeader' => '',
            );
            $dataDefault = array();
            $dataDefault["method"] = "get";
            $dataDefault["time"] = 6;
            $dataDefault["data"] = array();
            $dataDefault["headers"] = array();
            $dataDefault["cookies"] = "";
            $dataDefault["isReturnHeader"] = 0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $curl = curl_init($dataObj->request->submitUrl);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, strtoupper($dataObj->request->method));
            if ("https://" == substr($dataObj->request->submitUrl, 0, 8)) {
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            }
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);// 显示输出结果
            curl_setopt($curl, CURLOPT_FAILONERROR, false);
            curl_setopt($curl, CURLOPT_TIMEOUT, $dataObj->request->time);// 单位 秒，超时限制。
            if ($dataObj->request->isReturnHeader) {
                curl_setopt($curl, CURLOPT_HEADER, true); // 返回HTTP头
            } else {
                curl_setopt($curl, CURLOPT_HEADER, false); // 过滤HTTP头
            }
            if (strtolower($dataObj->request->method) == "post") {
                curl_setopt($curl, CURLOPT_POST, true); // post传输数据
            }
            if ($dataObj->request->data) {
                if (is_array($dataObj->request->data)) {
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($dataObj->request->data));
                } else {
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $dataObj->request->data);
                }
            }
            if ($dataObj->request->headers) {
                curl_setopt($curl, CURLOPT_HTTPHEADER, $dataObj->request->headers);
            }
            if ($callback) {
                curl_setopt($curl, CURLOPT_WRITEFUNCTION, $callback);
            }
            $sContent = curl_exec($curl);
            $errno = curl_errno($curl);
            $error_msg = curl_error($curl);
            curl_close($curl);
            if ($errno == 0) {

            } else {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $error_msg);
            }
        }
        return $final_arr;
    }

    /**
     * 发送curl请求
     */
    public function sendUnchecked($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $dataObj->request->submitUrl = isset($paramObj->submitUrl) ? $paramObj->submitUrl : "";
            $dataObj->request->method = isset($paramObj->method) ? $paramObj->method : "get";
            $dataObj->request->time = isset($paramObj->time) ? $paramObj->time : "6";
            $dataObj->request->data = isset($paramObj->data) ? $paramObj->data : array();
            $dataObj->request->headers = isset($paramObj->headers) ? $paramObj->headers : array();
            $dataObj->request->isReturnHeader = isset($paramObj->isReturnHeader) ? $paramObj->isReturnHeader : 0;
            if (!$dataObj->request->submitUrl) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            }
        }
        if ($final_arr["error_no"] == 0) {
            $curl = curl_init($dataObj->request->submitUrl);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, strtoupper($dataObj->request->method));
            if ("https://" == substr($dataObj->request->submitUrl, 0, 8)) {
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            }
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);// 显示输出结果
            curl_setopt($curl, CURLOPT_FAILONERROR, false);
            curl_setopt($curl, CURLOPT_TIMEOUT, $dataObj->request->time);// 单位 秒，超时限制。
            if ($dataObj->request->isReturnHeader) {
                curl_setopt($curl, CURLOPT_HEADER, true); // 返回HTTP头
            } else {
                curl_setopt($curl, CURLOPT_HEADER, false); // 过滤HTTP头
            }
            if (strtolower($dataObj->request->method) == "post") {
                curl_setopt($curl, CURLOPT_POST, true); // post传输数据
            }
            if ($dataObj->request->data) {
                curl_setopt($curl, CURLOPT_POSTFIELDS, $dataObj->request->data);
            }
            if ($dataObj->request->headers) {
                curl_setopt($curl, CURLOPT_HTTPHEADER, $dataObj->request->headers);
            }
            $sContent = curl_exec($curl);
            $errno = curl_errno($curl);
            $error_msg = curl_error($curl);
            $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE); //获取响应状态码

            if ($dataObj->request->isReturnHeader) {
                $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE); //获取头信息大小
                $body = substr($sContent, $headerSize);
            } else {
                $body = $sContent;
            }
            curl_close($curl);
            if ($errno == 0) {
                $return = array();
                $return['errno'] = $errno;
                $return['error_msg'] = $error_msg;
                $return['httpCode'] = $httpCode;
                $return['body'] = $body;
                $final_arr["result"] = $return;
            } else {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $error_msg);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}