<?php

namespace app\utils\base\database;

class Migrate
{
    /**
     * 导出-安装-数据表
     * @param string $paramObj
     * @return array
     */
    public function exportInstallTable($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'database' => 'require',
                'version' => 'require',
                'outFile' => '',
                'filename' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $migrateData=$this->getMigrateData($dataObj->request->database,$dataObj->request->version);
            $delimiter="\r\n";
            $table_pre=config("database.default.tb_pre","");
            $sql="";
            $sql.=$delimiter;
            $sql.="SET NAMES utf8mb4;".$delimiter;
            $sql.="SET FOREIGN_KEY_CHECKS = 0;".$delimiter.$delimiter;
            foreach($migrateData["tableList"] as $lval){
                $createSql="show create table {$table_pre}{$lval['name']}";
                $result=Db()->fetch(Db()->select($createSql));
                if($result){
                    $rowData=$result[0];
                    $table_ddl=$rowData["Create Table"];
                    $table_ddl=preg_replace("/AUTO_INCREMENT=(\d+)\s/","",$table_ddl);
                    if($lval['name']=="module"){
                        $table_ddl.=" AUTO_INCREMENT=10";
                    }

                    $sql .= "-- ----------------------------".$delimiter;
                    $sql .= "-- Table structure for `".$lval['name']."`".$delimiter;
                    $sql .= "-- ----------------------------".$delimiter;
                    $sql .= "DROP TABLE IF EXISTS `{table_pre}".$lval['name']."`;".$delimiter;
                    $sql.=str_replace("CREATE TABLE `{$table_pre}{$lval['name']}` ","CREATE TABLE `{table_pre}{$lval['name']}` ",$table_ddl).";".$delimiter.$delimiter;

                    //查询数据
                    $record=isset($lval["record"])?$lval["record"]:0;
                    if($record){
                        $replace=isset($lval["replace"])?$lval["replace"]:"";
                        $removeField=isset($lval["removeField"])?$lval["removeField"]:"";
                        $condition=isset($lval["condition"])?$lval["condition"]:"";
                        $condition=$condition?" where ".$condition:"";
                        //查询当前表数据
                        $selectSql="select * from {$table_pre}{$lval['name']}{$condition}";
                        $tableData=Db()->select($selectSql);
                        if($tableData){
                            $fields=$tableData[0];
                            if($removeField && is_array($removeField)){
                                foreach($removeField as $fd){
                                    unset($fields[$fd]);
                                }
                            }
                            $fields="`".implode("`,`",array_keys($fields))."`";
                            $sql .= "-- ----------------------------".$delimiter;
                            $sql .= "-- Records for `".$lval['name']."`".$delimiter;
                            $sql .= "-- ----------------------------".$delimiter;
                            foreach($tableData as $dkey=>$dval){
                                $sql .= "INSERT INTO `{table_pre}".$lval['name']."`({$fields}) VALUES (";
                                foreach($dval as $ddkey=>$ddval){
                                    if($removeField && in_array($ddkey,$removeField)){
                                        continue;
                                    }
                                    if(isset($replace[$ddkey][$ddval])){
                                        $ddval=$replace[$ddkey][$ddval];
                                    }
                                    if(is_numeric($ddval)){
                                        $sql .= $ddval.", ";
                                    }else{
                                        $sql .= "'".addslashes($ddval)."', ";
                                    }
                                }
                                $sql=rtrim($sql,", ");
                                $sql .=");".$delimiter;
                            }
                            $sql .=$delimiter;
                        }
                    }
                }
            }
            $sql.="SET FOREIGN_KEY_CHECKS = 1;".$delimiter.$delimiter;
            $dataObj->data->sql=$sql;
            unset($sql);
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->outFile){
                $filename=$dataObj->request->filename?$dataObj->request->filename:"table.sql";
                $outFile=runtimePath("migrate/install_table/".str_replace(".","_",$dataObj->request->version));
                $outFile=str_replace("\\","/",$outFile);
                $this->mkdir($outFile);
                $filePath=$outFile.$filename;
                file_put_contents($filePath,$dataObj->data->sql);
            }else{
                $return=array();
                $return["sql"]=$dataObj->data->sql;
                $final_arr["result"]=$return;
            }
        }
        return $final_arr;
    }

    /**
     * 获取迁移数据
     * @param $database
     * @param $version
     * @return array
     */
    public function getMigrateData($database,$version){
        if($database=="cms"){
            if($version=="1.0.0"){
                return $this->generateMigrateData_cms_1_0_0();
            }else if($version=="1.0.1"){
                return $this->generateMigrateData_cms_1_0_1();
            }
        }
        return array();
    }

    /**
     * 1.0.0 数据
     */
    public function generateMigrateData_cms_1_0_0(){
        $tableList=array();
        $tableList[]=array(
            "name"=>"ad_manage",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"ad_position",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"module",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"map_relation",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"cache",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"friend_link",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"member_admin",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"friend_link_group",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"single_page_group",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"member_admin_func",
            "record"=>"1",
            "condition"=>"menuId in (1,2,3,4,7,9) and plugins ='' ",
            "removeField"=>array(
                "id"
            ),
            "replace"=>array(
                "menuId"=>array(
                    7=>5,
                    9=>6,
                ),
            ),
        );
        $tableList[]=array(
            "name"=>"member_admin_menu",
            "record"=>"1",
            "condition"=>"id in (1,2,3,4,7,9)",
            "replace"=>array(
                "id"=>array(
                    7=>5,
                    9=>6,
                ),
            ),
        );
        $tableList[]=array(
            "name"=>"member_admin_role",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"member_admin_role_func",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"sessions",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"setting",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"single_page",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"category",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"cwp_task",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"commend_module_data",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"category_child",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"category_data",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"category_op",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"software_upgrade_log",
            "record"=>"0",
        );
        $result=array();
        $result["tableList"]=$tableList;
        return $result;
    }

    /**
     * 1.0.1 会员登录数据
     */
    public function generateMigrateData_cms_1_0_1(){
        $tableList=array();
        $tableList[]=array(
            "name"=>"oauth",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"oauth_show",
            "record"=>"0",
        );
        $tableList[]=array(
            "name"=>"oauth_users",
            "record"=>"0",
        );
        $result=array();
        $result["tableList"]=$tableList;
        return $result;
    }

    /**
     * 获取随机字符串
     * @param int $length
     * @return string
     */
    public function generateRandomString($minLen = 5, $maxLen = 10)
    {
        $characters = '1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        foreach (range(1, rand($minLen, $maxLen)) as $i) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    /**
     * 创建目录
     * @param $dir
     */
    public function mkdir($dir){
        if(!is_dir($dir)){
            @umask(000);
            return @mkdir($dir,0777,true);
        }
        return true;
    }
}