<?php

namespace app\table;

class CmsTable
{
    /**
     * 获取表前缀
     * @return bool|mixed
     */
    public static function getPre(){
        $connect=config("database.connect");
        $tb_pre=config("database.{$connect}.tb_pre");
        return $tb_pre;
    }

    /**
     * 软件升级日志
     * @return string
     */
    public static function softwareUpgradeLog()
    {
        return CmsTable::getPre()."software_upgrade_log";
    }

    /**
     * 商品
     * @return string
     */
    public static function goods()
    {
        return CmsTable::getPre()."goods";
    }

    /**
     * 操作检测
     * @return string
     */
    public static function opCheck()
    {
        return CmsTable::getPre()."op_check";
    }

    /**
     * 插件列表
     * @return string
     */
    public static function plugin()
    {
        return CmsTable::getPre()."plugin";
    }

    /**
     * 插件状态
     * @return string
     */
    public static function pluginStatus()
    {
        return CmsTable::getPre()."plugin_status";
    }

    /**
     * 插件状态-用户
     * @return string
     */
    public static function pluginStatusUser()
    {
        return CmsTable::getPre()."plugin_status_user";
    }

    /**
     * 插件记录
     * @return string
     */
    public static function pluginRecord()
    {
        return CmsTable::getPre()."plugin_record";
    }

    /**
     * 插件日志
     * @return string
     */
    public static function pluginStatusLog()
    {
        return CmsTable::getPre()."plugin_upgrade_log";
    }

    /**
     * 用户-插件数据
     * @return string
     */
    public static function userAttrPlugin()
    {
        return CmsTable::getPre()."user_attr_plugin";
    }

    /**
     * 流量数据
     * @return string
     */
    public static function flowData()
    {
        return CmsTable::getPre()."flow_data";
    }

    /**
     * 推荐模型数据
     * @return string
     */
    public static function commendModuleData()
    {
        return CmsTable::getPre()."commend_module_data";
    }

    /**
     * 新闻
     * @return string
     */
    public static function news()
    {
        return CmsTable::getPre()."news";
    }

    /**
     * 新闻
     * @return string
     */
    public static function newsData()
    {
        return CmsTable::getPre()."news_data";
    }

    /**
     * 分类
     * @return string
     */
    public static function category()
    {
        return CmsTable::getPre()."category";
    }

    /**
     * 分类-操作
     * @return string
     */
    public static function categoryOp()
    {
        return CmsTable::getPre()."category_op";
    }

    /**
     * 分类-元素
     * @return string
     */
    public static function categoryChild()
    {
        return CmsTable::getPre()."category_child";
    }

    /**
     * 代码混淆
     * @return string
     */
    public static function codeObscure()
    {
        return CmsTable::getPre()."code_obscure";
    }

    /**
     * 模型表
     * @return string
     */
    public static function module()
    {
        return CmsTable::getPre()."module";
    }

    /**
     * 数据-关联表
     * @return string
     */
    public static function mapRelation()
    {
        return CmsTable::getPre()."map_relation";
    }

    /**
     * 文章分类
     * @return string
     */
    public static function articleType()
    {
        return CmsTable::getPre()."article_type";
    }

    /**
     * 文章信息
     * @return string
     */
    public static function article($typeId)
    {
        return CmsTable::getPre()."article_{$typeId}";
    }

    /**
     * 文章信息数据表
     * @return string
     */
    public static function articleData($typeId)
    {
        return CmsTable::getPre()."article_data_{$typeId}";
    }

    /**
     * 配置表
     * @return string
     */
    public static function setting()
    {
        return CmsTable::getPre()."setting";
    }

    /** 管理员
     * @return string
     */
    public static function member_admin(): string
    {
        return CmsTable::getPre()."member_admin";
    }

    /** 管理员导航菜单功能表
     * @return string
     */
    public static function member_admin_menu(): string
    {
        return CmsTable::getPre()."member_admin_menu";
    }

    /** 管理员功能表
     * @return string
     */
    public static function member_admin_func(): string
    {
        return CmsTable::getPre()."member_admin_func";
    }

    /** 管理员角色
     * @return string
     */
    public static function member_admin_role(): string
    {
        return CmsTable::getPre()."member_admin_role";
    }

    /** 角色和功能关系表
     * @return string
     */
    public static function member_admin_role_func(): string
    {
        return CmsTable::getPre()."member_admin_role_func";
    }

    /** 角色和管理员关系表
     * @return string
     */
    public static function member_admin_role_relation(): string
    {
        return CmsTable::getPre()."member_admin_role_relation";
    }

    /** 广告位管理表
     * @return string
     */
    public static function adPosition(): string
    {
        return CmsTable::getPre()."ad_position";
    }

    /** 广告管理表
     * @return string
     */
    public static function adManage(): string
    {
        return CmsTable::getPre()."ad_manage";
    }

    /** 友情链接管理表
     * @return string
     */
    public static function friendLink(): string
    {
        return CmsTable::getPre()."friend_link";
    }
    /** 友情链接分组管理表
     * @return string
     */
    public static function friendLinkGroup(): string
    {
        return CmsTable::getPre()."friend_link_group";
    }
    /** 单页管理表
     * @return string
     */
    public static function single_page(): string
    {
        return CmsTable::getPre()."single_page";
    }
    /** 单页分组管理表
     * @return string
     */
    public static function single_page_group(): string
    {
        return CmsTable::getPre()."single_page_group";
    }
}