<?php

namespace app\logic\common;

class L_caches
{
    /**
     * 写入文件
     * @param string $paramObj
     */
    public function saveToFile($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'data' => 'require',
                'name' => 'require',
                'dir' => 'require',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $name=$dataObj->request->name;
            $filePath=$dataObj->request->dir."{$name}.json";
            $filePath=str_replace("\\","/",$filePath);

            $checkUpdate=$this->checkUpdate($name,$dataObj->request->dir);
            $updateFilePath=$checkUpdate["file"];
            $updateRelayFilePath=$checkUpdate["fileRelay"];
            $updateFilePathLock=$updateFilePath."_lock";
            $dataJson=toJsonEncode($dataObj->request->data);

            //获取文章分类
            if(app("P_file")->mkdir($dataObj->request->dir)){
                if($fp = fopen($updateFilePathLock,"w")){
                    if (flock($fp, LOCK_EX|LOCK_NB)) {
                        file_put_contents($updateRelayFilePath,$dataJson);
                        file_put_contents($updateFilePath,"1");
                        file_put_contents($filePath,$dataJson);
                        file_put_contents($updateFilePath,"0");
                        flock($fp, LOCK_UN);    // 释放锁定
                    }else{
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OPEN_FAIL,lang("sys.openFail"),"被锁住了");
                    }
                }
            }else{
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::OPEN_FAIL,lang("sys.openFail"));
            }
        }
        return $final_arr;
    }

    /**
     * 删除文件
     * @param string $paramObj
     */
    public function delFile($name,$dir){
        $filePath=$dir."{$name}.json";
        $filePath=str_replace("\\","/",$filePath);

        if(is_file($filePath)){
            unlink($filePath);
        }
    }

    /**
     * 检测是否正在更新
     * @param $name
     * @return array
     */
    public function checkUpdate($name,$dir){
        $moduleUpdateFile=$dir."{$name}_update";
        $moduleUpdateFile=str_replace("\\","/",$moduleUpdateFile);

        $updateRelayFile=$dir."{$name}_update_tmp";
        $updateRelayFile=str_replace("\\","/",$updateRelayFile);

        $result=array(
            "status"=>false,
            "file"=>$moduleUpdateFile,
            "fileRelay"=>$updateRelayFile,
        );
        if(is_file($moduleUpdateFile)){
            $content=file_get_contents($moduleUpdateFile);
            if($content=="1"){
                $result["status"]=true;
            }
        }
        return $result;
    }

    /**
     * 更新网站设置
     * @param string $paramObj
     */
    public function updateSetting($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'pid' => 'integer',
            );
            $dataDefault = array();
            $dataDefault["pid"] = 0;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $checkResult=app("S_Index_setting")->allData();
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $dir=runtimePath("cache/setting");
                if($final_arr["error_no"]==0){
                    if($result){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "name"=>"all",
                            "data"=>$result,
                            "dir"=>$dir,
                        );
                        $checkResult=$this->saveToFile($paramsObj);
                        if($checkResult["error_no"]==0){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }else{
                        //删除文件
                        $this->delFile("all",$dir);
                    }
                }
                if($final_arr["error_no"]==0){
                    if($dataObj->request->pid && isset($result[$dataObj->request->pid])){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "name"=>$dataObj->request->pid,
                            "data"=>$result[$dataObj->request->pid],
                            "dir"=>$dir,
                        );
                        $checkResult=$this->saveToFile($paramsObj);
                        if($checkResult["error_no"]==0){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }else{
                        //删除文件
                        $this->delFile($dataObj->request->pid,$dir);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取网站配置
     * @param string $paramObj
     */
    public function getSetting($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'itemKey' => '',
                'pid' => 'require',
            );
            $dataDefault = array();
            $dataDefault["pid"] = 0;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->content=array();
            $dir=str_replace("\\","/",runtimePath("cache/setting"));

            $setFile="";
            $settingPath=$dir."{$dataObj->request->pid}.json";
            $settingAllPath=$dir."all.json";
            if($dataObj->request->pid=="all"){
                if(is_file($settingAllPath) && filesize($settingAllPath) > 0){
                    $setFile=$settingAllPath;
                }
                if($setFile){
                    $content=file_get_contents($setFile);
                    $dataObj->data->content=$content?toJsonDecode($content):array();
                }
            }else{
                $isAll=0;
                if(is_file($settingPath) && filesize($settingPath) > 0){
                    $setFile=$settingPath;
                }else if(is_file($settingAllPath) && filesize($settingAllPath) > 0){
                    $setFile=$settingAllPath;
                    $isAll=1;
                }
                $is_updateing=$this->checkUpdate($dataObj->request->pid,$dir);
                if($is_updateing["status"]){
                    if(is_file($is_updateing["fileRelay"]) && filesize($is_updateing["fileRelay"]) > 0){
                        $setFile=$is_updateing["fileRelay"];
                        $isAll=0;
                    }
                }
                if($setFile){
                    if($isAll){
                        $content=file_get_contents($setFile);
                        $content=$content?toJsonDecode($content):array();
                        $dataObj->data->content=isset($content[$dataObj->request->pid])?$content[$dataObj->request->pid]:array();
                    }else{
                        $content=file_get_contents($setFile);
                        $dataObj->data->content=$content?toJsonDecode($content):array();
                    }
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->itemKey){
                if(isset($dataObj->data->content[$dataObj->request->itemKey])){
                    $final_arr["result"]=$dataObj->data->content[$dataObj->request->itemKey];
                }else{
                    $final_arr["result"]="";
                }
            }else{
                $final_arr["result"]=$dataObj->data->content;
            }
        }
        return $final_arr;
    }

    /**
     * 更新模块数据
     * @param string $paramObj
     */
    public function updateModule($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'integer',
            );
            $dataDefault = array();
            $dataDefault["pid"] = 0;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $checkResult=app("S_Admin_module")->allData();
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $dir=runtimePath("cache/module");
                if($final_arr["error_no"]==0){
                    if($result){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "name"=>"all",
                            "data"=>$result,
                            "dir"=>$dir,
                        );
                        $checkResult=$this->saveToFile($paramsObj);
                        if($checkResult["error_no"]==0){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }else{
                        //删除文件
                        $this->delFile("all",$dir);
                    }
                }
                if($final_arr["error_no"]==0){
                    if($dataObj->request->id && isset($result[$dataObj->request->id])){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "name"=>$dataObj->request->id,
                            "data"=>$result[$dataObj->request->id],
                            "dir"=>$dir,
                        );
                        $checkResult=$this->saveToFile($paramsObj);
                        if($checkResult["error_no"]==0){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }else{
                        //删除文件
                        $this->delFile($dataObj->request->id,$dir);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取模块数据
     * @param string $paramObj
     */
    public function getModule($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'id' => 'require',
                'print' => '',
                'itemKey' => '',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->content=array();
            $dir=str_replace("\\","/",runtimePath("cache/module"));

            $setFile="";
            $settingPath=$dir."{$dataObj->request->id}.json";
            $settingAllPath=$dir."all.json";
            if($dataObj->request->id=="all"){
                if(is_file($settingAllPath) && filesize($settingAllPath) > 0){
                    $setFile=$settingAllPath;
                }
                if($setFile){
                    $content=file_get_contents($setFile);
                    $dataObj->data->content=$content?toJsonDecode($content):array();
                }
            }else{
                $isAll=0;
                if(is_file($settingPath) && filesize($settingPath) > 0){
                    $setFile=$settingPath;
                }else if(is_file($settingAllPath) && filesize($settingAllPath) > 0){
                    $setFile=$settingAllPath;
                    $isAll=1;
                }
                $is_updateing=$this->checkUpdate($dataObj->request->id,$dir);
                if($is_updateing["status"]){
                    if(is_file($is_updateing["fileRelay"]) && filesize($is_updateing["fileRelay"]) > 0){
                        $setFile=$is_updateing["fileRelay"];
                        $isAll=0;
                    }
                }
                if($setFile){
                    if($isAll){
                        $content=file_get_contents($setFile);
                        $content=$content?toJsonDecode($content):array();
                        $dataObj->data->content=isset($content[$dataObj->request->id])?$content[$dataObj->request->id]:array();
                    }else{
                        $content=file_get_contents($setFile);
                        $dataObj->data->content=$content?toJsonDecode($content):array();
                    }
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->itemKey){
                if(isset($dataObj->data->content[$dataObj->request->itemKey])){
                    $final_arr["result"]=$dataObj->data->content[$dataObj->request->itemKey];
                }else{
                    $final_arr["result"]="";
                }
            }else{
                $final_arr["result"]=$dataObj->data->content;
            }
        }
        return $final_arr;
    }

    /**
     * 更新分类数据
     * @param string $paramObj
     */
    public function updateCategory($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'dataId' => '',
            );
            $dataDefault = array();
            $dataDefault["pid"] = 0;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "format"=>"cache",
            );
            $checkResult=app("S_Admin_category")->allData($paramsObj);
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                $dir=runtimePath("cache/category");
                if($final_arr["error_no"]==0){
                    if($result){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "name"=>"all",
                            "data"=>$result,
                            "dir"=>$dir,
                        );
                        $checkResult=$this->saveToFile($paramsObj);
                        if($checkResult["error_no"]==0){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }else{
                        //删除文件
                        $this->delFile("all",$dir);
                    }
                }
                if($final_arr["error_no"]==0){
                    if($dataObj->request->dataId){
                        $fileName=$dataObj->request->dataType."_".$dataObj->request->dataId;
                        if(isset($result[$dataObj->request->dataId])){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "name"=>$fileName,
                                "data"=>$result[$dataObj->request->dataId],
                                "dir"=>$dir,
                            );
                            $checkResult=$this->saveToFile($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }else{
                            //删除文件
                            $this->delFile($fileName,$dir);
                        }
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取分类数据
     * @param string $paramObj
     */
    public function getCategory($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'dataId' => 'require',
                'print' => '',
                'itemKey' => '',
            );
            $dataDefault = array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->content=array();
            $dir=str_replace("\\","/",runtimePath("cache/category"));
            $dataType=$dataObj->request->dataType;
            $dataId=$dataObj->request->dataId;
            $fileName="{$dataType}_{$dataId}";

            $setFile="";
            $settingPath=$dir."{$fileName}.json";
            $settingAllPath=$dir."{$dataType}_all.json";
            if($dataObj->request->dataId=="all"){
                if(is_file($settingAllPath) && filesize($settingAllPath) > 0){
                    $setFile=$settingAllPath;
                }
                if($setFile){
                    $content=file_get_contents($setFile);
                    $dataObj->data->content=$content?toJsonDecode($content):array();
                }
            }else{
                $isAll=0;
                if(is_file($settingPath) && filesize($settingPath) > 0){
                    $setFile=$settingPath;
                }else if(is_file($settingAllPath) && filesize($settingAllPath) > 0){
                    $setFile=$settingAllPath;
                    $isAll=1;
                }
                $is_updateing=$this->checkUpdate($fileName,$dir);
                if($is_updateing["status"]){
                    if(is_file($is_updateing["fileRelay"]) && filesize($is_updateing["fileRelay"]) > 0){
                        $setFile=$is_updateing["fileRelay"];
                        $isAll=0;
                    }
                }
                if($setFile){
                    if($isAll){
                        $content=file_get_contents($setFile);
                        $content=$content?toJsonDecode($content):array();
                        $dataObj->data->content=isset($content[$dataId])?$content[$dataId]:array();
                    }else{
                        $content=file_get_contents($setFile);
                        $dataObj->data->content=$content?toJsonDecode($content):array();
                    }
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->itemKey){
                if(isset($dataObj->data->content[$dataObj->request->itemKey])){
                    $final_arr["result"]=$dataObj->data->content[$dataObj->request->itemKey];
                }else{
                    $final_arr["result"]="";
                }
            }else{
                $final_arr["result"]=$dataObj->data->content;
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}