<?php

namespace app\logic\api;

class L_sitemaps
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'disabled' => '',
            );
            $dataDefault=array();
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            //获取文章分类
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "disabled"=>$dataObj->request->disabled,
            );
            $checkResult=app("S_Api_articleType")->validData($paramsObj);
            if($checkResult["error_no"]=="0"){
                $dataObj->data->articleTypeResult=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->data->articleTypeResult){
                $sitemaps_items="10000";//内容更新数量
                $limit=intval($sitemaps_items/count($dataObj->data->articleTypeResult));
                foreach($dataObj->data->articleTypeResult as $atype){
                    if($final_arr["error_no"]==0){
                        //查询文章数据
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "moduleId"=>$atype["id"],
                            "limit"=>$limit,
                            "field"=>"id,addTime",
                        );
                        $checkResult=app("S_Api_article")->validData($paramsObj);
                        if($checkResult["error_no"]=="0"){
                            $articleResult=$checkResult["result"];
                            if($articleResult){
                                $sitemaps=array();
                                foreach($articleResult as $aval){
                                    $sitemaps[]=array(
                                        "loc"=>"http://www.cms.com/".$aval["id"].".html",
                                        "changefreq"=>"always",
                                        "priority"=>"0.9",
                                        "lastmod"=>app("ltcmsTime")::getDateTime("Y-m-d",$aval["addTime"]),
                                    );
                                }
                                //生成站点地图
                                $paramsObj=paramsObj();
                                $paramsObj->params=array(
                                    "data"=>$sitemaps,
                                );
                                $checkResult=app("P_sitemaps")->store($paramsObj);
                                if($checkResult["error_no"]=="0"){
                                    $final_arr["result"]=$checkResult["result"];
                                }else{
                                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                                }
                            }
                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }
                    if($final_arr["error_no"]){
                        break;
                    }
                }
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}