<?php

namespace app\logic\api;

use app\utils\signApi\signV1;

class L_goods
{
    /**
     * 插件列表
     * @param string $paramObj
     */
    public function pluginList($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'url' => '',
                'virtualType' => '',
                'categoryId' => '',
                'name' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $data = array();
            $data["virtualType"] = $dataObj->request->virtualType;
            $data["categoryId"] = $dataObj->request->categoryId;
            $data["name"] = $dataObj->request->name;
            $data["url"] = $dataObj->request->url;
            $submitUrl = config("app.cmsSiteUrl")."/api/ltcms_shop/plugin?" . http_build_query($data);

            $paramsObj = paramsObj();
            // 解析 URL 查询字符串
            parse_str(parse_url($submitUrl, PHP_URL_QUERY), $data);
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 3,
                "headers" => getSignV1($data),
            );

/*            if (env()->get("APP_debug", "") == 1) { //调试模式,解决curl请求本地host重定向不生效的问题
                $paramsObj->params["submitUrl"] = "http://127.0.0.1/api/plugin?" . http_build_query($data);
                $paramsObj->params["headers"][] ="Host: www.cms3.com";
            }*/

            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if ($result["httpCode"] == "200") {
                    $body = toJsonDecode($result["body"]);
                    if ($body["success"]) {
                        $final_arr["result"] = $body["data"];
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 插件详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $data = array();
            $data["id"] = $dataObj->request->id;
            $submitUrl = config("app.cmsSiteUrl")."/api/ltcms_shop/plugin/info?" . http_build_query($data);
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "submitUrl" => $submitUrl,
                "method" => "get",
                "time" => 3,
                "headers" => getSignV1($data),
            );
            $checkResult = app("P_http")->send($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                if ($result["httpCode"] == "200") {
                    $body = toJsonDecode($result["body"]);
                    if ($body["success"]) {
                        $final_arr["result"] = $body["data"];
                    } else {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, $body["code"], $body["codeMsg"]);
                    }
                } else {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"), $result["error_msg"]);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}