<?php

namespace app\logic\admin;

class L_systemUpgrade
{
    /**
     * 下载文件
     * @param string $paramObj
     */
    public function downloadFile($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'downUrl' => 'require',
                'project' => 'require',
                'num' => '',
                'fileSize' => '',
            );
            $dataDefault = array();
            $dataDefault["num"]=0;
            $dataDefault["fileSize"]=0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $downUrl=$dataObj->request->downUrl;
            if (strpos($downUrl, ".") === false) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
            } else {
                $filePath = LTCMS_ROOT."/version/upgrade/{$dataObj->request->project}/";
                makeDir($filePath);
                $filename = $filePath . basename($downUrl);
                if ($dataObj->request->num == "0") {
                    //删除文件
                    if (is_file($filename)) {
                        unlink($filename);
                    }
                }
                $fileResult = app("ltcmsDownload")->downloadUrl($downUrl,$dataObj->request->num,$dataObj->request->fileSize);
                if (isset($fileResult["content"])) {
                    if($fileResult["content"]){
                        file_put_contents($filename, base64_decode($fileResult["content"]), FILE_APPEND);
                    }
                    unset($fileResult["content"]);
                }
                $final_arr["result"] = $fileResult;
            }
        }
        return $final_arr;
    }

    /**
     * 安装
     * @param string $paramObj
     */
    public function install($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'incUp' => '',
            );
            $dataDefault = array();
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                "id" => $dataObj->request->id,
            );
            $checkResult = app("T_Api_software_upgrade")->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                $packageUrl=$dataObj->request->incUp?$result["packageUrl"]:$result["completePackageUrl"]; //压缩包地址
                $packageMd5Url=$dataObj->request->incUp?$result["packageMd5Url"]:$result["completePackageMd5Url"]; //压缩包-md5信息
                if($packageUrl && $packageMd5Url){
                    if ($final_arr["error_no"] == 0) {
                        //记录数据
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            'project' => $result['project'],
                            'stage' => $result['stage'],
                            'version' => $result['version'],
                            'date' => $result['date'],
                            'packageUrl' => $packageUrl,
                        );
                        $checkResult=app("S_Admin_software_upgrade_log")->store($paramsObj);
                        if ($checkResult["error_no"] == 0) {
                            $dataObj->data->sfLogResult=$checkResult["result"];
                        }else{
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                    }
                    if ($final_arr["error_no"] == 0) {
                        if (strpos($packageUrl, ".") === false) {
                            $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                        } else {
                            $filePath = LTCMS_ROOT."/version/upgrade/{$result['project']}/";
                            $filename = $filePath . basename($packageUrl);
                            $filemd5 = $filePath . basename($packageMd5Url);
                            $backFile=$filePath.$dataObj->data->sfLogResult["id"]."_old.zip";
                            if(is_file($filename) && is_file($filemd5)){
                                if ($final_arr["error_no"] == 0) {
                                    $filemd5Data=file_get_contents($filemd5);
                                    $filemd5Data=$filemd5Data?explode("\n",$filemd5Data):array();
                                    $backupFiles=$this->getBackupFiles($filemd5Data,LTCMS_ROOT);
                                    $ok=app("ltcmsZip")->compressByFiles($backFile,LTCMS_ROOT,$backupFiles); //备份代码
                                    if(!$ok){
                                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                                    }else{
                                        //更新备份文件
                                        $paramsObj=paramsObj();
                                        $paramsObj->params=array(
                                            'id' => $dataObj->data->sfLogResult['id'],
                                            'oldFile' => $backFile,
                                        );
                                        $checkResult=app("S_Admin_software_upgrade_log")->update($paramsObj);
                                        if ($checkResult["error_no"] == 0) {

                                        }else{
                                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                        }
                                    }
                                }
                                if ($final_arr["error_no"] == 0) {
                                    //执行文件安装
                                    $ok=app("ltcmsZip")->decompression($filename,LTCMS_ROOT);
                                    if($ok){
                                        unlink($filename);
                                        unlink($filemd5);
                                    }else{
                                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                                    }
                                }
                                if ($final_arr["error_no"] == 0) {
                                    if($result['script_executed']=="1"){
                                        $checkResult=$this->execScript();
                                        if ($checkResult["error_no"] == 0) {

                                        }else{
                                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                                        }
                                    }
                                }
                            }else{
                                //文件不存在
                                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                            }
                        }
                    }
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if(isset($dataObj->data->sfLogResult['id'])){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'id' => $dataObj->data->sfLogResult['id'],
                    'result' => 1,
                );
                $checkResult=app("S_Admin_software_upgrade_log")->update($paramsObj);
                if ($checkResult["error_no"] == 0) {

                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }else{
            if(isset($dataObj->data->sfLogResult['id'])){
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'id' => $dataObj->data->sfLogResult['id'],
                    'result' => 2,
                );
                $checkResult=app("S_Admin_software_upgrade_log")->update($paramsObj);
                if ($checkResult["error_no"] == 0) {

                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 执行脚本
     */
    public function execScript(){
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            //执行文件
            $execFile=LTCMS_ROOT."/version/ExecScript.php";
            if(is_file($execFile)){
                include_once $execFile;
                $className="ExecScript";
                if(class_exists($className)){
                    $exec=new $className();
                    if(method_exists($exec,"install")){
                        $ok=$exec->install();
                        if(!$ok){
                            $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                        }
                    }else{
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                    }
                }else{
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::OP_FAIL, lang("sys.opFail"));
                }
            }
        }
        return $final_arr;
    }

    /**
     * 获取备份文件
     * @param $data
     */
    private function getBackupFiles($data,$baseDir){
        $return=array();
        if($data){
            foreach($data as $val){
                list($file,$fileMd5)=explode("|",$val);
                $filePath=$baseDir.$file;
                if(is_file($filePath)){
                    $fileMd5Old=md5_file($filePath);
                    if($fileMd5Old != $fileMd5){
                        $return[]=$filePath;
                    }
                }
            }
        }
        return $return;
    }
}