<?php

namespace app\logic\admin;

class L_setting
{
    const setting_system = 1;  //设置类型_系统设置 setting_system
    const setting_Seo = 2;
    const setting_optimization = 3; //性能优化设置

    const setting_cloudServices = 4;
    const setting_member = 5;   //成员基础设置

    /**
     * 记录数据[批量]
     * @param string $paramObj
     */
    public function recordBatch($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'setting' => '',
                'config' => '',
                'pid' => 'integer',
            );
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->setting){
                if($final_arr["error_no"]==0){
                    foreach($dataObj->request->setting as $setKey=>$setVal){
                        if($final_arr["error_no"]==0){
                            $paramsObj=paramsObj();
                            $paramsObj->params=array(
                                "itemKey"=>$setKey,
                                "itemValue"=>$setVal,
                                "pid"=>$dataObj->request->pid,
                            );
                            $checkResult = $this->record($paramsObj);
                            if($checkResult["error_no"]==0){

                            }else{
                                $final_arr=logCallErrorMsg($final_arr,$checkResult);
                            }
                        }
                        if($final_arr["error_no"]){
                            break;
                        }
                    }
                }
                if($final_arr["error_no"]==0){
                    //更新缓存数据
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "pid"=>$dataObj->request->pid,
                    );
                    $checkResult=app("L_Common_caches")->updateSetting($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->config){
                $config=array();
                foreach($dataObj->request->config as $key=>$val){
                    $config=setData($key,$val,$config);
                }

                $envFile=LTCMS_ROOT."/.env";
                $envData = parse_ini_file($envFile, true, INI_SCANNER_RAW) ?: [];
                $envData=mergeArr($envData,$config);
                $envStr="";
                if($envData){
                    $index=0;
                    foreach($envData as $envKey=>$envval){
                        if($index > 0){
                            $envStr.="\r\n";
                        }
                        $envStr.="[".strtoupper($envKey)."]\r\n";
                        if($envval){
                            foreach($envval as $skey=>$sval){
                                $envStr.="{$skey}={$sval}\r\n";
                            }
                        }
                        $index++;
                    }
                }
                if($envStr){
                    file_put_contents($envFile,$envStr);
                }
            }
        }
        return $final_arr;
    }

    /**
     * 记录数据
     * @param string $paramObj
     */
    public function record($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->data->change=0;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'name' => '',
                'itemKey' => 'require',
                'itemValue' => '',
                'pid' => 'integer',
                'note' => '',
            );
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }

        if($final_arr["error_no"]==0){
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "itemKey"=>$dataObj->request->itemKey,
                "pid"=>$dataObj->request->pid,
                "field"=>"id,itemValue",
            );
            $checkResult = app("S_Admin_setting")->infoByItemKey($paramsObj);
            if($checkResult["error_no"]==0){
                $result=$checkResult["result"];
                if($result){
                    if($result["itemValue"] != $dataObj->request->itemValue){
                        $dataObj->data->change=1;
                    }
                    if($dataObj->data->change=="1"){
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "id"=>$result["id"],
                            "itemKey"=>$dataObj->request->itemKey,
                            "name"=>$dataObj->request->name,
                            "itemValue"=>$dataObj->request->itemValue,
                            "pid"=>$dataObj->request->pid,
                            "note"=>$dataObj->request->note,
                            "verify"=>0,
                        );
                        $checkResult = app("S_Admin_setting")->update($paramsObj);
                        if($checkResult["error_no"]==0){
                            $final_arr["result"]=$checkResult["result"];
                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }
                }else{
                    $dataObj->data->change=1;
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        "itemKey"=>$dataObj->request->itemKey,
                        "name"=>$dataObj->request->name,
                        "itemValue"=>$dataObj->request->itemValue,
                        "pid"=>$dataObj->request->pid,
                        "note"=>$dataObj->request->note,
                        "verify"=>0,
                    );
                    $checkResult = app("S_Admin_setting")->store($paramsObj);
                    if($checkResult["error_no"]==0){
                        $final_arr["result"]=$checkResult["result"];
                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        return $final_arr;
    }

}