<?php

namespace app\logic\admin;

class L_category
{
    /**
     * 记录资源
     */
    public function record($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => 'require',
                'childId' => 'require',
                'newParentId' => '',
                'oldParentId' => '',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            if($dataObj->request->newParentId || $dataObj->request->oldParentId){
                if ($final_arr["error_no"] == 0) {
                    Db()->startTrans();
                    $dataObj->data->use_trans = true;
                }
                if($final_arr["error_no"]==0 && $dataObj->request->newParentId){
                    //新增上级|添加
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'dataType' => $dataObj->request->dataType,
                        'parentId' => $dataObj->request->newParentId,
                        'childId' => $dataObj->request->childId,
                    );
                    $checkResult=app("S_Admin_categoryChild")->record($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
                if($final_arr["error_no"]==0 && $dataObj->request->oldParentId){
                    //原有上级|删除
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'dataType' => $dataObj->request->dataType,
                        'parentId' => $dataObj->request->oldParentId,
                        'childId' => $dataObj->request->childId,
                    );
                    $checkResult=app("S_Admin_categoryChild")->deleteBatch($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
                if($final_arr["error_no"]==0){
                    //更新数量
                    $ids=array();
                    if($dataObj->request->newParentId){
                        $ids=array_merge($ids,$dataObj->request->newParentId);
                    }
                    if($dataObj->request->oldParentId){
                        $ids=array_merge($ids,$dataObj->request->oldParentId);
                    }
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'dataType' => $dataObj->request->dataType,
                        'ids' => $ids,
                    );
                    $checkResult=$this->updateAssocCount($paramsObj);
                    if($checkResult["error_no"]==0){

                    }else{
                        $final_arr=logCallErrorMsg($final_arr,$checkResult);
                    }
                }
                if ($dataObj->data->use_trans) {
                    if ($final_arr["error_no"] == 0) {
                        Db()->commitTrans();
                    } else {
                        Db()->rollbackTrans();
                    }
                }
            }
        }
        return $final_arr;
    }

    /**
     * 更新-关联-数量
     */
    public function updateAssocCount($paramObj=""){
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'dataType' => 'require',
                'ids' => 'require',
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            foreach($dataObj->request->ids  as $id){
                if($final_arr["error_no"]==0){
                    if($final_arr["error_no"]==0){
                        //获取对应子元素数量
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            'dataType' => $dataObj->request->dataType,
                            'parentId' => $id,
                        );
                        $checkResult=app("S_Admin_categoryChild")->getChildIds($paramsObj);
                        if($checkResult["error_no"]==0){
                            $dataObj->data->childs=$checkResult["result"];
                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }
                    if($final_arr["error_no"]==0){
                        //更新对应记录
                        $childsCount=count($dataObj->data->childs);
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            "id"=>$id,
                            "child_count"=>$childsCount,
                        );
                        $checkResult=app("S_Admin_category")->update($paramsObj);
                        if($checkResult["error_no"]=="0"){

                        }else{
                            $final_arr=logCallErrorMsg($final_arr,$checkResult);
                        }
                    }
                }
                if($final_arr["error_no"]){
                    break;
                }
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}