<?php

namespace app\logic\admin;

class L_articleType
{
    /**
     * 创建资源
     * @param string $paramObj
     */
    public function store($paramObj = "")
    {
        //===========初始化本方法用到的变量数据
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;   //是否使用事务
        $dataObj->result = new \ArrayObject();
        $final_arr = logInit();               // 初始化最终数组

        //==========校验本方法用到的参数
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                "name" => "chsAlphaNum|max:50",
                "pid" => "must|number",
            );
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = getKeyDefaultRule($rules);
            $paramsObj->messages = getValidateMessage($messages);
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }

        if ($final_arr["error_no"] == 0) {
            Db()->startTrans();
            $dataObj->data->use_trans = true;
        }
        //开始插入分类数据,创建文章表 文章数据表
        if ($final_arr["error_no"] == 0) {
            $tempObj = paramsObj();
            $tempObj->mixed = parseToArr($paramObj, "mixed", 0);
            $tempObj->params = parseToArr($paramObj, "params", array());
            $addArticleTypeResult = app("S_Admin_articleType")->store($tempObj);
            if ($addArticleTypeResult["error_no"] == 0) {
                $result = $addArticleTypeResult["result"];
                $moduleId = $result["id"];
                //创建文章表 和数据表
                $tempObj = paramsObj();
                $tempObj->data = paramsObj();
                $tempObj->data->use_trans =  $dataObj->data->use_trans;
                $tempObj->params = array(
                    "moduleId" => $moduleId,
                );
                $articleResult = app("S_Admin_article")->createTable($tempObj);
                if ($articleResult["error_no"] == 0) {
                    $final_arr["result"] = $articleResult["result"]; //吧响应结果数据赋值到最终数组 结果数据
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $articleResult);
                }
            } else {
                $final_arr = logCallErrorMsg($final_arr, $addArticleTypeResult);
            }
        }


        if ($dataObj->data->use_trans) {
            if ($final_arr["error_no"] == 0) {
                Db()->commitTrans();
            } else {
                Db()->rollbackTrans();
            }
        }
        return $final_arr;
    }


}