<?php

namespace app\logic\admin;

class L_admin
{
    /**
     * 获取登录状态
     * @param string $paramObj
     * @return array
     */
    public function loginStatus($paramObj = "")
    {
        $final_arr = logInit();
        $final_arr["result"]=dict();
        if ($final_arr["error_no"] == 0) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                "id"=>session()->get(config("session.adminLogin.uid")),
                "field"=>"id,user",
            );
            $checkResult = app("S_Admin_admin")->info($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $final_arr["result"] = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 登出
     */
    public function logout()
    {
        $final_arr = logInit();
        $adminLogin=config("session.adminLogin");
        if($adminLogin){
            foreach($adminLogin as $key){
                session()->delete(config("session.adminLogin.".$key));
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}