<?php
//注册正则
//validate()->setRegex("password", "/^(?=.*[a-zA-Z])(?=.*\d)[a-zA-Z\d\S]{6,18}$/");  //提示信息无法更改 ,改为注册函数方式
validate()->setRegex("account", "/^([a-zA-Z])[a-zA-Z\d]{4,17}$/");
validate()->setType("array_isInt", function ($a, $b) {
    return array_isInt($a);
});

validate()->setType("password", function ($a, $b) {
    $rule = "/^[a-zA-Z\d_]{5,18}$/";
    return is_scalar($a) && 1 === preg_match($rule, (string)$a);
});


/**会添加把键名的所有默认类型
 * @param array $arrName array("name|用户名" => "require","age" => "require|gt:6",);
 * @param array $addTypeMsg 可以自己增加规则消息或覆盖默认  ["require" => ":attribute 是必填项666",]
 * @return array
 */
function getValidateMessage(array $arrName, $addTypeMsg = []): array
{
    $typeMsg = [
        "require" => ":attribute 不能为空",         //必须有键有值,值不能为空字符串
        "must" => ":attribute  必须存在",       //必须有键,值可以为空字符串
        "number" => ":attribute 必须是数字",       //验证时会转字符串,然后判断是否只包含数字,所以负数不可以
        "integer" => ":attribute 必须是整数",
        "float" => ":attribute 必须是浮点数",
        "boolean" => ":attribute 必须是布尔值",
        "email" => ":attribute 不是有效的电子邮件地址",
        "mobile" => ":attribute 不是有效的手机号码",
        "array" => ":attribute 必须是数组",
        "accepted" => ":attribute 必须是yes、on或1",
        "date" => ":attribute 不是有效的日期时间",
        "alpha" => ":attribute 必须是字母",
        "alphaNum" => ":attribute 必须是字母和数字",
        "alphaDash" => ":attribute 必须是字母、数字、破折号和下划线",
        "activeUrl" => ":attribute 不是有效的域名或IP地址",
        "chs" => ":attribute 必须是中文",
        "chsAlpha" => ":attribute 必须是中文或字母",
        "chsAlphaNum" => ":attribute 必须是中文、字母和数字",
        "chsDash" => ":attribute 必须是中文、字母、数字、破折号和下划线",
        "url" => ":attribute 不是有效的URL地址",
        "ip" => ":attribute 不是有效的IP地址",
        "dateFormat" => ":attribute 必须是 :rule 格式的日期",
        "in" => ":attribute 必须是 :rule 中的一个",
        "notIn" => ":attribute 不能是 :rule 中的一个",
        "between" => ":attribute 必须在 :1 - :2 之间",     //这个是验证整数是否在 规定值之间
        "notBetween" => ":attribute 不能在 :1 - :2 之间",
        "length" => ":attribute 的长度必须是 :rule",
        "max" => ":attribute 的最大长度不能超过 :rule",                  //验证长度,不能验证整数值是否小于xxx
        "min" => ":attribute 的最小长度不能小于 :rule",
        "after" => ":attribute 不能早于 :rule",
        "before" => ":attribute 不能晚于 :rule",
        "expire" => ":attribute 不在 :rule 之内",
        "allowIp" => "不允许访问的IP地址",
        "denyIp" => "禁止访问的IP地址",
        "confirm" => ":attribute 与 :2 不一致",
        "different" => ":attribute 不能与 :2 相同",
        "egt" => ":attribute 必须大于等于 :rule",
        "gt" => ":attribute 必须大于 :rule",
        "elt" => ":attribute 必须小于等于 :rule",
        "lt" => ":attribute 必须小于 :rule",
        "eq" => ":attribute 必须等于 :rule",
        "regex" => ":attribute 不符合规则",
        "password" => ":attribute必须为5-18位之间字母数字下划线",
        "account" => ":attribute必须为5-18位之间字母数字 ,且第一位为字母",
        "array_isInt" => ":attribute 成员必须都为整数"
    ];
    if (count($addTypeMsg) > 0) {
        $typeMsg = array_merge($typeMsg, $addTypeMsg);
    }

    $validateMessage = [];

    foreach ($arrName as $key => $VALUE) {
        $parts = explode("|", $key);
        $key2 = $parts[0];   //只要第一个 左边是键名
        //  把所有类型默认提示都放进去
        $validateMessage[$key2] = $typeMsg;
    }
    return $validateMessage;
}

/**给字段赋值默认规则 如果已有规则, 不修改
 * @param array $arrkey
 * @return array
 */
function getKeyDefaultRule(array $arrkey): array
{
    $DefaultRule = [
        "id" => "require|number",
        "guid" => "require|length:32",
        "user" => "require|account",
        "password" => "require|password",
        "newPassword" => "require|password",
        "sort" => "number",


        //分页相关通用规则
        "size" => "must|between:1,100",
        "page" => "must|number",
        "order" => "between:0,127",
        "keyword" => "must|chsDash|max:50",           //搜索关键字

        //文章表相关
        "articleId" => "require|number",     //必须有值且只能为数字
        "moduleId" => "require",     //必须有值且只能为数字
        "status" => "must|between:0,127",     //必须有键名且值只能为数字


        //广告相关
        "positionId" => "require|number",     //必须有值且只能为数字


        //友情链接
        "groupId" => "require|number",     //必须有值且只能为数字


    ];

    $Rule = $arrkey;
    foreach ($arrkey as $key => $VALUE) {
        $parts = explode("|", $key);
        $key2 = $parts[0];   //只要第一个

        // 如果有这个字段的默认规则,且该字段没单独设置,则设置默认规则
        if (array_key_exists($key2, $DefaultRule) && $VALUE == "") {
            $Rule[$key] = $DefaultRule[$key2];
        }
    }


    return $Rule;

}
