<?php
/**发送短信
 * @param $phone //手机号
 * @param $signId //短信模板签名id
 * @param array $value //替换参数
 * @return string
 */
function sms_send($phone, $signId, array $value): array
{

    //加入短信发送时间列表  //待加锁处理,全局唯一锁,不同请求不同时间,不同脚本,使用同一个锁 锁驻留内存
    $values = cache()->get("sendSmsTime_" . $phone);
    if ($values) {
        $values[] = time();
    } else {
        $values = [time()];
    }
    cache()->set("sendSmsTime_" . $phone, $values, 86400); //暂时只记录24小时
    return [];
}


/**取指定秒数内已发送短信数量
 * @param $phone //手机号
 * @param $s //指定秒数内
 */
function sms_getSendCount($phone, int $s): int
{
    $values = cache()->get("sendSmsTime_" . $phone);
    $count = 0;
    $startTime = time() - $s;
    foreach (array_reverse($values) as $time) {
        if ($time > $startTime) {
            $count++;
        } else {
            break;
        }
    }

    return $count;
}