<?php

if (! function_exists('setting'))
{
    /*
     * 获取配置
     */
    function setting($key,$pid=null)
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "itemKey"=>$key,
        );
        if (isset($pid)){
            $paramsObj->params["pid"]=$pid;
        }
        $checkResult=app("L_Common_caches")->getSetting($paramsObj);
        if($checkResult["error_no"]=="0"){
            return $checkResult["result"];
        }
        return "";
    }
}

if (! function_exists('siteSetting'))
{
    /*
     * 获取网站配置
     */
    function siteSetting($key)
    {
        return setting($key,1);
    }
}

if (! function_exists('seoSetting'))
{
    /*
     * 获取网站seo配置
     */
    function seoSetting($key)
    {
        return setting($key,2);
    }
}

if (! function_exists('extendSetting'))
{
    /*
     * 获取扩展配置
     */
    function extendSetting($key)
    {
        return setting($key,4);
    }
}

if (! function_exists('xnSetting'))
{
    /*
     * 获取性能优化配置
     */
    function xnSetting($key)
    {
        return setting($key,3);
    }
}

if (! function_exists('module'))
{
    /*
     * 获取模块数据
     */
    function module($id="",$key="",$print=false)
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "id"=>$id,
            "print"=>$print,
            "itemKey"=>$key,
        );
        $checkResult=app("L_Common_caches")->getModule($paramsObj);
        if($checkResult["error_no"]=="0"){
            return $checkResult["result"];
        }
        return "";
    }
}

if (! function_exists('category'))
{
    /*
     * 获取模块数据
     */
    function category($dataType="",$dataId="",$key="",$print=false)
    {
        $paramsObj=paramsObj();
        $paramsObj->params=array(
            "dataType"=>$dataType,
            "dataId"=>$dataId,
            "print"=>$print,
            "itemKey"=>$key,
        );
        $checkResult=app("L_Common_caches")->getCategory($paramsObj);
        if($checkResult["error_no"]=="0"){
            return $checkResult["result"];
        }
        return "";
    }
}
