<?php
if (!function_exists('array_isInt')) {
    /**数组成员是否都是整数型
     * @param $arr
     * @return bool
     */
    function array_isInt($arr)
    {
        foreach ($arr as $value) {
            if (!is_int($value)) {
                return false;
            }
        }
        return true;
    }
}



if (!function_exists('isset2')) {
    /**弹出成员,失败弹默认值
     * @param $arr
     * @return bool
     */
    function isset2($arr, $key, $default = "")
    {

        if (isset($arr[$key])) {
            return $arr[$key];
        }
        return $default;
    }
}


if (!function_exists('array_path')) {
    /**嵌套数组获取路径,支持默认值和检测键值  像json取值一样,获取嵌套数组值
     * @param $arr
     * @return
     */
    function array_path($array, $path, $defaultValue = null)
    {
        if (!is_array($array)){
            return  $defaultValue;
        }

        $keys = explode('.', $path);
        $value = $array;

        foreach ($keys as $key) {
            if (isset($value[$key])) {
                $value = $value[$key];
            } else {
                return $defaultValue;
            }
        }

        return $value;
    }
}

if (!function_exists('array_equally')) {
    /**数组 是否一样, 成员数量相同,所有相同键名的值相同  不判断类型
     * @param $arr
     * @return bool
     */
    function array_equally($arr1, $arr2)
    {
        if (count($arr1) != count($arr2)) {
            return false;
        }

        foreach ($arr1 as $key => $value) {

            if (!isset($arr2[$key])) {
                return false;
            }

            if ($value != $arr2[$key]) {  //可以转换类型
                return false;
            }
        }
        return true;
    }
}


if (!function_exists('array_equally')) {
    /**数组 是否一样, 成员数量相同,所有相同键名的值相同  不判断类型
     * @param $arr
     * @return bool
     */
    function array_equally($arr1, $arr2)
    {
        if (count($arr1) != count($arr2)) {
            return false;
        }

        foreach ($arr1 as $key => $value) {

            if (!isset($arr2[$key])) {
                return false;
            }

            if ($value != $arr2[$key]) {  //可以转换类型
                return false;
            }
        }
        return true;
    }
}
if (!function_exists('array_getKeys')) {
    /** 二维数组,获取所有成员的指定key,合并并返回为一个新数组
     * @param $arr
     * @return
     */
    function array_getKeys($array,$key) {
        $keys = [];

        foreach ($array as $item) {
            if (isset($item[$key])) {
                $keys[] = $item[$key];
            }
        }

        return $keys;
    }
}
