<?php

namespace app\db\index;

class D_setting
{
    /**
     * 所有数据
     * @param string $paramObj
     */
    public function allData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'pid' => 'integer',
                'field' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $dataDefault["pid"]=0;
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $dataObj->data->default=array();
            if(in_array($dataObj->request->pid,array(1,2,3,4))){
                //系统数据
                $dataObj->data->default=config("setting.{$dataObj->request->pid}",array());
            }else{
                //获取模型类型
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    "id"=>$dataObj->request->pid,
                    "field"=>"module",
                );
                $checkResult=app("S_Admin_module")->info($paramsObj);
                if($checkResult["error_no"]==0){
                    $result=$checkResult["result"];
                    if($result){
                        $dataObj->data->default=config("setting.{$result["module"]}",$dataObj->data->default);
                    }
                }else{
                    $final_arr=logCallErrorMsg($final_arr,$checkResult);
                }
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            if(is_numeric($dataObj->request->pid) && $dataObj->request->pid >0){
                $condition[]=array(
                    "pid","=",$dataObj->request->pid
                );
            }else{
                $condition[]=array(
                    "pid","!=","0"
                );
            }
            try{
                $result=Db()->name(app("cmsTable")::setting())->field($dataObj->request->field)->where($condition)->select();
                if($result){
                    $temp=array();
                    foreach($result as $val){
                        $temp[$val["pid"]][$val["itemKey"]]=$val["itemValue"];
                        if($dataObj->data->default){
                            $temp[$val["pid"]]=array_merge($dataObj->data->default,$temp[$val["pid"]]);
                        }
                    }
                    $result=$temp;
                }else{
                    if($dataObj->data->default){
                        $result[$dataObj->request->pid]=$dataObj->data->default;
                    }
                }
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情 by itemKey
     * @param string $paramObj
     */
    public function infoByItemKey($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=new \ArrayObject();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'itemKey' => 'require',
                'pid' => 'require',
                'field' => '',
                'verify' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();
            $condition[]=array(
                "itemKey","=",$dataObj->request->itemKey
            );
            if($dataObj->request->pid){
                $condition[]=array(
                    "pid","=",$dataObj->request->pid
                );
            }

            try{
                $result=Db()->name(app("cmsTable")::setting())->field($dataObj->request->field)->where($condition)->find();
                if($dataObj->request->verify){
                    if(empty($result)){
                        $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::DATA_NOT_EXIST,lang("sys.dataNotExists"));
                    }
                }
                if($final_arr["error_no"]==0 && $result){
                    $final_arr["result"]=$result;
                }
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name,$arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING,app("errorCode")::UNDEFINED_METHOD,lang("sys.noMethodDefined"),$name,$arguments);
    }
}