<?php

namespace app\db\index;

class D_goods
{
    /**
     * 信息格式化
     */
    private function detailed($Result,$url, $format="1")
    {
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = $Result['createTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']):"";
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = $Result['updateTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']):"";
        }
        // 上架时间
        if (isset($Result['upTime'])) {
            $Result['upTimeFormat'] = $Result['upTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['upTime']):"";
        }
        // 下架时间
        if (isset($Result['downTime'])) {
            $Result['downTimeFormat'] = $Result['downTime']?app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['downTime']):"";
        }
        // 状态
        if (isset($Result['status'])) {
            $statusMap=array();
            $statusMap["0"]="上架";
            $statusMap["1"]="下架";
            $statusMap["2"]="申请上架";
            $Result['statusFormat'] = isset($statusMap[$Result['status']])?$statusMap[$Result['status']]:"";
        }
        // 规格
        if (isset($Result['specMap'])) {
            $Result['specMapFormat'] = $Result['specMap']?toJsonDecode($Result['specMap']):"";
        }
        // 虚拟配置
        if (isset($Result['virtualConfig'])) {
            $Result['virtualConfigFormat'] = $Result['virtualConfig']?toJsonDecode($Result['virtualConfig']):"";
        }
        // 共享商品
        if (isset($Result['isShare'])) {
            $isShareMap=array();
            $isShareMap["0"]="否";
            $isShareMap["1"]="是";
            $Result['isShareFormat'] = isset($isShareMap[$Result['isShare']])?$isShareMap[$Result['isShare']]:"";
        }
        // 虚拟商品类型
        if (isset($Result['virtualType'])) {
            $virtualTypeMap=array();
            $virtualTypeMap["1"]="插件";
            $Result['virtualTypeFormat'] = isset($virtualTypeMap[$Result['virtualType']])?$virtualTypeMap[$Result['virtualType']]:"";

            if (isset($Result['virtualConfig'])) {
                $virtualConfig=$Result['virtualConfig']?toJsonDecode($Result['virtualConfig']):array();
                if($virtualConfig){
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'condition' => array(
                            array(
                                "id","=",$virtualConfig['id'],
                            ),
                        ),
                        'field' => 'id,`name`,`desc`,guid',
                        'table' => 'plugin',
                    );
                    $pluginData=app("C_Common_row_data")->info($paramsObj);
                    $Result['pluginData'] = $pluginData;
                    $Result['pluginData']["isValid"]=0;

                    $urlMap=parse_url($url);
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'domain' => $urlMap["host"],
                        'pluginId' => $virtualConfig['id'],
                        'field' => "expireMin,expireMax,isPermanent",
                    );
                    $tempResult=app("S_Admin_plugin_status")->infoForUnique($paramsObj);
                    if($tempResult["error_no"]=="0"){
                        if($tempResult["result"]){
                            $Result['pluginData']["isValid"]=$tempResult["result"]["isValid"];
                        }
                    }
                }
            }
        }
        // 虚拟商品
        if (isset($Result['isVirtual'])) {
            $isVirtualMap=array();
            $isVirtualMap["0"]="否";
            $isVirtualMap["1"]="是";
            $Result['isVirtualFormat'] = isset($isVirtualMap[$Result['isVirtual']])?$isVirtualMap[$Result['isVirtual']]:"";
        }
        // 虚拟商品
        if (isset($Result['isDel'])) {
            $isDelMap=array();
            $isDelMap["0"]="否";
            $isDelMap["1"]="是";
            $Result['isDelFormat'] = isset($isDelMap[$Result['isDel']])?$isDelMap[$Result['isDel']]:"";
        }
        // 插件id
        if (isset($Result['categoryId'])) {
            $paramsObj=paramsObj();
            $paramsObj->params=array(
                'condition' => array(
                    array(
                        "id","=",$Result['categoryId'],
                    ),
                ),
                'field' => 'name',
                'table' => 'category',
                'resultField' => 'name',
            );
            $categoryIdFormat=app("C_Common_row_data")->info($paramsObj);
            $Result['categoryIdFormat'] = $categoryIdFormat;
        }
        // 返回结果
        return $Result;
    }

    /**
     * 列表数据
     * @param string $paramObj
     */
    public function listData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'url' => '',
                'virtualType' => '',
                'categoryId' => '',
                'name' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"]="*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "status", "=", "0"
            );
            if ($dataObj->request->name) {
                $condition[] = array(
                    "name", "like", "%{$dataObj->request->name}%"
                );
            }
            if ($dataObj->request->virtualType) {
                $condition[] = array(
                    "virtualType", "=", $dataObj->request->virtualType
                );
            }
            if ($dataObj->request->categoryId) {
                $condition[] = array(
                    "categoryId", "=", $dataObj->request->categoryId
                );
            }
            try {
                $result = Db()->name(app("cmsTable")::goods())->field($dataObj->request->field)->order("sort","asc")->order("id","desc")->where($condition)->paginate();
                if ($result && $result["data"]) {
                    foreach ($result["data"] as $key => $val) {
                        if ($dataObj->request->format) {
                            $result["data"][$key] = $this->detailed($val,$dataObj->request->url, $dataObj->request->format);
                        }
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}