<?php

namespace app\db\index;

class D_category
{
    /**
     * 信息格式化
     */
    protected function detailed($Result, $format="1")
    {
        // 创建时间
        if (isset($Result['createTime'])) {
            $Result['createTimeFormat'] = app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['createTime']);
        }
        // 更新时间
        if (isset($Result['updateTime'])) {
            $Result['updateTimeFormat'] = app("ltcmsTime")::getDateTime('Y-m-d H:i:s', $Result['updateTime']);
        }
        // 状态
        if (isset($Result['disabled'])) {
            $disabledMap = array();
            $disabledMap["1"] = "开启";
            $disabledMap["0"] = "禁用";
            $Result['disabledFormat'] = isset($disabledMap[$Result['disabled']]) ? $disabledMap[$Result['disabled']] : "";
        }
        // 链接地址
        $Result['linkUrl'] = categoryLinkUrl($Result);
        // 返回结果
        return $Result;
    }

    /**
     * 所有数据
     * @param string $paramObj
     */
    public function allData($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'dataType' => 'require',
                'fieldIndex' => '',
                'name' => '',
                'disabled' => '',
                'pid' => '',
                'field' => '',
            );
            $dataDefault=array();
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition = array();
            $condition[] = array(
                "dataType", "=", $dataObj->request->dataType
            );
            if ($dataObj->request->fieldIndex) {
                $condition[] = array(
                    "fieldIndex", "=", $dataObj->request->fieldIndex
                );
            }
            if (is_numeric($dataObj->request->disabled)) {
                $condition[] = array(
                    "disabled", "=", $dataObj->request->disabled
                );
            }
            if (is_numeric($dataObj->request->pid)) {
                $condition[] = array(
                    "pid", "=", $dataObj->request->pid
                );
            }
            if ($dataObj->request->name) {
                $condition[] = array(
                    "name", "like", "%{$dataObj->request->name}%"
                );
            }
            try{
                $result=Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->order("sort","asc")->select();
                $return=array();
                if($result) {
                    foreach ($result as $key => $val) {
                        $return[] = $this->detailed($val);
                    }
                }
                $final_arr["result"]=$return;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'id' => 'require',
                'field' => '',
                'verify' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            try {
                $result = Db()->name(app("cmsTable")::category())->field($dataObj->request->field)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    $final_arr["result"] =$this->detailed($result);
                }
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}