<?php

namespace app\db\index;

class D_articleType
{
    /**
     * 获取所有数据
     * @param string $paramObj
     */
    public function getAll($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            try{
                $result=Db()->name(app("cmsTable")::articleType())->select();
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 信息格式化
     */
    protected function detailed($Result, $format)
    {
        $Result["linkUrl"]=urlRuleParse('article_type',$Result);
        // 返回结果
        return $Result;
    }

    /**
     * 文章类型列表数据
     * @param string $paramObj
     */
    public function getList($paramObj=""){
        $dataObj=paramsObj();
        $dataObj->request=paramsObj();
        $dataObj->data=paramsObj();
        $dataObj->data->use_trans=false;
        $dataObj->result=array();

        $final_arr=logInit();
        if($final_arr["error_no"]==0){
            $mixed=parseToArr($paramObj,"mixed",0);
            $params=parseToArr($paramObj,"params",array());
            $messages=parseToArr($paramObj,"messages",array());
            $rules=array(
                'order' => '',
                'pid' => '',
                'name' => '',
                'disabled' => '',
                'field' => '',

            );
            $dataDefault=array(
                'pid' => '-1',
                'order' => '0',
            );
            $dataDefault["field"]="*";
            $paramsObj=paramsObj();
            $paramsObj->params=$params;
            $paramsObj->mixed=$mixed;
            $paramsObj->rules=$rules;
            $paramsObj->messages=$messages;
            $paramsObj->dataDefault=$dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if($checkResult["error_no"]==0){
                $dataObj->request=$checkResult["result"];
            }else{
                $final_arr=logCallErrorMsg($final_arr,$checkResult);
            }
        }
        if($final_arr["error_no"]==0){
            $condition=array();

            if($dataObj->request->pid>=0){
                $condition[]=array(
                    "pid","=",$dataObj->request->pid
                );
            }

            if($dataObj->request->name){
                $condition[]=array(
                    "name","like","%{$dataObj->request->name}%"
                );
            }
            if($dataObj->request->disabled){
                $condition[]=array(
                    "disabled","=",$dataObj->request->disabled
                );
            }
            //处理 排序  设置默认0
            $sortColumn = "sortWeights";
            $sortDirection = $dataObj->request->order % 2===1?"ASC" : "DESC";   //单数升序 双数降序 0也为降序

            switch ($dataObj->request->order) {
                case 1:
                case 2:  // id 升序
                    $sortColumn = "id";
                    break;
                case 3:   // 排序权重 升序
                case 4:   // 排序权重 升序
                    $sortColumn = "sortWeights";
                    break;
            }

            try{
                $result=Db()->name(app("cmsTable")::articleType())->order($sortColumn,$sortDirection)->field($dataObj->request->field)->where($condition)->select();
                if ($result) {
                    foreach ($result as $key => $val) {
                        $result[$key] = $this->detailed($val, 1);
                    }
                }
                $final_arr["result"]=$result;
            }catch (\Throwable $e){
                $final_arr=recordLogMsgLevelTwo(app("errorLevel")::E_ERROR,app("errorCode")::SQL_ERROR,lang("sys.error"),$e->getMessage());
            }
        }
        return $final_arr;
    }

    public function __call($name, $arguments)
    {
        return recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::UNDEFINED_METHOD, lang("sys.noMethodDefined"), $name, $arguments);
    }
}