<?php

namespace app\db\index;

use app\db\D_article as D_article_base;
use ltcms\db\Db;

class D_article extends D_article_base
{
    /**
     * 信息格式化
     */
    protected function detailed($Result, $format="1")
    {
        // 内容
        if (isset($Result['content'])) {
            $Result['content'] = htmlspecialchars_decode(dstripslashes($Result['content']));
        }
        // 文章分类
        if (isset($Result['categoryId']) && isset($Result['moduleId'])) {
            $moduleData=module($Result['moduleId']);
            $categoryData=$Result['categoryId']?category('module',$Result['moduleId'],$Result['categoryId']):array();
            if($categoryData){
                $categoryData["linkUrl"]=$moduleData['linkUrl'].$categoryData['linkurl'];
                $Result["categoryName"]=$categoryData["name"];
                $Result["categoryLinkUrl"]=$categoryData["linkUrl"];
            }else{
                $Result["categoryName"]="";
                $Result["categoryLinkUrl"]="";
            }
        }
        $Result["linkUrl"]=articleLinkUrl($Result);
        // 返回结果
        return $Result;
    }

    /** 获取相关文章
     * @param int $moduleId 分类id
     * @param array $webKeyWords 关键字数组
     * @param $size //数量
     * @return array
     */
    public function getCorrelationList($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require|integer|gt:0',
                'webKeyWords' => 'array',
                'size' => 'number',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "id,moduleId,title,thumb,addTime,description,categoryId,linkUrl";
            $dataDefault["size"] = 10;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $sql = "SELECT  " . $dataObj->request->field . "   FROM " . app("cmsTable")::article($dataObj->request->moduleId);
            $where = [];
            $bind = [];

            $where[] = "status=3";
            $where[] = "recycle=1";

            if (count($dataObj->request->webKeyWords) > 0) {
                //  guid LIKE "6%"  OR  guid LIKE "3%"
                $whereOR = [];
                foreach ($dataObj->request->webKeyWords as $key => $value) {
                    $whereOR[] = "webKeyWords like ?";
                    $bind[] = "%$value%";
                }

                //处理or条件
                $OrCount = count($whereOR);
                if ($OrCount > 0) {
                    $where[] = ($OrCount == 1 ? "" : "(") . implode(" OR ", $whereOR) . ($OrCount == 1 ? "" : ")");
                }
            }

            //处理条件
            if (count($where) > 0) {
                $sql .= " WHERE ";
                $sql .= implode(" AND ", $where);
            }

            //处理 排序
            $sql .= " ORDER BY id DESC ";
            //处理分页
            $sizeStart = 0;
            $sql .= " LIMIT $sizeStart," . $dataObj->request->size;
            try {
                $result = Db()->bindValue($bind)->select($sql);
                if ($result) {
                    foreach ($result as $key => $val) {
                        $result[$key] = $this->detailed($val, 1);
                    }
                }
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取数据详情
     * @param string $paramObj
     */
    public function info($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require|number',
                'id' => 'require|number',
                'field' => '',
                'verify' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $dataDefault["verify"] = "1";
            $dataDefault["format"] = "1";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "id", "=", $dataObj->request->id
            );
            $condition[] = array(
                "recycle", "=", 1
            );
            try {
                $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->where($condition)->find();
                if ($dataObj->request->verify) {
                    if (empty($result)) {
                        $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                    }
                }
                if ($final_arr["error_no"] == 0 && $result) {
                    $final_arr["result"] = $result;
                    $condition = array();
                    $condition[] = array(
                        "id", "=", $dataObj->request->id,
                    );
                    $result = Db()->name(app("cmsTable")::articleData($dataObj->request->moduleId))->where($condition)->find();
                    if ($dataObj->request->verify) {
                        if (empty($result)) {
                            $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_WARNING, app("errorCode")::DATA_NOT_EXIST, lang("sys.dataNotExists"));
                        }
                    }
                    if ($final_arr["error_no"] == 0 && $result) {
                        $final_arr["result"]["content"] = $result["articleContent"];
                    }
                }
                if ($dataObj->request->format) {
                    $final_arr["result"] = $this->detailed($final_arr["result"], $dataObj->request->format);
                }

            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取多个数据详情
     * @param string $paramObj
     */
    public function infos($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require|number',
                'id' => 'require',
                'detailed' => '',
                'field' => '',
                'format' => '',
            );
            $dataDefault = array();
            $dataDefault["detailed"] = "0";
            $dataDefault["field"] = "*";
            $dataDefault["format"] = "1";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition = array();
            $condition[] = array(
                "id", "in", $ids
            );
            $condition[] = array(
                "recycle", "=", 1
            );
            try {
                $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->where($condition)->select();

                if ($final_arr["error_no"] == 0 && $result && $dataObj->request->detailed) {
                    foreach ($result as $k => $v) {
                        $condition = array();
                        $condition[] = array(
                            "id", "=", $v["id"],
                        );
                        $result = Db()->name(app("cmsTable")::articleData($dataObj->request->moduleId))->where($condition)->find();
                        if ($result) {
                            $result["content"] = $result["articleContent"];
                        }
                    }
                }

                $final_arr["result"] = $result;
                if ($dataObj->request->format) {
                    foreach ($final_arr["result"] as $k => $v) {
                        $final_arr["result"][$k] = $this->detailed( $final_arr["result"][$k], $dataObj->request->format);
                    }
                }

            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 获取文件推荐信息
     * @return array
     */
    public function getRecommend($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => '',
                'categoryId' => '',
                'size' => 'number',
                'level' => 'require|number',
                'print' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //如果 moduleId 为空则获取所有模型
            if (!$dataObj->request->moduleId) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "module" => "article",
                );
                $checkResult = app("S_Index_module")->getDataByType($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $dataObj->data->moduleIds = $checkResult["result"];
                }
            } else {
                $dataObj->data->moduleIds = is_array($dataObj->request->moduleId) ? $dataObj->request->moduleId : explode(",", $dataObj->request->moduleId);
            }
        }
        if ($final_arr["error_no"] == 0 && $dataObj->data->moduleIds) {
            $condition = array();
            $condition[] = array(
                "status", "=", 3
            );
            $condition[] = array(
                "recycle", "=", 1
            );
            if($dataObj->request->categoryId){
                $condition[] = array(
                    "categoryId", "=", $dataObj->request->categoryId
                );
            }
            $paramsObj = paramsObj();
            $paramsObj->params = array(
                'moduleId' => $dataObj->data->moduleIds,
                'commendId' => $dataObj->request->level,
            );
            $checkResult = app("S_Admin_commendModuleData")->getData($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $result = $checkResult["result"];
                $return = array();
                if ($result) {
                    $tmp = array();
                    foreach ($result as $val) {
                        $tmp[$val["moduleId"]][] = $val["dataId"];
                    }
                    $articleData = array();
                    foreach ($tmp as $key => $val) {
                        if ($final_arr["error_no"] == 0) {
                            $tempCondition = $condition;
                            $tempCondition[] = array(
                                "id", "in", $val
                            );
                            $data = Db()->name(app("cmsTable")::article($key))->field($dataObj->request->field)->where($tempCondition)->select();
                            $tempData = array();
                            if ($data) {
                                foreach ($data as $dval) {
                                    $tempData[$dval["id"]] = $dval;
                                }
                                $articleData[$key] = $tempData;
                            }
                        }
                        if ($final_arr["error_no"]) {
                            break;
                        }
                    }
                    foreach ($result as $val) {
                        if (isset($articleData[$val["moduleId"]][$val["dataId"]])) {
                            $return[] = $this->detailed($articleData[$val["moduleId"]][$val["dataId"]], 1);
                        }
                    }
                }
                $final_arr["result"] = $return;
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        return $final_arr;
    }

    /**
     * 获取文章数据
     * @return array
     */
    public function articleData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => '', //指定模块
                'categoryId' => '', //指定分类
                'level' => '', //指定推荐级别
                'order' => '', //指定排序方式
                'offset' => 'number',
                'limit' => 'number',
                'size' => 'number',
                'thumb' => 'number',
                'addTime' => '',
                'addTimeCon' => '',
                'print' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $dataDefault["addTimeCon"] = ">=";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //如果 moduleId 为空则获取所有模型
            if (!$dataObj->request->moduleId) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "module" => "article",
                );
                $checkResult = app("S_Index_module")->getDataByType($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $dataObj->data->moduleIds = $checkResult["result"];
                }
            } else {
                $dataObj->data->moduleIds = is_array($dataObj->request->moduleId) ? $dataObj->request->moduleId : explode(",", $dataObj->request->moduleId);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $dataObj->data->commendModule=array();
            if($dataObj->request->level){
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    'moduleId' => $dataObj->data->moduleIds,
                    'commendId' => $dataObj->request->level,
                );
                $checkResult = app("S_Admin_commendModuleData")->getData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $commendModuleResult = $checkResult["result"];
                    if ($commendModuleResult) {
                        $tmp = array();
                        foreach ($commendModuleResult as $val) {
                            $tmp[$val["moduleId"]][] = $val["dataId"];
                        }
                        $dataObj->data->commendModule=$tmp;
                    }
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0 && $dataObj->data->moduleIds) {
            $condition = array();
            $condition[] = array(
                "status", "=", 3
            );
            $condition[] = array(
                "recycle", "=", 1
            );
            if($dataObj->request->categoryId){
                $condition[] = array(
                    "categoryId", "=", $dataObj->request->categoryId
                );
            }
            if($dataObj->request->thumb){
                $condition[] = array(
                    "thumb", "!=", ""
                );
            }
            if($dataObj->request->addTime){
                $addTime=is_numeric($dataObj->request->addTime)?$dataObj->request->addTime:app("ltcmsTime")::getTime($dataObj->request->addTime);
                $condition[] = array(
                    "addTime", $dataObj->request->addTimeCon, $addTime
                );
            }
            $order=array();
            if($dataObj->request->order=="new"){
                $order=array(
                    "id"=>"desc"
                );
            }else if($dataObj->request->order=="hot"){
                $order=array(
                    "hits"=>"desc"
                );
            }

            if(isset($dataObj->request->size)){
                $dataObj->data->size=$dataObj->request->size;
            }else if(isset($dataObj->request->limit)){
                $dataObj->data->size=$dataObj->request->limit;
            }else{
                $dataObj->data->size=$dataObj->request->offset;
            }
            $allData=array();
            foreach($dataObj->data->moduleIds as $moduleId){
                if ($final_arr["error_no"] == 0) {
                    $tempCondition=$condition;
                    if(isset($dataObj->data->commendModule[$moduleId])){
                        $tempCondition[] = array(
                            "id", "in", $dataObj->data->commendModule[$moduleId]
                        );
                    }
                    $data = Db()->name(app("cmsTable")::article($moduleId))->field($dataObj->request->field)->where($tempCondition)->order($order)->limit($dataObj->request->offset,$dataObj->request->limit)->select();
                    $allData=array_merge($allData,$data);
                }
                if ($final_arr["error_no"]) {
                    break;
                }
            }
            if ($final_arr["error_no"] == 0) {
                if($dataObj->request->order=="rand"){
                    shuffle($allData); //打乱数组顺序
                }
                if($dataObj->data->size){
                    $allData=array_slice($allData,0,$dataObj->request->size);
                }
                //格式化数据
                foreach ($allData as $key=>$val) {
                    $allData[$key]=$this->detailed($val);
                }
                $final_arr["result"]=$allData;
            }
        }
        return $final_arr;
    }

    /**
     * 获取 - 标签数据
     * @return array
     */
    public function tagData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require', //指定模块
                'categoryId' => '', //指定分类
                'level' => '', //指定推荐级别
                'order' => '', //指定排序方式
                'thumb' => 'number',
                'addTime' => '',
                'addTimeCon' => '',
                'print' => '',
                'field' => '',
                'dataType' => '',
                'offset' => 'number',
                'limit' => 'number',
                'size' => 'number',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $dataDefault["addTimeCon"] = ">=";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $dataObj->data->commendModule=array();
            if($dataObj->request->level){
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    'moduleId' => $dataObj->request->moduleId,
                    'commendId' => $dataObj->request->level,
                );
                $checkResult = app("S_Admin_commendModuleData")->getData($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $commendModuleResult = $checkResult["result"];
                    if ($commendModuleResult) {
                        $tmp = array();
                        foreach ($commendModuleResult as $val) {
                            $tmp[$val["moduleId"]][] = $val["dataId"];
                        }
                        $dataObj->data->commendModule=$tmp;
                    }
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "status", "=", 3
            );
            $condition[] = array(
                "recycle", "=", 1
            );
            if($dataObj->request->thumb){
                $condition[] = array(
                    "thumb", "!=", ""
                );
            }
            if($dataObj->request->addTime){
                $addTime=is_numeric($dataObj->request->addTime)?$dataObj->request->addTime:app("ltcmsTime")::getTime($dataObj->request->addTime);
                $condition[] = array(
                    "addTime", $dataObj->request->addTimeCon, $addTime
                );
            }
            $order=array();
            if($dataObj->request->order=="new"){
                $order=array(
                    "id"=>"desc"
                );
            }else if($dataObj->request->order=="hot"){
                $order=array(
                    "hits"=>"desc"
                );
            }
            if(isset($dataObj->request->size)){
                $dataObj->data->size=$dataObj->request->size;
            }else if(isset($dataObj->request->limit)){
                $dataObj->data->size=$dataObj->request->limit;
            }else{
                $dataObj->data->size=$dataObj->request->offset;
            }
            if($dataObj->request->dataType=="1"){
                //查询同级数据
                $categoryId=0;
                if($dataObj->request->categoryId){
                    //获取分类信息
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'id' => $dataObj->request->categoryId,
                        'field' => "pid",
                    );
                    $checkResult=app("S_Index_category")->info($paramsObj);
                    if($checkResult["error_no"]=="0"){
                        $categoryRowResult=$checkResult["result"];
                        $categoryId=$categoryRowResult["pid"];
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
                if ($final_arr["error_no"] == 0) {
                    //获取下面的子分类ID
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'dataType' => 'module',
                        'dataId' => $dataObj->request->moduleId,
                        'pid' => $categoryId,
                    );
                    $checkResult=app("S_Index_category")->allData($paramsObj);
                    if($checkResult["error_no"]=="0"){
                        $dataObj->data->categoryResult=$checkResult["result"];
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }else if($dataObj->request->dataType=="2"){
                //查询本身数据
                if($dataObj->request->categoryId){
                    //获取所有分类ID
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'id' => $dataObj->request->categoryId,
                    );
                    $checkResult=app("S_Index_category")->info($paramsObj);
                    if($checkResult["error_no"]=="0"){
                        $categoryResult=$checkResult["result"];
                        $dataObj->data->categoryResult=array($categoryResult);
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }else{
                    $dataObj->data->categoryResult=array();
                }
            }else{
                //查询下级数据
                $categoryId=0;
                if($dataObj->request->categoryId){
                    $categoryId=$dataObj->request->categoryId;
                }
                if ($final_arr["error_no"] == 0) {
                    //获取下面的子分类ID
                    $paramsObj=paramsObj();
                    $paramsObj->params=array(
                        'dataType' => 'module',
                        'dataId' => $dataObj->request->moduleId,
                        'pid' => $categoryId,
                    );
                    $checkResult=app("S_Index_category")->allData($paramsObj);
                    if($checkResult["error_no"]=="0"){
                        $dataObj->data->categoryResult=$checkResult["result"];
                    }else{
                        $final_arr = logCallErrorMsg($final_arr, $checkResult);
                    }
                }
            }
            if(isset($dataObj->data->commendModule[$dataObj->request->moduleId])){
                $condition[] = array(
                    "id", "in", $dataObj->data->commendModule[$dataObj->request->moduleId]
                );
            }
            if($dataObj->data->categoryResult){
                foreach($dataObj->data->categoryResult as $catKey=>$catVal){
                    if ($final_arr["error_no"] == 0) {
                        $tmpCondition=$condition;
                        $paramsObj=paramsObj();
                        $paramsObj->params=array(
                            'dataType' => 'module_'.$dataObj->request->moduleId,
                            'parentId' => $catVal["id"],
                        );
                        $checkResult=app("S_Admin_categoryChild")->getChildIds($paramsObj);
                        if($checkResult["error_no"]=="0"){
                            $categoryIds=$checkResult["result"];
                            $categoryIds[]=$catVal["id"];
                            $tmpCondition[] = array(
                                "categoryId", "in", $categoryIds
                            );
                        }else{
                            $final_arr = logCallErrorMsg($final_arr, $checkResult);
                        }
                        if ($final_arr["error_no"] == 0) {
                            $data = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->where($tmpCondition)->limit($dataObj->request->offset,$dataObj->request->limit)->order($order)->select();
                            if($dataObj->request->order=="rand"){
                                shuffle($data); //打乱数组顺序
                            }
                            if($dataObj->data->size){
                                $data=array_slice($data,0,$dataObj->request->size);
                            }
                            //格式化数据
                            foreach ($data as $key=>$val) {
                                $data[$key]=$this->detailed($val);
                            }
                            $dataObj->data->categoryResult[$catKey]["child"]=$data;
                        }
                    }
                    if ($final_arr["error_no"]) {
                        break;
                    }
                }
            }else{
                //获取所有分类ID
                $paramsObj=paramsObj();
                $paramsObj->params=array(
                    'dataType' => 'module',
                    'dataId' => $dataObj->request->moduleId,
                    'field' => "id",
                );
                $checkResult=app("S_Index_category")->allData($paramsObj);
                if($checkResult["error_no"]=="0"){
                    $categoryResult=$checkResult["result"];
                    $categoryIds=array_column($categoryResult,"id");
                    $condition[] = array(
                        "categoryId", "in", $categoryIds
                    );
                }else{
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
                if ($final_arr["error_no"] == 0) {
                    $data = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->where($condition)->limit($dataObj->request->offset,$dataObj->request->limit)->order($order)->select();
                    if($dataObj->request->order=="rand"){
                        shuffle($data); //打乱数组顺序
                    }
                    if($dataObj->data->size){
                        $data=array_slice($data,0,$dataObj->request->size);
                    }
                    //格式化数据
                    foreach ($data as $key=>$val) {
                        $data[$key]=$this->detailed($val);
                    }
                    $dataObj->data->categoryResult=array(
                        array(
                            "child"=>$data
                        )
                    );
                }
            }
            if ($final_arr["error_no"] == 0) {
                //融合数据格式
                $final_arr["result"]=$dataObj->data->categoryResult;
            }
        }
        return $final_arr;
    }

    /**
     * 融合数据
     */
    public function fusionData($category,$article){
        $tmp_article=array();
        foreach($article as $val){
            $tmp_article[$val["categoryId"]][]=$val;
        }
        if($category){
            foreach($category as $key=>$val){
                $category[$key]["child"]=isset($tmp_article[$val["id"]])?$tmp_article[$val["id"]]:array();
            }
        }else{
            $category[0]["child"]=$article;
        }
        return $category;
    }

    /**
     * 随机数据
     * @return array
     */
    public function randData($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => '',
                'categoryId' => '',
                'size' => 'number',
                'print' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //如果 moduleId 为空则获取所有模型
            if (!$dataObj->request->moduleId) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "module" => "article",
                );
                $checkResult = app("S_Index_module")->getDataByType($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $dataObj->data->moduleIds = $checkResult["result"];
                }
            } else {
                $dataObj->data->moduleIds = is_array($dataObj->request->moduleId) ? $dataObj->request->moduleId : explode(",", $dataObj->request->moduleId);
            }
        }
        if ($final_arr["error_no"] == 0 && $dataObj->data->moduleIds) {
            $condition = array();
            $condition[] = array(
                "status", "=", 3
            );
            $condition[] = array(
                "recycle", "=", 1
            );
            if($dataObj->request->categoryId){
                $condition[] = array(
                    "categoryId", "=", $dataObj->request->categoryId
                );
            }
            $allData=array();
            foreach($dataObj->data->moduleIds as $moduleId){
                if ($final_arr["error_no"] == 0) {
                    $data = Db()->name(app("cmsTable")::article($moduleId))->field($dataObj->request->field)->where($condition)->limit($dataObj->request->size)->select();
                    $allData=array_merge($allData,$data);
                }
                if ($final_arr["error_no"]) {
                    break;
                }
            }
            if ($final_arr["error_no"] == 0) {
                shuffle($allData); //打乱数组顺序

                if($dataObj->request->size){
                    $allData=array_slice($allData,0,$dataObj->request->size);
                }
                //格式化数据
                foreach ($allData as $key=>$val) {
                    $allData[$key]=$this->detailed($val);
                }
                $final_arr["result"]=$allData;
            }
        }
        return $final_arr;
    }

    /**
     * 获取上一篇
     * @return array
     */
    public function pre($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'articleId' => 'require',
                'print' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取上一篇数据
            $condition = array();
            $condition[] = array(
                "id", "<", $dataObj->request->articleId,
            );
            $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->where($condition)->order("id","desc")->find();
            if($result){
                $result=array($this->detailed($result));
            }
            $final_arr["result"]=$result;
        }
        return $final_arr;
    }

    /**
     * 获取下一篇
     * @return array
     */
    public function next($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'articleId' => 'require',
                'print' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            //获取上一篇数据
            $condition = array();
            $condition[] = array(
                "id", ">", $dataObj->request->articleId,
            );
            $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->where($condition)->order("id","asc")->find();
            if($result){
                $result=array($this->detailed($result));
            }
            $final_arr["result"]=$result;
        }
        return $final_arr;
    }

    /**
     * 获取首页文章下边列表
     * @return array
     */
    public function getList($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();
        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require',
                'size' => 'number',
                'page' => 'number',
                'categoryId' => 'number',
                'print' => '',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "*";
            $dataDefault["size"] = "10";
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            $condition[] = array(
                "status", "=", 3
            );
            $condition[] = array(
                "recycle", "=", 1
            );
            if($dataObj->request->categoryId){
                $condition[] = array(
                    "categoryId", "=", $dataObj->request->categoryId
                );
            }
            //单条
            $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->field($dataObj->request->field)->order("id", "desc")->where($condition)->paginate(array("pageSize" => $dataObj->request->size,"page" => $dataObj->request->page));
            if ($result && $result["data"]) {
                foreach ($result["data"] as $key => $val) {
                    $result["data"][$key] = $this->detailed($val, 1);
                }
            }
            $final_arr["result"] = $result;
        }
        return $final_arr;
    }

    /** 获取热门文章列表 /就是特定时间内浏览量最多的
     * @return array
     */
    public function getHighClickList($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = array();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require|integer|gt:0',
                'page' => 'number',
                'size' => 'number',
                'addTime' => 'number',
                'field' => '',
            );
            $dataDefault = array();
            $dataDefault["field"] = "id,moduleId,title,thumb,description,attribute,hits,categoryId,linkUrl";
            $dataDefault["size"] = 10;
            $dataDefault["page"] = 1;
            $dataDefault["addTime"] = 0;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            $sql = "SELECT  " . $dataObj->request->field . "   FROM " . app("cmsTable")::article($dataObj->request->moduleId);
            $where = [];
            $bind = [];

            $where[] = "status=3";
            $where[] = "recycle=1";

            if ($dataObj->request->addTime != 0) {
                $where[] = "addTime>" . $dataObj->request->addTime;
            }

            //处理条件
            if (count($where) > 0) {
                $sql .= " WHERE ";
                $sql .= implode(" AND ", $where);
            }

            //处理 排序
            $sql .= " ORDER BY hits DESC ";
            //处理分页
            $sizeStart = $dataObj->request->page;
            $sql .= " LIMIT $sizeStart," . $dataObj->request->size;
            try {
                $result = Db()->bindValue($bind)->select($sql);
                $final_arr["result"] = $result;
            } catch (\Throwable $e) {
                $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
            }
        }
        return $final_arr;
    }

    /**
     * 增加点击数量
     * @param string $paramObj
     */
    public function uploadClickLogs($paramObj = "")
    {
        $dataObj = paramsObj();
        $dataObj->request = paramsObj();
        $dataObj->data = paramsObj();
        $dataObj->data->use_trans = false;
        $dataObj->result = new \ArrayObject();

        $final_arr = logInit();
        if ($final_arr["error_no"] == 0) {
            $mixed = parseToArr($paramObj, "mixed", 0);
            $params = parseToArr($paramObj, "params", array());
            $messages = parseToArr($paramObj, "messages", array());
            $rules = array(
                'moduleId' => 'require|integer|gt:0',
                'id' => 'require|integer',
                'hits' => 'require|integer',
                'verify' => '',
            );
            $dataDefault = array();
            $dataDefault["verify"] = 1;
            $paramsObj = paramsObj();
            $paramsObj->params = $params;
            $paramsObj->mixed = $mixed;
            $paramsObj->rules = $rules;
            $paramsObj->messages = $messages;
            $paramsObj->dataDefault = $dataDefault;
            $checkResult = app("verifyParam")::validatorRequest($paramsObj);
            if ($checkResult["error_no"] == 0) {
                $dataObj->request = $checkResult["result"];
            } else {
                $final_arr = logCallErrorMsg($final_arr, $checkResult);
            }
        }
        if ($final_arr["error_no"] == 0) {
            if ($dataObj->request->verify && !is_array($dataObj->request->id)) {
                $paramsObj = paramsObj();
                $paramsObj->params = array(
                    "moduleId" => $dataObj->request->moduleId,
                    "id" => $dataObj->request->id,
                    "verify" => 1,
                );
                $checkResult = $this->info($paramsObj);
                if ($checkResult["error_no"] == 0) {
                    $dataObj->info = $checkResult["result"];
                } else {
                    $final_arr = logCallErrorMsg($final_arr, $checkResult);
                }
            }
        }
        if ($final_arr["error_no"] == 0) {
            $condition = array();
            //判断 id是否为数组,如果是数组,返回id数组,如果不是数组,返回单成员数组
            $ids = is_array($dataObj->request->id) ? $dataObj->request->id : explode(",", $dataObj->request->id);
            $condition[] = array(
                "id", "IN", $ids
            );
            $data = array();
            //$data["hits"] = $dataObj->info["hits"] + 1;
            $data["hits"] = Db()->raw("hits+1");

            if ($data) {
                //$data["updateTime"] = (array_key_exists("addTime", $data) && $data["addTime"] > app("ltcmsTime")::getTime()) ? $data["addTime"] : app("ltcmsTime")::getTime();
                try {
                    $result = Db()->name(app("cmsTable")::article($dataObj->request->moduleId))->where($condition)->prepare(false)->data($data)->update();
                    $return = array();
                    $return["id"] = $dataObj->request->id;
                    $return["affected_rows"] = $result["affected_rows"];
                    $final_arr["result"] = $return;
                } catch (\Throwable $e) {
                    $final_arr = recordLogMsgLevelTwo(app("errorLevel")::E_ERROR, app("errorCode")::SQL_ERROR, lang("sys.error"), $e->getMessage());
                }
            } else {
                $return = array();
                $return["id"] = $dataObj->request->id;
                $return["affected_rows"] = 0;
                $final_arr["result"] = $return;
            }
        }
        return $final_arr;
    }
}